/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.jvm.dtfjview.ConsoleOutputChannel;
import com.ibm.jvm.dtfjview.FileOutputChannel;
import com.ibm.jvm.dtfjview.OutputChannel;
import java.util.Vector;

public class Output {
    Vector outputChannels = new Vector();
    long lastTimestamp = 0L;
    String lastPrompt = "";
    String lastInput = "";

    public void print(String outputString) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            ((OutputChannel)this.outputChannels.elementAt(i)).print(outputString);
        }
    }

    public void printPrompt(String prompt) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            ((OutputChannel)this.outputChannels.elementAt(i)).printPrompt(prompt);
        }
    }

    public void println(String outputString) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            ((OutputChannel)this.outputChannels.elementAt(i)).println(outputString);
        }
    }

    public void error(String outputString) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            ((OutputChannel)this.outputChannels.elementAt(i)).error(outputString);
        }
    }

    public void printInput(long timestamp, String prompt, String outputString) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            ((OutputChannel)this.outputChannels.elementAt(i)).printInput(timestamp, prompt, outputString);
        }
        this.lastTimestamp = timestamp;
        this.lastPrompt = prompt;
        this.lastInput = outputString;
    }

    public void addChannel(OutputChannel channel) {
        this.addChannel(channel, false);
    }

    public void addChannel(OutputChannel channel, boolean printLastInput) {
        this.outputChannels.add(channel);
        if (printLastInput) {
            channel.printInput(this.lastTimestamp, this.lastPrompt, this.lastInput);
        }
    }

    public void removeFileChannel() {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            if (!((OutputChannel)this.outputChannels.elementAt(i) instanceof FileOutputChannel)) continue;
            ((OutputChannel)this.outputChannels.elementAt(i)).close();
            this.outputChannels.removeElementAt(i);
        }
    }

    public void setConsoleNoPrint(boolean noPrint) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            if (!((OutputChannel)this.outputChannels.elementAt(i) instanceof ConsoleOutputChannel)) continue;
            ((ConsoleOutputChannel)this.outputChannels.elementAt(i)).setNoPrint(noPrint);
        }
    }

    public void close() {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            ((OutputChannel)this.outputChannels.elementAt(i)).close();
        }
    }
}

