/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMUtils;
import com.ibm.xml.enc.dom.TreeNodeSetData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransformUtil {
    public static final String PREFIX_XPATH2 = "xf";
    public static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String NS_XML = "http://www.w3.org/XML/1998/namespace";
    static final Iterator EMPTY_ITERATOR = new ListIterator(Collections.EMPTY_LIST);

    private TransformUtil() {
    }

    public static NodeSetData toNodeSet(Node node, boolean comments) throws URIReferenceException {
        if (node.getNodeType() == 9 && ((Document)node).getDocumentElement() == null) {
            throw new URIReferenceException("Invalid document: no root element.");
        }
        return new TreeNodeSetData(node, comments, null);
    }

    public static String getStringValue(Node node) throws MarshalException {
        StringBuffer buffer = null;
        String first = null;
        Node child = DOMUtils.getFirstChild2(node);
        while (child != null) {
            if (child.getNodeType() != 8 && child.getNodeType() != 7) {
                if (child.getNodeType() != 3 && child.getNodeType() != 4) {
                    throw new MarshalException("Text is expected: " + child.getNodeName());
                }
                if (first == null) {
                    first = child.getNodeValue();
                } else {
                    String next = child.getNodeValue();
                    if (buffer == null) {
                        buffer = new StringBuffer(first.length() + next.length());
                        buffer.append(first);
                    }
                    buffer.append(next);
                }
            }
            child = DOMUtils.getNextSibling2(child);
        }
        if (buffer != null) {
            return new String(buffer);
        }
        if (first != null) {
            return first;
        }
        return "";
    }

    static final Map initializeDecls(Node node) {
        HashMap<String, String> decls = new HashMap<String, String>();
        while (node != null) {
            NamedNodeMap map = node.getAttributes();
            int len = map == null ? 0 : map.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = map.item(i);
                String name = n.getNodeName();
                if (!name.startsWith("xmlns:") && !name.equals("xmlns") || decls.containsKey(name)) continue;
                decls.put(name, n.getNodeValue());
            }
            node = node.getParentNode();
        }
        if (decls.containsKey("xmlns") && "".equals(decls.get("xmlns"))) {
            decls.remove("xmlns");
        }
        return decls;
    }

    static final Map putDecls(Map parent, Node el) {
        int xmlnsIndex;
        NamedNodeMap map = el.getAttributes();
        int len = map.getLength();
        if (len == 0) {
            return parent;
        }
        Node n = null;
        String name = null;
        for (xmlnsIndex = 0; xmlnsIndex < len && !(name = (n = map.item(xmlnsIndex)).getNodeName()).startsWith("xmlns"); ++xmlnsIndex) {
        }
        if (xmlnsIndex == len) {
            return parent;
        }
        HashMap<String, String> newmap = new HashMap<String, String>(parent);
        while (true) {
            if (name.startsWith("xmlns:")) {
                newmap.put(name, n.getNodeValue());
            } else if (name.equals("xmlns")) {
                if (!n.getNodeValue().equals("")) {
                    newmap.put(name, n.getNodeValue());
                } else {
                    newmap.remove(name);
                }
            }
            if (++xmlnsIndex == len) break;
            n = map.item(xmlnsIndex);
            name = n.getNodeName();
        }
        return newmap;
    }

    public static final Map makePrefixMap(Node node) {
        HashMap<String, String> decls = new HashMap<String, String>();
        while (node != null) {
            NamedNodeMap map = node.getAttributes();
            int len = map == null ? 0 : map.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = map.item(i);
                String name = n.getNodeName();
                String prefix = null;
                if (name.startsWith("xmlns:")) {
                    prefix = n.getLocalName();
                } else if (name.equals("xmlns")) {
                    prefix = "";
                }
                if (prefix == null || decls.containsKey(prefix)) continue;
                decls.put(prefix, n.getNodeValue());
            }
            node = node.getParentNode();
        }
        if (decls.containsKey("") && "".equals(decls.get(""))) {
            decls.remove("");
        }
        return decls;
    }

    public static Vector fixTree(Node node) {
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        } else if (node.getNodeType() != 1) {
            throw new UnsupportedOperationException("Internal Error: fixTree() needs Document or Element");
        }
        Map context = TransformUtil.initializeDecls(node);
        context.put("xmlns:xml", NS_XML);
        Vector added = new Vector();
        TransformUtil.fixNode(node, context, added);
        return added;
    }

    private static void fixNode(Node elem, Map context, Vector decls) {
        if (elem.getNodeType() == 1) {
            Iterator iter = context.keySet().iterator();
            Element el = (Element)elem;
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (el.getAttributeNode(name) != null) continue;
                Attr ns = el.getOwnerDocument().createAttributeNS(NS_XMLNS, name);
                ns.setNodeValue((String)context.get(name));
                el.setAttributeNode(ns);
                decls.addElement(ns);
            }
            context = new HashMap<String, String>(context);
            NamedNodeMap map = el.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Node attr = map.item(i);
                String name = attr.getNodeName();
                if (!name.equals("xmlns") && !name.startsWith("xmlns:")) continue;
                String value = attr.getNodeValue();
                if (name.equals("xmlns") && value.length() == 0) continue;
                context.put(name, value);
            }
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: 
                case 5: 
                case 9: {
                    TransformUtil.fixNode(child, context, decls);
                }
            }
        }
    }

    public static void cleanTree(Vector decls) {
        for (int i = decls.size() - 1; i >= 0; --i) {
            Attr attr = (Attr)decls.elementAt(i);
            Element owner = attr.getOwnerElement();
            if (owner != null) {
                owner.removeAttributeNode(attr);
            }
            decls.removeElementAt(i);
        }
    }

    static boolean isAncestorOrSelf(Node me, Node anc) {
        Node parent = me instanceof Attr ? ((Attr)me).getOwnerElement() : me;
        while (parent != anc) {
            if ((parent = parent.getParentNode()) != null) continue;
            return false;
        }
        return true;
    }

    static void dumpNode(Node n) {
        switch (n.getNodeType()) {
            case 9: {
                System.err.println("#document");
                break;
            }
            case 1: {
                Node parent = n.getParentNode();
                System.err.println(n.getNodeName() + "; ns='" + n.getNamespaceURI() + "'; parent=" + parent.getNodeName());
                if (parent.getNodeType() != 9) break;
                System.err.println("   parent-parent=" + parent.getParentNode());
                break;
            }
            case 2: {
                System.err.println(n.getNodeName() + "='" + n.getNodeValue() + "'; parent=" + ((Attr)n).getOwnerElement().getNodeName());
                break;
            }
            case 3: 
            case 4: {
                System.err.println("#text '" + n.getNodeValue().replace('\n', '*') + "'");
                break;
            }
            case 8: {
                System.err.println("#comment '" + n.getNodeValue().replace('\n', '*') + "'");
                break;
            }
            case 7: {
                System.err.println("<?" + n.getNodeName() + "...?>");
                break;
            }
            default: {
                System.err.println("#others: " + n.getNodeName());
            }
        }
    }

    static Data transform(Transform tr, Data in, XMLCryptoContext xcontext, OutputStream os) throws TransformException {
        int FETCH_BUFFER_SIZE = 2048;
        if (os == null) {
            throw new NullPointerException("OutputStream must not be null.");
        }
        Data result = tr.transform(in, xcontext);
        if (result instanceof OctetStreamData) {
            try {
                int readLength;
                InputStream is = ((OctetStreamData)result).getOctetStream();
                byte[] buffer = new byte[2048];
                while ((readLength = is.read(buffer)) != -1) {
                    os.write(buffer, 0, readLength);
                }
                is.close();
            }
            catch (IOException ioe) {
                throw new TransformException(ioe);
            }
            return null;
        }
        return result;
    }

    public static String getAvailablePrefix(DOMCryptoContext dcontext, String ns, String defaultPrefix, Map map) {
        String prefix;
        String string = prefix = dcontext == null ? null : dcontext.getNamespacePrefix(ns, null);
        if (prefix == null || map.containsKey(prefix) && !ns.equals(map.get(prefix))) {
            String string2 = prefix = dcontext == null ? null : dcontext.getDefaultNamespacePrefix();
            if (prefix == null || map.containsKey(prefix) && !ns.equals(map.get(prefix))) {
                prefix = PREFIX_XPATH2;
                while (map.containsKey(prefix)) {
                    prefix = prefix + "0";
                }
            }
        }
        return prefix;
    }

    public static class ListIterator
    implements Iterator {
        List list;
        int iter;
        int size;

        public ListIterator(List l) {
            this.list = l;
            this.size = this.list.size();
            this.iter = 0;
        }

        public Object next() {
            if (this.iter >= this.size) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.iter++);
        }

        public boolean hasNext() {
            return this.iter < this.size;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class AttrProxy
    implements Attr {
        Attr real;
        Element owner;

        AttrProxy(Node owner, Document factory, String ns, String qname, String value) {
            this.real = factory.createAttributeNS(ns, qname);
            this.real.setValue(value);
            this.owner = (Element)owner;
        }

        public Element getOwnerElement() {
            return this.owner;
        }

        public String getName() {
            return this.real.getName();
        }

        public boolean getSpecified() {
            return false;
        }

        public String getValue() {
            return this.real.getValue();
        }

        public void setValue(String value) {
            this.real.setValue(value);
        }

        public Node appendChild(Node newChild) {
            return this.real.appendChild(newChild);
        }

        public Node cloneNode(boolean deep) {
            return this.real.cloneNode(deep);
        }

        public NamedNodeMap getAttributes() {
            return this.real.getAttributes();
        }

        public NodeList getChildNodes() {
            return this.real.getChildNodes();
        }

        public Node getFirstChild() {
            return this.real.getFirstChild();
        }

        public Node getLastChild() {
            return this.real.getLastChild();
        }

        public String getLocalName() {
            return this.real.getLocalName();
        }

        public String getNamespaceURI() {
            return this.real.getNamespaceURI();
        }

        public Node getNextSibling() {
            return this.real.getNextSibling();
        }

        public String getNodeName() {
            return this.real.getNodeName();
        }

        public short getNodeType() {
            return this.real.getNodeType();
        }

        public String getNodeValue() {
            return this.real.getNodeValue();
        }

        public Document getOwnerDocument() {
            return this.real.getOwnerDocument();
        }

        public Node getParentNode() {
            return this.real.getParentNode();
        }

        public String getPrefix() {
            return this.real.getPrefix();
        }

        public Node getPreviousSibling() {
            return this.real.getPreviousSibling();
        }

        public boolean hasAttributes() {
            return false;
        }

        public boolean hasChildNodes() {
            return this.real.hasChildNodes();
        }

        public Node insertBefore(Node newChild, Node refChild) {
            return this.real.insertBefore(newChild, refChild);
        }

        public void normalize() {
            this.real.normalize();
        }

        public Node removeChild(Node oldChild) {
            return this.real.removeChild(oldChild);
        }

        public Node replaceChild(Node newChild, Node oldChild) {
            return this.real.replaceChild(newChild, oldChild);
        }

        public void setNodeValue(String nodeValue) {
            this.real.setNodeValue(nodeValue);
        }

        public void setPrefix(String prefix) {
            this.real.setPrefix(prefix);
        }

        public boolean isSupported(String feature, String version) {
            return this.real.isSupported(feature, version);
        }
    }
}

