/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMAESCBC;
import com.ibm.xml.enc.dom.DOMKWAES;
import com.ibm.xml.enc.dom.DOMKWTripleDES;
import com.ibm.xml.enc.dom.DOMRSA15;
import com.ibm.xml.enc.dom.DOMRSAOAEP;
import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMTripleDESCBC;
import com.ibm.xml.enc.dom.DOMUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class DOMEncryptionMethod
extends DOMStructure
implements EncryptionMethod {
    private String algorithm;
    private Integer keySize;
    private AlgorithmParameterSpec params;
    private static Logger log = Logger.getLogger("org.jcp.xml.enc.internal.dom");

    DOMEncryptionMethod() {
    }

    protected DOMEncryptionMethod(String algorithm, Integer keySize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm cannot be null");
        }
        this.init(algorithm, keySize, params);
    }

    protected void init(String algorithm, Integer keySize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null && !(params instanceof EncryptionMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type EncryptionMethodParameterSpec");
        }
        this.checkParams(keySize, (EncryptionMethodParameterSpec)params);
        this.algorithm = algorithm;
        this.keySize = keySize;
        this.params = (EncryptionMethodParameterSpec)params;
    }

    protected DOMEncryptionMethod(Element emElem) throws MarshalException {
        this.algorithm = DOMUtils.getAttributeValue(emElem, "Algorithm");
        if (this.algorithm == null) {
            throw new MarshalException("EncryptionMethod Algorithm attribute must not be null");
        }
        Element ksElem = DOMUtils.getFirstChildElement(emElem);
        Element pElem = null;
        if (ksElem != null) {
            String temp = null;
            temp = ksElem.getLocalName();
            if (temp == null) {
                temp = ksElem.getNodeName();
            }
            if (ksElem.getLocalName().equals("KeySize")) {
                this.unmarshalKeySize(ksElem);
                pElem = DOMUtils.getNextSiblingElement(ksElem);
            } else {
                this.keySize = null;
                pElem = ksElem;
            }
            if (pElem != null) {
                this.params = this.unmarshalParams(pElem);
                try {
                    this.checkParams(this.keySize, (EncryptionMethodParameterSpec)this.params);
                }
                catch (InvalidAlgorithmParameterException iape) {
                    throw new MarshalException(iape);
                }
            }
        }
    }

    private void unmarshalKeySize(Element paramsElem) throws MarshalException {
        this.keySize = new Integer(paramsElem.getFirstChild().getNodeValue());
    }

    protected abstract EncryptionMethodParameterSpec unmarshalParams(Element var1) throws MarshalException;

    static EncryptionMethod unmarshal(Element emElem) throws MarshalException {
        String alg = DOMUtils.getAttributeValue(emElem, "Algorithm");
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            return new DOMRSAOAEP(emElem);
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return new DOMTripleDESCBC(emElem);
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            return new DOMAESCBC(emElem, "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            return new DOMAESCBC(emElem, "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            return new DOMAESCBC(emElem, "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
            return new DOMRSA15(emElem);
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
            return new DOMKWTripleDES(emElem);
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
            return new DOMKWAES(emElem, "http://www.w3.org/2001/04/xmlenc#kw-aes128");
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
            return new DOMKWAES(emElem, "http://www.w3.org/2001/04/xmlenc#kw-aes192");
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
            return new DOMKWAES(emElem, "http://www.w3.org/2001/04/xmlenc#kw-aes256");
        }
        throw new MarshalException("unsupported encryption algorithm: " + alg);
    }

    protected abstract void checkParams(Integer var1, EncryptionMethodParameterSpec var2) throws InvalidAlgorithmParameterException;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Integer getKeySize() {
        return this.keySize;
    }

    public void marshal(Node parent, String encPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element emElem = DOMUtils.createElement(ownerDoc, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        DOMUtils.setAttribute(emElem, "Algorithm", this.algorithm);
        if (this.keySize != null) {
            Element ksElem = DOMUtils.createElement(ownerDoc, "KeySize", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
            ksElem.appendChild(ownerDoc.createTextNode(this.keySize.toString()));
            emElem.appendChild(ksElem);
        }
        if (this.params != null) {
            this.marshalParams(emElem, encPrefix);
        }
        parent.appendChild(emElem);
    }

    public abstract byte[] encrypt(Key var1, byte[] var2, EncryptedType var3) throws InvalidKeyException, IllegalBlockSizeException;

    public abstract byte[] decrypt(Key var1, byte[] var2) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException;

    public abstract Key decryptKey(Key var1, byte[] var2, AlgorithmMethod var3) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException;

    public abstract byte[] wrap(Key var1, Key var2) throws InvalidKeyException, IllegalBlockSizeException;

    public abstract byte[] unwrap(Key var1, byte[] var2) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException;

    public abstract Key unwrap(Key var1, byte[] var2, AlgorithmMethod var3) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException;

    protected abstract void marshalParams(Element var1, String var2) throws MarshalException;

    protected abstract boolean paramsEqual(AlgorithmParameterSpec var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionMethod)) {
            return false;
        }
        EncryptionMethod osm = (EncryptionMethod)o;
        return this.algorithm.equals(osm.getAlgorithm()) && this.paramsEqual(osm.getParameterSpec());
    }

    public String parseAlg(AlgorithmMethod algo) {
        String alg = algo.getAlgorithm();
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || alg.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || alg.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            return "AES";
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return "TripleDES";
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || alg.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            return "RSA";
        }
        throw new IllegalArgumentException("Unsupported key algorithm ");
    }

    protected Key genKey(byte[] keybytes, String alg) throws InvalidKeyException {
        if (alg == null) {
            throw new InvalidKeyException("Unsupported key algorithm " + alg);
        }
        if (!alg.equals("RSA")) {
            return new SecretKeySpec(keybytes, alg);
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            try {
                PKCS8EncodedKeySpec pkcs8keyspec = new PKCS8EncodedKeySpec(keybytes);
                return kf.generatePrivate(pkcs8keyspec);
            }
            catch (InvalidKeySpecException ex) {
                try {
                    X509EncodedKeySpec x509keyspec = new X509EncodedKeySpec(keybytes);
                    return kf.generatePublic(x509keyspec);
                }
                catch (InvalidKeySpecException ex2) {
                    throw (InvalidKeyException)new InvalidKeyException(ex2.getMessage()).initCause(ex2);
                }
            }
        }
        catch (Exception ex) {
            throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
        }
    }
}

