/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.xml.enc.dom.DOMCipherData;
import com.ibm.xml.enc.dom.DOMCipherReference;
import com.ibm.xml.enc.dom.DOMCipherValue;
import com.ibm.xml.enc.dom.DOMEncManager;
import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.DOMEncryptionProperties;
import com.ibm.xml.enc.dom.DOMKeyInfo;
import com.ibm.xml.enc.dom.DOMReferenceList;
import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMUtils;
import com.ibm.xml.enc.dom.Debug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.enc.CipherData;
import javax.xml.crypto.enc.CipherReference;
import javax.xml.crypto.enc.CipherValue;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.EncryptionProperties;
import javax.xml.crypto.enc.ToBeEncrypted;
import javax.xml.crypto.enc.ToBeEncryptedKey;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.XMLEncryptContext;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.dom.DOMEncryptContext;
import javax.xml.crypto.enc.keyinfo.EncryptedKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMEncryptedKey
extends DOMStructure
implements EncryptedKey {
    private static Debug debug = Debug.getInstance("xmlenc");
    private DOMEncryptionMethod em;
    private DOMKeyInfo ki;
    private DOMCipherData cd;
    private DOMEncryptionProperties eps;
    private List refList;
    private String carriedKeyName;
    private String recipient;
    private String id;
    private String type;
    private String mimeType;
    private String encoding;
    private Element localEncDataElem = null;
    private ToBeEncryptedKey tbe = null;
    private byte[] encryptedBytes;
    private boolean isDecrypted = false;
    private byte[] decrypted = null;

    public DOMEncryptedKey(ToBeEncryptedKey toBeEncrypted, DOMEncryptionMethod em, DOMKeyInfo ki, DOMEncryptionProperties eps, List references, String id, String carriedKeyName, String recipient) {
        this.tbe = toBeEncrypted;
        this.id = id;
        this.type = this.tbe.getType();
        this.mimeType = this.tbe.getMimeType();
        this.encoding = this.tbe.getEncoding();
        this.em = em;
        this.ki = ki;
        this.eps = eps;
        this.refList = references;
        this.carriedKeyName = carriedKeyName;
        this.recipient = recipient;
    }

    public DOMEncryptedKey(ToBeEncryptedKey toBeEncrypted, DOMEncryptionMethod em, DOMKeyInfo ki, DOMEncryptionProperties eps, List references, String id, String carriedKeyName, String recipient, DOMCipherReference cipherReference) {
        this.tbe = toBeEncrypted;
        this.id = id;
        this.type = this.tbe.getType();
        this.mimeType = this.tbe.getMimeType();
        this.encoding = this.tbe.getEncoding();
        this.em = em;
        this.ki = ki;
        this.eps = eps;
        this.refList = references;
        this.carriedKeyName = carriedKeyName;
        this.recipient = recipient;
        this.cd = cipherReference;
    }

    public DOMEncryptedKey(Element encDataElem, XMLCryptoContext context) throws MarshalException {
        this.localEncDataElem = encDataElem;
        this.id = DOMUtils.getAttributeValue(this.localEncDataElem, "Id");
        this.type = DOMUtils.getAttributeValue(this.localEncDataElem, "Type");
        this.mimeType = DOMUtils.getAttributeValue(this.localEncDataElem, "MimeType");
        this.encoding = DOMUtils.getAttributeValue(this.localEncDataElem, "Encoding");
        this.recipient = DOMUtils.getAttributeValue(this.localEncDataElem, "Recipient");
        Element elem = DOMUtils.getFirstChildElement(this.localEncDataElem);
        if (elem == null) {
            throw new MarshalException("Missing CipherData element in EncryptedKey");
        }
        String temp = elem.getLocalName();
        if (elem.getNodeName().equals("EncryptionMethod")) {
            this.em = (DOMEncryptionMethod)DOMEncryptionMethod.unmarshal(elem);
            elem = DOMUtils.getNextSiblingElement(elem);
        }
        if (elem == null) {
            throw new MarshalException("Missing CipherData element in EncryptedKey");
        }
        temp = elem.getLocalName();
        if (temp.equals("KeyInfo")) {
            this.ki = new DOMKeyInfo(elem, context);
            elem = DOMUtils.getNextSiblingElement(elem);
        }
        if (elem == null) {
            throw new MarshalException("Missing CipherData element in EncryptedKey");
        }
        this.cd = DOMCipherData.getInstance(elem, context);
        if ((elem = DOMUtils.getNextSiblingElement(elem)) != null) {
            temp = elem.getLocalName();
            if (temp != null && temp.equals("EncryptionProperties")) {
                this.eps = new DOMEncryptionProperties(elem);
                temp = (elem = DOMUtils.getNextSiblingElement(elem)) != null ? elem.getLocalName() : null;
            }
            if (temp != null && temp.equals("ReferenceList")) {
                this.refList = new DOMReferenceList(elem).getReferenceList();
                temp = (elem = DOMUtils.getNextSiblingElement(elem)) != null ? elem.getLocalName() : null;
            }
            if (temp != null && temp.equals("CarriedKeyName")) {
                this.carriedKeyName = DOMUtils.getTextContent(elem);
                elem = DOMUtils.getNextSiblingElement(elem);
            }
            if (elem != null) {
                throw new MarshalException("unexpected element in EncryptedKey");
            }
        }
        if (elem != null) {
            throw new RuntimeException("should not have extra elements");
        }
    }

    DOMEncryptedKey(String id, String type, String mimeType, String encoding, String recipient, DOMEncryptionMethod em, DOMKeyInfo ki, DOMCipherData cdata, DOMEncryptionProperties eps, DOMReferenceList rl, String carriedKeyName, Element localEncDataElem) {
        this.id = id;
        this.type = type;
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.recipient = recipient;
        this.em = em;
        this.ki = ki;
        this.cd = cdata;
        this.eps = eps;
        if (rl != null) {
            this.refList = rl.getReferenceList();
        }
        this.carriedKeyName = carriedKeyName;
        this.localEncDataElem = localEncDataElem;
    }

    public List getReferenceList() {
        return this.refList;
    }

    public String getCarriedKeyName() {
        return this.carriedKeyName;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.em;
    }

    private DOMEncryptionMethod getEncryptionMethod(XMLCryptoContext context) throws XMLEncryptionException {
        if (this.em != null) {
            return this.em;
        }
        EncryptionMethod em2 = null;
        if (context instanceof XMLDecryptContext) {
            em2 = ((XMLDecryptContext)context).getEncryptionMethod();
        } else if (context instanceof XMLEncryptContext) {
            em2 = ((XMLEncryptContext)context).getEncryptionMethod();
        }
        if (em2 != null) {
            DOMEncryptionMethod dem = null;
            if (em2 instanceof DOMEncryptionMethod) {
                dem = (DOMEncryptionMethod)em2;
            } else {
                try {
                    dem = (DOMEncryptionMethod)((Object)DOMEncManager.getEncryptionMethod(em2.getAlgorithm(), em2.getKeySize(), em2.getParameterSpec()));
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.trace("DOMEncryptedKey", "decrypt", ex);
                    }
                    throw new XMLEncryptionException((Throwable)ex);
                }
            }
            return dem;
        }
        throw new XMLEncryptionException("no encryption method");
    }

    public KeyInfo getKeyInfo() {
        return this.ki;
    }

    public CipherData getCipherData() {
        return this.cd;
    }

    public EncryptionProperties getEncryptionProperties() {
        return this.eps;
    }

    public InputStream getCipherText() {
        if (this.encryptedBytes != null) {
            ByteArrayInputStream cipherText = new ByteArrayInputStream((byte[])this.encryptedBytes.clone());
            return cipherText;
        }
        if (this.cd != null && this.cd instanceof CipherReference) {
            try {
                return ((DOMCipherReference)this.cd).getCipherValue();
            }
            catch (XMLEncryptionException ex) {
                if (debug != null) {
                    debug.trace("DOMEncryptedKey", "getCipherText", ex);
                }
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public ToBeEncrypted getToBeEncrypted() {
        return this.tbe;
    }

    public void marshal(Node parent, String encPrefix, DOMCryptoContext context) throws MarshalException {
        this.marshal(parent, null, encPrefix, context);
    }

    public void marshal(Node parent, Node nextSibling, String encPrefix, DOMCryptoContext context) throws MarshalException {
        if (parent == null) {
            throw new MarshalException("parent cannot be null");
        }
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element encDataElem = DOMUtils.createElement(ownerDoc, "EncryptedKey", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        if (encPrefix == null) {
            encDataElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2001/04/xmlenc#");
        } else {
            encDataElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + encPrefix, "http://www.w3.org/2001/04/xmlenc#");
        }
        if (this.em != null) {
            this.em.marshal(encDataElem, encPrefix, context);
        }
        if (this.ki != null) {
            this.ki.marshal(encDataElem, encPrefix, context);
        }
        this.cd.marshal(encDataElem, encPrefix, context);
        if (this.eps != null) {
            this.eps.marshal(encDataElem, encPrefix, context);
        }
        if (this.refList != null) {
            DOMReferenceList dlist = new DOMReferenceList(this.refList);
            dlist.marshal(encDataElem, encPrefix, context);
        }
        if (this.carriedKeyName != null) {
            Element cknElem = DOMUtils.createElement(ownerDoc, "CarriedKeyName", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
            cknElem.appendChild(ownerDoc.createTextNode(this.carriedKeyName));
            encDataElem.appendChild(cknElem);
        }
        if (this.id != null) {
            DOMUtils.setAttributeID(encDataElem, "Id", this.id);
        }
        if (this.type != null) {
            DOMUtils.setAttributeID(encDataElem, "Type", this.type);
        }
        if (this.mimeType != null) {
            DOMUtils.setAttributeID(encDataElem, "MimeType", this.mimeType);
        }
        if (this.encoding != null) {
            DOMUtils.setAttributeID(encDataElem, "Encoding", this.encoding);
        }
        if (this.recipient != null) {
            DOMUtils.setAttributeID(encDataElem, "Recipient", this.recipient);
        }
        parent.insertBefore(encDataElem, nextSibling);
    }

    /*
     * Unable to fully structure code
     */
    public InputStream decrypt(XMLDecryptContext decryptContext) throws XMLEncryptionException {
        if (decryptContext == null) {
            throw new NullPointerException("decryptContext is null");
        }
        if (this.isDecrypted) {
            return new ByteArrayInputStream(this.decrypted);
        }
        encryptedValue = null;
        if (this.cd == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
        if (this.cd instanceof CipherReference) {
            cref = (DOMCipherReference)this.cd;
            is = cref.getCipherValue((XMLCryptoContext)decryptContext);
            if (is == null) {
                throw new XMLEncryptionException("Dereferencing CipherReference returned null");
            }
            try {
                encryptedValue = new byte[is.available()];
                is.read(encryptedValue);
                if (DOMEncryptedKey.debug == null) ** GOTO lbl30
                DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", new HexDumpEncoder().encode(encryptedValue));
            }
            catch (IOException io) {
                if (DOMEncryptedKey.debug != null) {
                    DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", io);
                }
                throw new XMLEncryptionException((Throwable)io);
            }
            catch (RuntimeException re) {
                if (DOMEncryptedKey.debug != null) {
                    DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", re);
                }
                throw new XMLEncryptionException((Throwable)re);
            }
        } else if (this.cd instanceof CipherValue) {
            encryptedValue = ((CipherValue)this.cd).getValue();
        }
lbl30:
        // 5 sources

        em = this.getEncryptionMethod((XMLCryptoContext)decryptContext);
        try {
            this.decrypted = em.decrypt(decryptContext.getKeySelector().select(this.ki, KeySelector.Purpose.DECRYPT, (AlgorithmMethod)em, (XMLCryptoContext)decryptContext).getKey(), encryptedValue);
        }
        catch (KeySelectorException kse) {
            if (DOMEncryptedKey.debug != null) {
                DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", kse);
            }
            throw new XMLEncryptionException((Throwable)kse);
        }
        catch (InvalidKeyException ike) {
            if (DOMEncryptedKey.debug != null) {
                DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", ike);
            }
            throw new XMLEncryptionException((Throwable)ike);
        }
        catch (BadPaddingException bpe) {
            if (DOMEncryptedKey.debug != null) {
                DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", bpe);
            }
            throw new XMLEncryptionException((Throwable)bpe);
        }
        catch (IllegalBlockSizeException ibse) {
            if (DOMEncryptedKey.debug != null) {
                DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", ibse);
            }
            throw new XMLEncryptionException((Throwable)ibse);
        }
        catch (RuntimeException re) {
            if (DOMEncryptedKey.debug != null) {
                DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", re);
            }
            throw new XMLEncryptionException((Throwable)re);
        }
        this.isDecrypted = true;
        return new ByteArrayInputStream(this.decrypted);
    }

    /*
     * Unable to fully structure code
     */
    public Key decryptKey(XMLDecryptContext decryptContext, AlgorithmMethod algo) throws XMLEncryptionException {
        if (decryptContext == null || algo == null) {
            throw new NullPointerException("decryptContext cannot be null");
        }
        if (this.cd == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
        encryptedValue = null;
        if (this.cd instanceof CipherReference) {
            cref = (DOMCipherReference)this.cd;
            is = cref.getCipherValue((XMLCryptoContext)decryptContext);
            if (is == null) {
                throw new XMLEncryptionException("Dereferencing CipherReference returned null");
            }
            try {
                encryptedValue = new byte[is.available()];
                is.read(encryptedValue);
                if (DOMEncryptedKey.debug == null) ** GOTO lbl28
                DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", new HexDumpEncoder().encode(encryptedValue));
            }
            catch (IOException io) {
                if (DOMEncryptedKey.debug != null) {
                    DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", io);
                }
                throw new XMLEncryptionException((Throwable)io);
            }
            catch (RuntimeException re) {
                if (DOMEncryptedKey.debug != null) {
                    DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decrypt", re);
                }
                throw new XMLEncryptionException((Throwable)re);
            }
        } else if (this.cd instanceof CipherValue) {
            encryptedValue = ((CipherValue)this.cd).getValue();
        }
lbl28:
        // 5 sources

        decryptionKey = null;
        ks = decryptContext.getKeySelector();
        em = this.getEncryptionMethod((XMLCryptoContext)decryptContext);
        try {
            decryptionKey = ks.select(this.ki, KeySelector.Purpose.DECRYPT, (AlgorithmMethod)em, (XMLCryptoContext)decryptContext).getKey();
        }
        catch (KeySelectorException ex) {
            throw new XMLEncryptionException((Throwable)ex);
        }
        try {
            return em.decryptKey(decryptionKey, encryptedValue, algo);
        }
        catch (Exception ex) {
            if (DOMEncryptedKey.debug != null) {
                DOMEncryptedKey.debug.trace("DOMEncryptedKey", "decryptKey", ex);
            }
            throw new XMLEncryptionException((Throwable)ex);
        }
    }

    public void encrypt(XMLEncryptContext encryptContext) throws MarshalException, XMLEncryptionException {
        if (encryptContext == null) {
            throw new NullPointerException("encryptContext cannot be null");
        }
        if (!(encryptContext instanceof DOMEncryptContext)) {
            throw new XMLEncryptionException("encryptContext must be of type DOMEncryptContext");
        }
        DOMEncryptContext context = (DOMEncryptContext)encryptContext;
        if (this.tbe == null) {
            throw new XMLEncryptionException("toBeEncrypted is null");
        }
        byte[] toBeEncryptedBytes = this.tbe.getKey().getEncoded();
        KeySelector ks = encryptContext.getKeySelector();
        DOMEncryptionMethod dem = this.getEncryptionMethod((XMLCryptoContext)context);
        Key encryptionKey = null;
        try {
            encryptionKey = ks.select(this.ki, KeySelector.Purpose.ENCRYPT, (AlgorithmMethod)((Object)dem), (XMLCryptoContext)context).getKey();
        }
        catch (KeySelectorException kse) {
            if (debug != null) {
                debug.trace("DOMEncryptedKey", "encrypt", kse);
            }
            throw new XMLEncryptionException((Throwable)kse);
        }
        byte[] eBytes = null;
        try {
            eBytes = dem.encrypt(encryptionKey, toBeEncryptedBytes, (EncryptedType)this);
        }
        catch (Exception ee) {
            if (debug != null) {
                debug.trace("DOMEncryptedKey", "encrypt", ee);
            }
            throw new XMLEncryptionException((Throwable)ee);
        }
        if (this.cd == null) {
            this.cd = new DOMCipherValue(eBytes);
        } else {
            this.encryptedBytes = eBytes;
        }
        this.marshal(context.getParent(), context.getNextSibling(), DOMUtils.getEncryptionPrefix(context), (DOMCryptoContext)context);
    }

    public boolean equals(Object o) {
        boolean encodingEqual;
        boolean mimeTypeEqual;
        boolean typeEqual;
        boolean epsEquals;
        boolean cipherDataEqual;
        boolean encMethodEqual;
        boolean keyInfoEqual;
        boolean idEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptedKey)) {
            return false;
        }
        EncryptedKey oenc = (EncryptedKey)o;
        boolean bl = this.id == null ? oenc.getId() == null : (idEqual = this.id.equals(oenc.getId()));
        if (!idEqual) {
            return false;
        }
        boolean bl2 = this.ki == null ? oenc.getKeyInfo() == null : (keyInfoEqual = this.ki.equals(oenc.getKeyInfo()));
        if (!keyInfoEqual) {
            return false;
        }
        boolean bl3 = this.em == null ? oenc.getEncryptionMethod() == null : (encMethodEqual = this.em.equals(oenc.getEncryptionMethod()));
        if (!encMethodEqual) {
            return false;
        }
        boolean bl4 = this.cd == null ? oenc.getCipherData() == null : (cipherDataEqual = this.cd.equals(oenc.getCipherData()));
        if (!cipherDataEqual) {
            return false;
        }
        boolean bl5 = this.eps == null ? oenc.getEncryptionProperties() == null : (epsEquals = this.eps.equals(oenc.getEncryptionProperties()));
        if (!epsEquals) {
            return false;
        }
        boolean bl6 = this.type == null ? oenc.getType() == null : (typeEqual = this.type.equals(oenc.getType()));
        if (!typeEqual) {
            return false;
        }
        boolean bl7 = this.mimeType == null ? oenc.getMimeType() == null : (mimeTypeEqual = this.mimeType.equals(oenc.getMimeType()));
        if (!mimeTypeEqual) {
            return false;
        }
        boolean bl8 = this.encoding == null ? oenc.getEncoding() == null : (encodingEqual = this.encoding.equals(oenc.getEncoding()));
        return encodingEqual;
    }
}

