/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.Debug;
import com.ibm.xml.enc.dom.Utils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import org.w3c.dom.Element;

public final class DOMAESCBC
extends DOMEncryptionMethod {
    private static Debug debug = Debug.getInstance("xmlenc");
    private Cipher cipher;

    public DOMAESCBC(String algo, Integer keysize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super(algo, keysize, params);
    }

    public DOMAESCBC(Element smElem, String algo) throws MarshalException {
        super(smElem);
    }

    protected void checkParams(Integer keySize, EncryptionMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for AES cipher algorithm");
        }
    }

    protected EncryptionMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for AES cipher algorithm");
    }

    protected void marshalParams(Element parent, String dsPrefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for AES cipher algorithm");
    }

    protected boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    public byte[] decrypt(Key key, byte[] data) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (key == null) {
            throw new NullPointerException("key or cipher cannot be null");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("key must be SecretKey");
        }
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            }
            catch (NoSuchAlgorithmException nsae) {
                if (debug != null) {
                    debug.trace("xmlenc", "DOMAESCBC", "decrypt", nsae);
                }
                throw (InvalidKeyException)new InvalidKeyException(nsae.getMessage()).initCause(nsae);
            }
            catch (NoSuchPaddingException nspe) {
                if (debug != null) {
                    debug.trace("xmlenc", "DOMAESCBC", "decrypt", nspe);
                }
                throw (InvalidKeyException)new InvalidKeyException(nspe.getMessage()).initCause(nspe);
            }
        }
        byte[] iv = new byte[this.cipher.getBlockSize()];
        System.arraycopy(data, 0, iv, 0, iv.length);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        try {
            this.cipher.init(2, key, ivSpec);
        }
        catch (InvalidAlgorithmParameterException iape) {
            if (debug != null) {
                debug.trace("xmlenc", "DOMAESCBC", "decrypt", iape);
            }
            throw new IllegalBlockSizeException(iape.getMessage());
        }
        byte[] decrypted = this.cipher.doFinal(data, iv.length, data.length - iv.length);
        if (debug != null) {
            debug.trace("DOMAESCBC", "decrypt", "encrypting data: " + Utils.base64EncodeNoWhite(data));
            debug.trace("DOMAESCBC", "decrypt", "decrypted text: " + new String(decrypted));
        }
        return decrypted;
    }

    public Key decryptKey(Key key, byte[] encryptedKey, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException {
        byte[] decryptedData = this.decrypt(key, encryptedKey);
        String alg = Utils.mapAlgorithm(algo.getAlgorithm());
        return this.genKey(decryptedData, alg);
    }

    public byte[] encrypt(Key key, byte[] data, EncryptedType type) throws InvalidKeyException {
        if (key == null || data == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("key must be SecretKey");
        }
        if (debug != null) {
            debug.trace("DOMAESCBC", "decryptKey", "encrypting data: " + Utils.base64EncodeNoWhite(data));
        }
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            }
            catch (Exception ex) {
                if (debug != null) {
                    debug.trace("DOMAESCBC", "encrypt", ex);
                }
                throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
            }
        }
        this.cipher.init(1, key);
        byte[] encrypted = null;
        try {
            encrypted = this.cipher.doFinal(data);
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.trace("DOMAESCBC", "encrypt", ex);
            }
            throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
        }
        byte[] finalBytes = new byte[encrypted.length + this.cipher.getBlockSize()];
        byte[] iv = this.cipher.getIV();
        System.arraycopy(iv, 0, finalBytes, 0, iv.length);
        System.arraycopy(encrypted, 0, finalBytes, iv.length, encrypted.length);
        return finalBytes;
    }

    public byte[] wrap(Key key, Key toBeWrapped) throws InvalidKeyException, IllegalBlockSizeException {
        throw new UnsupportedOperationException("Wrap is not supported");
    }

    public byte[] unwrap(Key key, byte[] encrypted) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        throw new UnsupportedOperationException("Unwrap is not supported");
    }

    public Key unwrap(Key key, byte[] encrypted, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        throw new UnsupportedOperationException("Unwrap is not supported");
    }
}

