/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.SHA;
import com.ibm.crypto.fips.provider.SelfTest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandomSpi;

public final class SecureRandom
extends SecureRandomSpi
implements Serializable,
AlgorithmStatus {
    static final long serialVersionUID = -3888978670357092251L;
    private transient SHA sha1;
    private static SecureRandom seedGenerator;
    private BigInteger P64;
    private int[] syms = new int[16];
    private byte[] sbuf = new byte[256];
    private byte[] rngTestBuf = null;
    private long accu = 0L;
    private boolean firstTrng = true;
    private boolean extSeeded = false;
    private long rngTest = 0L;
    private int bits = 0;
    private int nsam = 64;
    private static final short[] logtab;
    byte[] state = new byte[85];
    private static String z;

    public SecureRandom() {
        this.a(null);
    }

    public SecureRandom(byte[] byArray) {
        this.a(byArray);
    }

    private void a(byte[] byArray) {
        byte[] byArray2 = new byte[9];
        this.sha1 = new SHA();
        byArray2[0] = 1;
        byArray2[8] = 13;
        this.P64 = new BigInteger(1, byArray2);
        SecureRandom.a(128, this.state, 49);
        SecureRandom.a(30, this.state, 53);
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    public boolean isFipsApproved() {
        return true;
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        this.b(byArray);
    }

    protected synchronized void b(byte[] byArray) {
        if (byArray != null) {
            int n2 = 0;
            int n3 = byArray.length;
            if (n3 > 40) {
                byte[] byArray2 = new byte[20];
                SHA sHA = new SHA();
                sHA.a(byArray, 0, byArray.length);
                byArray2 = sHA.d();
                n3 = 20;
                byArray = this.state;
                n2 = 65;
                System.arraycopy(byArray2, 0, this.state, 65, n3);
            }
            while (--n3 >= 0) {
                int n4 = 25 + n3 % 20;
                this.state[n4] = (byte)(this.state[n4] ^ byArray[n2 + n3]);
            }
            if (this.state[0] == 0) {
                this.state[0] = 25;
            }
            this.extSeeded = true;
        }
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        this.c(byArray);
    }

    protected synchronized void c(byte[] byArray) {
        this.b(byArray, 0, byArray.length);
    }

    public byte[] engineGenerateSeed(int n2) {
        if (SelfTest.isFipsRunnable()) {
            return this.a(n2);
        }
        throw new FIPSRuntimeException();
    }

    protected byte[] a(int n2) {
        byte[] byArray = new byte[n2];
        this.b(byArray, 0, byArray.length);
        return byArray;
    }

    private int a() {
        int n2;
        while (this.bits == 0) {
            BigInteger bigInteger;
            long l2;
            this.accu = 0L;
            int n3 = 0;
            do {
                this.syms[n3] = 0;
            } while (++n3 < 16);
            int n4 = this.sbuf.length - 1;
            int n5 = 0;
            n2 = 0;
            int n6 = 0;
            int n7 = 0;
            while (true) {
                int n8 = 0;
                do {
                    l2 = System.currentTimeMillis();
                    while (l2 == System.currentTimeMillis()) {
                        ++n8;
                    }
                } while (n8 == 0);
                this.sbuf[n4] = (byte)(this.sbuf[n4] << 4 | n8 % 16);
                n4 -= n5;
                n5 ^= 1;
                if ((n7 - n8) * (n7 - n8) != 1) {
                    n7 = n8;
                }
                int n9 = n7 % 16;
                this.syms[n9] = this.syms[n9] + n2;
                n2 |= 1;
                if (n4 < 0) {
                    bigInteger = new BigInteger(1, this.sbuf);
                    this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue();
                    n4 += this.sbuf.length;
                    n2 = 0;
                }
                if (++n6 < this.nsam) continue;
                n3 = 0;
                int n10 = 0;
                int n11 = SecureRandom.b(n6);
                do {
                    n2 = this.syms[n3];
                    n10 += n2 * (n11 - SecureRandom.b(n2));
                } while (++n3 < 16);
                this.nsam = 96000 * n6 / n10;
                if (this.nsam <= n6) break;
                this.nsam = n10 > n6 ? this.nsam + 3 : n6 + 32;
                n2 = 0;
            }
            bigInteger = new BigInteger(1, this.sbuf);
            this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue() ^ l2;
            this.bits = 64;
            if (this.accu == this.rngTest) {
                throw new FIPSRuntimeException(z);
            }
            this.rngTest = this.accu;
            if (!this.firstTrng) continue;
            this.accu = 0L;
            this.bits = 0;
            this.firstTrng = false;
        }
        n2 = (int)(this.accu & 0xFFL);
        this.accu >>>= 8;
        this.bits -= 8;
        return n2;
    }

    private void a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.state;
        byte[] byArray3 = new byte[n3];
        if (seedGenerator == null) {
            int n4 = n3;
            while (--n4 >= 0) {
                int n5 = 25 + n4 % 20;
                byArray2[n5] = (byte)(byArray2[n5] ^ this.a());
            }
            System.arraycopy(byArray2, 25, byArray3, 0, n3);
            seedGenerator = new SecureRandom(byArray3);
        }
        seedGenerator.engineNextBytes(byArray3);
        System.arraycopy(byArray3, 0, byArray2, 25, n3);
        long l2 = (long)SecureRandom.a(byArray2, 53) * 1000L + System.currentTimeMillis();
        SecureRandom.a((int)(l2 >>> 32), byArray2, 57);
        SecureRandom.a((int)l2, byArray2, 61);
        if (byArray2[0] == 0) {
            byArray2[0] = 25;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void b(byte[] byArray, int n2, int n3) {
        int n4;
        byte[] byArray2 = this.state;
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[20];
        byte[] byArray5 = null;
        int n5 = 160;
        while ((n4 = byArray2[0]) == 0) {
            this.a(null, 0, 20);
        }
        block5: while (true) {
            if (--n3 < 0) {
                byArray2[0] = (byte)n4;
                return;
            }
            while (true) {
                boolean bl;
                int n6;
                int n7;
                int n8;
                if (n4 == 25 || this.rngTestBuf == null) {
                    int n9 = SecureRandom.a(byArray2, 49);
                    if (n9 > 0 && !this.extSeeded) {
                        long l2 = ((long)SecureRandom.a(byArray2, 57) << 32) + ((long)SecureRandom.a(byArray2, 61) & 0xFFFFFFFFL);
                        n8 = SecureRandom.a(byArray2, 45);
                        n7 = n8 + 20;
                        if (n7 < n8) {
                            n8 = 0;
                            n7 = 0 + 20;
                        }
                        SecureRandom.a(n7, byArray2, 45);
                        n8 += n9 - n8 % n9;
                        while (n8 < n7) {
                            byte[] byArray6 = this.sbuf;
                            // MONITORENTER : this.sbuf
                            if (this.bits > 0 || System.currentTimeMillis() >= l2) {
                                int n10 = 25 + n8 / n9 % 20;
                                byArray2[n10] = (byte)(byArray2[n10] ^ this.a());
                                l2 = (long)SecureRandom.a(byArray2, 53) * 1000L + System.currentTimeMillis();
                                SecureRandom.a((int)(l2 >>> 32), byArray2, 57);
                                SecureRandom.a((int)l2, byArray2, 61);
                            }
                            // MONITOREXIT : byArray6
                            n8 += n9;
                        }
                    }
                    int n11 = 0;
                    for (n6 = 19; n6 >= 0; --n6) {
                        n11 = (n11 >> 8) + (byArray2[5 + n6] & 0xFF) + (byArray2[25 + n6] & 0xFF);
                        byArray4[n6] = (byte)n11;
                    }
                    for (n11 = 0; n11 < byArray3.length; ++n11) {
                        byArray3[n11] = 0;
                    }
                    System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
                    try {
                        byArray5 = this.sha1.a(byArray3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bl = true;
                    n8 = 256;
                } else {
                    byArray[n2++] = byArray2[n4 + 60];
                    ++n4;
                    continue block5;
                }
                for (n7 = 19; n7 >= 0; bl &= n6 >= (n7 == 19 ? 209 : 255), --n7) {
                    n6 = byArray5[n7] & 0xFF;
                    n8 = (n8 >> 8) + n6 + (byArray2[5 + n7] & 0xFF);
                    byArray2[5 + n7] = (byte)n8;
                }
                if (bl) {
                    n6 = 12032;
                    for (n8 = 19; n8 >= 0; --n8) {
                        n6 = (n6 >> 8) + (byArray2[5 + n8] & 0xFF);
                        byArray2[5 + n8] = (byte)n6;
                    }
                }
                if (this.rngTestBuf != null) {
                    if (this.rngTestBuf.equals(byArray5)) {
                        throw new FIPSRuntimeException(z);
                    }
                    System.arraycopy(byArray5, 0, this.rngTestBuf, 0, 20);
                    System.arraycopy(byArray5, 0, byArray2, 65, 20);
                    n4 = 5;
                    continue;
                }
                this.rngTestBuf = new byte[20];
                System.arraycopy(byArray5, 0, this.rngTestBuf, 0, 20);
                n4 = 25;
            }
            break;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.sha1 = new SHA();
    }

    private static final int b(int n2) {
        int n3 = 6;
        if (n2 == 0) {
            return 0;
        }
        while (n2 < 64) {
            n2 <<= 1;
            --n3;
        }
        while (n2 >= 128) {
            n2 >>= 1;
            ++n3;
        }
        return n3 * 1000 + logtab[n2 & 0x3F];
    }

    static final int a(byte[] byArray, int n2) {
        return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static final void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 24);
        byArray[n3 + 1] = (byte)(n2 >>> 16);
        byArray[n3 + 2] = (byte)(n2 >>> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                Object var0 = null;
                char[] cArray3 = "x2~7*U2e0ci\u0013Wc7^.dc%Z4|&'\u0015".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 59;
                            break;
                        }
                        case 1: {
                            n7 = 93;
                            break;
                        }
                        case 2: {
                            n7 = 16;
                            break;
                        }
                        case 3: {
                            n7 = 67;
                            break;
                        }
                        default: {
                            n7 = 67;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
        logtab = new short[]{0, 22, 44, 66, 87, 109, 129, 150, 170, 190, 209, 229, 248, 267, 285, 304, 322, 340, 358, 375, 392, 409, 426, 443, 459, 476, 492, 508, 524, 539, 555, 570, 585, 600, 615, 629, 644, 658, 672, 687, 700, 714, 728, 741, 755, 768, 781, 794, 807, 820, 833, 845, 858, 870, 883, 895, 907, 919, 931, 943, 954, 966, 977, 989};
    }
}

