/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

public final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable {
    static final long serialVersionUID = -5387735831354112582L;
    private BigInteger modulus;
    private BigInteger privateExponent;
    private static String[] z;

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[3] + iOException.getMessage());
        }
    }

    public RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public String toString() {
        return z[0] + this.modulus.toString() + "\n" + z[1] + this.privateExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.modulus = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[2]);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void zeroize() {
        this.modulus = BigInteger.ZERO;
        this.privateExponent = BigInteger.ZERO;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block43: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block42: {
                char[] cArray3;
                Object var0;
                block41: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block40: {
                        char[] cArray5;
                        block39: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block38: {
                                char[] cArray7;
                                block37: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block36: {
                                        stringArray = new String[4];
                                        var0 = null;
                                        char[] cArray9 = "Bk='1No9=!+{#,R[[\u0019\u001b\u0013\u007fLP&\u0017r\u0013z\u0000\u001do\\\u001c\u0018\u00011#".toCharArray();
                                        n4 = 0;
                                        int n11 = cArray9.length;
                                        cArray8 = cArray9;
                                        n10 = n11;
                                        if (n11 <= 1) break block36;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block37;
                                    }
                                    do {
                                        char[] cArray10 = cArray8;
                                        char[] cArray11 = cArray8;
                                        int n12 = n4;
                                        while (true) {
                                            int n13;
                                            char c2 = cArray10[n12];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n13 = 11;
                                                    break;
                                                }
                                                case 1: {
                                                    n13 = 41;
                                                    break;
                                                }
                                                case 2: {
                                                    n13 = 112;
                                                    break;
                                                }
                                                case 3: {
                                                    n13 = 109;
                                                    break;
                                                }
                                                default: {
                                                    n13 = 114;
                                                }
                                            }
                                            cArray10[n12] = (char)(c2 ^ n13);
                                            ++n4;
                                            cArray8 = cArray11;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray11 = cArray8;
                                            n9 = n10;
                                            n12 = n10;
                                            cArray10 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[0] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray12 = "{[\u0019\u001b\u0013\u007fLP\b\n{F\u001e\b\u001c\u007f\u0013z".toCharArray();
                                n4 = 0;
                                int n14 = cArray12.length;
                                cArray6 = cArray12;
                                n8 = n14;
                                if (n14 <= 1) break block38;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block39;
                            }
                            do {
                                char[] cArray13 = cArray6;
                                char[] cArray14 = cArray6;
                                int n15 = n4;
                                while (true) {
                                    int n16;
                                    char c3 = cArray13[n15];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n16 = 11;
                                            break;
                                        }
                                        case 1: {
                                            n16 = 41;
                                            break;
                                        }
                                        case 2: {
                                            n16 = 112;
                                            break;
                                        }
                                        case 3: {
                                            n16 = 109;
                                            break;
                                        }
                                        default: {
                                            n16 = 114;
                                        }
                                    }
                                    cArray13[n15] = (char)(c3 ^ n16);
                                    ++n4;
                                    cArray6 = cArray14;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray14 = cArray6;
                                    n7 = n8;
                                    n15 = n8;
                                    cArray13 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[1] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray15 = "BG\u0006\f\u001ebMP?!Jy\u0002\u0004\u0004j]\u0015&\u0017r\t\u0015\u0003\u0011dM\u0019\u0003\u0015'\t\u0014\f\u0006j\t\u001f\u001b\u0017y[\u0005\u0003".toCharArray();
                        n4 = 0;
                        int n17 = cArray15.length;
                        cArray4 = cArray15;
                        n6 = n17;
                        if (n17 <= 1) break block40;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block41;
                    }
                    do {
                        char[] cArray16 = cArray4;
                        char[] cArray17 = cArray4;
                        int n18 = n4;
                        while (true) {
                            int n19;
                            char c4 = cArray16[n18];
                            switch (n4 % 5) {
                                case 0: {
                                    n19 = 11;
                                    break;
                                }
                                case 1: {
                                    n19 = 41;
                                    break;
                                }
                                case 2: {
                                    n19 = 112;
                                    break;
                                }
                                case 3: {
                                    n19 = 109;
                                    break;
                                }
                                default: {
                                    n19 = 114;
                                }
                            }
                            cArray16[n18] = (char)(c4 ^ n19);
                            ++n4;
                            cArray4 = cArray17;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray17 = cArray4;
                            n5 = n6;
                            n18 = n6;
                            cArray16 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[2] = new String(cArray3).intern();
                var0 = null;
                char[] cArray18 = "hF\u0005\u0001\u0016+G\u001f\u0019ROl\"M\u0017eJ\u001f\t\u00171\t".toCharArray();
                n4 = 0;
                int n20 = cArray18.length;
                cArray2 = cArray18;
                n3 = n20;
                if (n20 <= 1) break block42;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block43;
            }
            do {
                char[] cArray19 = cArray2;
                char[] cArray20 = cArray2;
                int n21 = n4;
                while (true) {
                    int n22;
                    char c5 = cArray19[n21];
                    switch (n4 % 5) {
                        case 0: {
                            n22 = 11;
                            break;
                        }
                        case 1: {
                            n22 = 41;
                            break;
                        }
                        case 2: {
                            n22 = 112;
                            break;
                        }
                        case 3: {
                            n22 = 109;
                            break;
                        }
                        default: {
                            n22 = 114;
                        }
                    }
                    cArray19[n21] = (char)(c5 ^ n22);
                    ++n4;
                    cArray2 = cArray20;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray20 = cArray2;
                    n2 = n3;
                    n21 = n3;
                    cArray19 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
    }
}

