/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocaleServiceProviderPool {
    private static Map<Class, LocaleServiceProviderPool> poolOfPools = new ConcurrentHashMap<Class, LocaleServiceProviderPool>();
    private Set<LocaleServiceProvider> providers = new LinkedHashSet<LocaleServiceProvider>();
    private Map<Locale, LocaleServiceProvider> providersCache = new ConcurrentHashMap<Locale, LocaleServiceProvider>();
    private Set<Locale> availableLocales = null;
    private static List<Locale> availableJRELocales = null;
    private Set<Locale> providerLocales = null;

    public static LocaleServiceProviderPool getPool(Class<? extends LocaleServiceProvider> clazz) {
        LocaleServiceProviderPool localeServiceProviderPool;
        LocaleServiceProviderPool localeServiceProviderPool2 = poolOfPools.get(clazz);
        if (localeServiceProviderPool2 == null && (localeServiceProviderPool2 = poolOfPools.put(clazz, localeServiceProviderPool = new LocaleServiceProviderPool(clazz))) == null) {
            localeServiceProviderPool2 = localeServiceProviderPool;
        }
        return localeServiceProviderPool2;
    }

    private LocaleServiceProviderPool(final Class<? extends LocaleServiceProvider> clazz) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    for (LocaleServiceProvider localeServiceProvider : ServiceLoader.loadInstalled(clazz)) {
                        LocaleServiceProviderPool.this.providers.add(localeServiceProvider);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Logger.getLogger("sun.util.LocaleServiceProviderPool").config(privilegedActionException.toString());
        }
    }

    public static Locale[] getAllAvailableLocales() {
        return (Locale[])AllAvailableLocales.allAvailableLocales.clone();
    }

    public synchronized Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            this.availableLocales = new HashSet<Locale>(this.getJRELocales());
            if (this.hasProviders()) {
                this.availableLocales.addAll(this.getProviderLocales());
            }
        }
        Locale[] localeArray = new Locale[this.availableLocales.size()];
        this.availableLocales.toArray(localeArray);
        return localeArray;
    }

    private synchronized Set<Locale> getProviderLocales() {
        if (this.providerLocales == null) {
            this.providerLocales = new HashSet<Locale>();
            if (this.hasProviders()) {
                for (LocaleServiceProvider localeServiceProvider : this.providers) {
                    Locale[] localeArray;
                    for (Locale locale : localeArray = localeServiceProvider.getAvailableLocales()) {
                        this.providerLocales.add(locale);
                    }
                }
            }
        }
        return this.providerLocales;
    }

    public boolean hasProviders() {
        return !this.providers.isEmpty();
    }

    private synchronized List<Locale> getJRELocales() {
        if (availableJRELocales == null) {
            availableJRELocales = Arrays.asList(LocaleData.getAvailableLocales());
        }
        return availableJRELocales;
    }

    private boolean isJRESupported(Locale locale) {
        List<Locale> list = this.getJRELocales();
        return list.contains(locale);
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, Object ... objectArray) {
        return this.getLocalizedObjectImpl(localizedObjectGetter, locale, true, null, null, objectArray);
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, OpenListResourceBundle openListResourceBundle, String string, Object ... objectArray) {
        return this.getLocalizedObjectImpl(localizedObjectGetter, locale, false, openListResourceBundle, string, objectArray);
    }

    private <P, S> S getLocalizedObjectImpl(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, boolean bl, OpenListResourceBundle openListResourceBundle, String string, Object ... objectArray) {
        if (this.hasProviders()) {
            LocaleServiceProvider localeServiceProvider;
            Locale locale2 = openListResourceBundle != null ? openListResourceBundle.getLocale() : null;
            Locale locale3 = locale;
            S s = null;
            while ((locale = this.findProviderLocale(locale, locale2)) != null) {
                localeServiceProvider = this.findProvider(locale);
                if (localeServiceProvider != null) {
                    s = localizedObjectGetter.getObject(localeServiceProvider, locale3, string, objectArray);
                    if (s != null) {
                        return s;
                    }
                    if (bl) {
                        Logger.getLogger("sun.util.LocaleServiceProviderPool").config("A locale sensitive service provider returned null for a localized objects,  which should not happen.  provider: " + localeServiceProvider + " locale: " + locale3);
                    }
                }
                locale = LocaleServiceProviderPool.getParentLocale(locale);
            }
            while (openListResourceBundle != null) {
                locale2 = openListResourceBundle.getLocale();
                if (openListResourceBundle.handleGetKeys().contains(string)) {
                    return null;
                }
                localeServiceProvider = this.findProvider(locale2);
                if (localeServiceProvider != null && (s = (S)localizedObjectGetter.getObject(localeServiceProvider, locale3, string, objectArray)) != null) {
                    return s;
                }
                openListResourceBundle = openListResourceBundle.getParent();
            }
        }
        return null;
    }

    private LocaleServiceProvider findProvider(Locale locale) {
        if (!this.hasProviders()) {
            return null;
        }
        if (this.providersCache.containsKey(locale)) {
            LocaleServiceProvider localeServiceProvider = this.providersCache.get(locale);
            if (localeServiceProvider != NullProvider.INSTANCE) {
                return localeServiceProvider;
            }
        } else {
            for (LocaleServiceProvider localeServiceProvider : this.providers) {
                Locale[] localeArray;
                for (Locale locale2 : localeArray = localeServiceProvider.getAvailableLocales()) {
                    if (!locale.equals(locale2)) continue;
                    LocaleServiceProvider localeServiceProvider2 = this.providersCache.put(locale, localeServiceProvider);
                    return localeServiceProvider2 != null ? localeServiceProvider2 : localeServiceProvider;
                }
            }
            this.providersCache.put(locale, NullProvider.INSTANCE);
        }
        return null;
    }

    private Locale findProviderLocale(Locale locale, Locale locale2) {
        Set<Locale> set = this.getProviderLocales();
        Locale locale3 = locale;
        while (locale3 != null) {
            if (locale2 != null) {
                if (locale3.equals(locale2)) {
                    locale3 = null;
                    break;
                }
            } else if (this.isJRESupported(locale3)) {
                locale3 = null;
                break;
            }
            if (set.contains(locale3)) break;
            locale3 = LocaleServiceProviderPool.getParentLocale(locale3);
        }
        return locale3;
    }

    private static Locale getParentLocale(Locale locale) {
        String string = locale.getVariant();
        if (string != "") {
            int n = string.lastIndexOf(95);
            if (n != -1) {
                return new Locale(locale.getLanguage(), locale.getCountry(), string.substring(0, n));
            }
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry() != "") {
            return new Locale(locale.getLanguage());
        }
        if (locale.getLanguage() != "") {
            return Locale.ROOT;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LocalizedObjectGetter<P, S> {
        public S getObject(P var1, Locale var2, String var3, Object ... var4);
    }

    private static class NullProvider
    extends LocaleServiceProvider {
        private static final NullProvider INSTANCE = new NullProvider();

        private NullProvider() {
        }

        public Locale[] getAvailableLocales() {
            throw new RuntimeException("Should not get called.");
        }
    }

    private static class AllAvailableLocales {
        static final Locale[] allAvailableLocales;

        private AllAvailableLocales() {
        }

        static {
            Class[] classArray = new Class[]{BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class};
            HashSet<Locale> hashSet = new HashSet<Locale>(Arrays.asList(LocaleData.getAvailableLocales()));
            for (Class clazz : classArray) {
                LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(clazz);
                hashSet.addAll(localeServiceProviderPool.getProviderLocales());
            }
            allAvailableLocales = hashSet.toArray(new Locale[0]);
        }
    }
}

