/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import sun.security.action.GetPropertyAction;
import sun.security.tools.CancelButtonListener;
import sun.security.tools.ErrorOKButtonListener;
import sun.security.tools.FileMenuListener;
import sun.security.tools.LegacyList;
import sun.security.tools.MainWindowListener;
import sun.security.tools.NoDisplayException;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyListListener;
import sun.security.tools.PolicyTool;
import sun.security.tools.StatusOKButtonListener;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindowListener;

class ToolWindow
extends JFrame {
    private static final long serialVersionUID = 5682568601210376777L;
    public static final Insets TOP_PADDING = new Insets(25, 0, 0, 0);
    public static final Insets BOTTOM_PADDING = new Insets(0, 0, 25, 0);
    public static final Insets LITE_BOTTOM_PADDING = new Insets(0, 0, 10, 0);
    public static final Insets LR_PADDING = new Insets(0, 10, 0, 10);
    public static final Insets TOP_BOTTOM_PADDING = new Insets(15, 0, 15, 0);
    public static final Insets L_TOP_BOTTOM_PADDING = new Insets(5, 10, 15, 0);
    public static final Insets LR_BOTTOM_PADDING = new Insets(0, 10, 5, 10);
    public static final Insets L_BOTTOM_PADDING = new Insets(0, 10, 5, 0);
    public static final Insets R_BOTTOM_PADDING = new Insets(0, 0, 5, 10);
    public static final String NEW_POLICY_FILE = PolicyTool.rb.getString("New");
    public static final String OPEN_POLICY_FILE = PolicyTool.rb.getString("Open");
    public static final String SAVE_POLICY_FILE = PolicyTool.rb.getString("Save");
    public static final String SAVE_AS_POLICY_FILE = PolicyTool.rb.getString("Save As");
    public static final String VIEW_WARNINGS = PolicyTool.rb.getString("View Warning Log");
    public static final String QUIT = PolicyTool.rb.getString("Exit");
    public static final String ADD_POLICY_ENTRY = PolicyTool.rb.getString("Add Policy Entry");
    public static final String EDIT_POLICY_ENTRY = PolicyTool.rb.getString("Edit Policy Entry");
    public static final String REMOVE_POLICY_ENTRY = PolicyTool.rb.getString("Remove Policy Entry");
    public static final String EDIT_KEYSTORE = PolicyTool.rb.getString("Edit");
    public static final String ADD_PUBKEY_ALIAS = PolicyTool.rb.getString("Add Public Key Alias");
    public static final String REMOVE_PUBKEY_ALIAS = PolicyTool.rb.getString("Remove Public Key Alias");
    public static final int MW_FILENAME_LABEL = 0;
    public static final int MW_FILENAME_TEXTFIELD = 1;
    public static final int MW_PANEL = 2;
    public static final int MW_ADD_BUTTON = 0;
    public static final int MW_EDIT_BUTTON = 1;
    public static final int MW_REMOVE_BUTTON = 2;
    public static final int MW_POLICY_LIST = 3;
    public static final int FILE_MENU_MNEMONIC = ToolWindow.getMnemonic("File Menu Mnemonic");
    public static final int OPEN_MNEMONIC = ToolWindow.getMnemonic("Open Mnemonic");
    public static final int NEW_MNEMONIC = ToolWindow.getMnemonic("New Mnemonic");
    public static final int SAVE_MNEMONIC = ToolWindow.getMnemonic("Save Mnemonic");
    public static final int SAVE_AS_MNEMONIC = ToolWindow.getMnemonic("Save As Mnemonic");
    public static final int VIEW_MNEMONIC = ToolWindow.getMnemonic("View Mnemonic");
    public static final int EXIT_MNEMONIC = ToolWindow.getMnemonic("Exit Mnemonic");
    public static final int KEYSTORE_MENU_MNEMONIC = ToolWindow.getMnemonic("KeyStore Menu Mnemonic");
    public static final int EDIT_MNEMONIC = ToolWindow.getMnemonic("Edit Menu Mnemonic");
    public static final int ADD_POLICY_ENTRY_MNEMONIC = ToolWindow.getMnemonic("Add Policy Entry Mnemonic");
    public static final int EDIT_POLICY_ENTRY_MNEMONIC = ToolWindow.getMnemonic("Edit Policy Entry Mnemonic");
    public static final int REMOVE_POLICY_ENTRY_MNEMONIC = ToolWindow.getMnemonic("Remove Policy Entry Mnemonic");
    private PolicyTool tool;

    public static int getMnemonic(String string) {
        return (Integer)PolicyTool.rb.getObject(string);
    }

    ToolWindow(PolicyTool policyTool) {
        this.tool = policyTool;
    }

    private void initWindow() {
        Object object;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(PolicyTool.rb.getString("File"));
        jMenu.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("File.description"));
        FileMenuListener fileMenuListener = new FileMenuListener(this.tool, this);
        jMenu.setMnemonic(FILE_MENU_MNEMONIC);
        JMenuItem jMenuItem = jMenu.add(NEW_POLICY_FILE);
        jMenuItem.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("New.description"));
        jMenuItem.setMnemonic(NEW_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(OPEN_POLICY_FILE);
        jMenuItem.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Open.description"));
        jMenuItem.setMnemonic(OPEN_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(SAVE_POLICY_FILE);
        jMenuItem.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Save.description"));
        jMenuItem.setMnemonic(SAVE_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(SAVE_AS_POLICY_FILE);
        jMenuItem.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Save As.description"));
        jMenuItem.setMnemonic(SAVE_AS_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(VIEW_WARNINGS);
        jMenuItem.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Warninglog.description"));
        jMenuItem.setMnemonic(VIEW_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(QUIT);
        jMenuItem.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Exit.description"));
        jMenuItem.setMnemonic(EXIT_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuBar.add(jMenu);
        jMenu.addActionListener(fileMenuListener);
        jMenu = new JMenu(PolicyTool.rb.getString("Keystore"));
        jMenu.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("KeyStore.description"));
        jMenu.setMnemonic(KEYSTORE_MENU_MNEMONIC);
        jMenuItem = jMenu.add(EDIT_KEYSTORE);
        jMenuItem.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Edit.description"));
        jMenuItem.setMnemonic(EDIT_MNEMONIC);
        jMenuItem.addActionListener(new MainWindowListener(this.tool, this));
        jMenuBar.add(jMenu);
        jMenuBar.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("PolicyToolMenuBar"));
        jMenuBar.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("PolicyToolMenuBar.description"));
        this.setJMenuBar(jMenuBar);
        this.getContentPane().getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Policy Tool"));
        this.getContentPane().getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("PolicyTool.description"));
        JLabel jLabel = new JLabel(PolicyTool.rb.getString("Policy File:"));
        jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Policyfile.description"));
        this.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, TOP_BOTTOM_PADDING);
        JTextField jTextField = new JTextField(50);
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        jTextField.setToolTipText(PolicyTool.rb.getString("Policyfile.description"));
        this.addNewComponent(this.getContentPane(), jTextField, 1, 1, 0, 1, 1, 0.0, 0.0, 1, TOP_BOTTOM_PADDING);
        jLabel.setLabelFor(jTextField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Policy Tool"));
        jPanel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("PolicyTool.description"));
        final JButton jButton = new JButton(ADD_POLICY_ENTRY);
        jButton.setMnemonic(ADD_POLICY_ENTRY_MNEMONIC);
        jButton.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(jPanel, jButton, 0, 0, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("AddPolicy.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("AddPolicy.description"));
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                jButton.requestFocusInWindow();
            }
        });
        JButton jButton2 = new JButton(EDIT_POLICY_ENTRY);
        jButton2.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(jPanel, jButton2, 1, 1, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        jButton2.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("EditPolicy.description"));
        jButton2.setToolTipText(PolicyTool.rb.getString("EditPolicy.description"));
        jButton2.setMnemonic(EDIT_POLICY_ENTRY_MNEMONIC);
        jButton2 = new JButton(REMOVE_POLICY_ENTRY);
        jButton2.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("RemovePolicy.description"));
        jButton2.setToolTipText(PolicyTool.rb.getString("RemovePolicy.description"));
        jButton2.setMnemonic(REMOVE_POLICY_ENTRY_MNEMONIC);
        jButton2.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(jPanel, jButton2, 2, 2, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        this.addNewComponent(this.getContentPane(), jPanel, 2, 0, 2, 2, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        String string = this.tool.getPolicyFileName();
        if (string == null) {
            object = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            string = (String)object + File.separatorChar + ".java.policy";
        }
        try {
            this.tool.openPolicy(string);
            object = new LegacyList();
            PolicyEntry[] policyEntryArray = this.tool.getEntry();
            if (policyEntryArray != null) {
                for (int i = 0; i < policyEntryArray.length; ++i) {
                    ((LegacyList)object).addTaggedItem(policyEntryArray[i].headerToString(), policyEntryArray[i]);
                }
            }
            ((LegacyList)object).addActionListener(new PolicyListListener(this.tool, this));
            JTextField jTextField2 = (JTextField)this.getContentPane().getComponent(1);
            jTextField2.setText(string);
            this.initPolicyList((LegacyList)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LegacyList legacyList = new LegacyList();
            legacyList.addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(legacyList);
            this.tool.setPolicyFileName(null);
            this.tool.modified = false;
            this.setVisible(true);
            this.tool.warnings.addElement(fileNotFoundException.toString());
        }
        catch (Exception exception) {
            LegacyList legacyList = new LegacyList();
            legacyList.addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(legacyList);
            this.tool.setPolicyFileName(null);
            this.tool.modified = false;
            this.setVisible(true);
            MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Could not open policy file: policyFile: e.toString()"));
            Object[] objectArray = new Object[]{string, exception.toString()};
            this.displayErrorDialog(null, messageFormat.format(objectArray));
        }
    }

    void addNewComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6, Insets insets) {
        container.add(component, n);
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n6;
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    void addNewComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6) {
        this.addNewComponent(container, component, n, n2, n3, n4, n5, d, d2, n6, null);
    }

    void initPolicyList(LegacyList legacyList) {
        this.addNewComponent(this.getContentPane(), legacyList, 3, 0, 3, 2, 1, 1.0, 1.0, 1);
        legacyList.getViewport().getView().getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("PolicyList"));
        legacyList.getViewport().getView().getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("PolicyList.description"));
    }

    void replacePolicyList(LegacyList legacyList) {
        LegacyList legacyList2 = (LegacyList)this.getContentPane().getComponent(3);
        legacyList2.removeAllItems();
        String[] stringArray = legacyList.getItems();
        Object[] objectArray = legacyList.getObjects();
        for (int i = 0; i < stringArray.length; ++i) {
            legacyList2.addTaggedItem(stringArray[i], objectArray[i]);
        }
    }

    void displayToolWindow(String[] stringArray) {
        this.setDefaultCloseOperation(0);
        this.setTitle(PolicyTool.rb.getString("Policy Tool"));
        this.setResizable(true);
        this.addWindowListener(new ToolWindowListener(this, this.tool));
        this.setBounds(135, 80, 500, 500);
        this.setLayout(new GridBagLayout());
        this.initWindow();
        this.setVisible(true);
        if (this.tool.newWarning) {
            this.displayStatusDialog(this, PolicyTool.rb.getString("Errors have occurred while opening the policy configuration.  View the Warning Log for more information."));
        }
    }

    void displayErrorDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Error"), this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 50, 600, 100);
        toolDialog.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.getAccessibleContext().setAccessibleDescription(string);
        this.addNewComponent(toolDialog.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        toolDialog.getContentPane().getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("OKDialog"));
        toolDialog.getContentPane().getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("OKDialog.description"));
        JButton jButton = new JButton(PolicyTool.rb.getString("OK"));
        jButton.setMnemonic(ToolWindow.getMnemonic("OK Mnemonic"));
        jButton.addActionListener(new ErrorOKButtonListener(toolDialog));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("OK.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("OK.description"));
        toolDialog.getRootPane().setDefaultButton(jButton);
        this.addNewComponent(toolDialog.getContentPane(), jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        toolDialog.setVisible(true);
    }

    void displayErrorDialog(Window window, Throwable throwable) {
        if (throwable instanceof NoDisplayException) {
            return;
        }
        this.displayErrorDialog(window, throwable.toString());
    }

    void displayStatusDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Status"), this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 50, 500, 100);
        toolDialog.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.getAccessibleContext().setAccessibleDescription(string);
        this.addNewComponent(toolDialog.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        JButton jButton = new JButton(PolicyTool.rb.getString("OK"));
        jButton.setMnemonic(ToolWindow.getMnemonic("OK Mnemonic"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("OK.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("OK.description"));
        jButton.addActionListener(new StatusOKButtonListener(toolDialog));
        this.addNewComponent(toolDialog.getContentPane(), jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        toolDialog.setVisible(true);
    }

    void displayWarningLog(Window window) {
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Warning"), this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 50, 500, 100);
        toolDialog.setLayout(new GridBagLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        for (int i = 0; i < this.tool.warnings.size(); ++i) {
            jTextArea.append(this.tool.warnings.elementAt(i));
            jTextArea.append(PolicyTool.rb.getString("\n"));
        }
        this.addNewComponent(toolDialog.getContentPane(), jTextArea, 0, 0, 0, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        jTextArea.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Warninglog.description"));
        jTextArea.getAccessibleContext().setAccessibleDescription(PolicyTool.splitToWords(jTextArea.getText()));
        JButton jButton = new JButton(PolicyTool.rb.getString("OK"));
        jButton.setMnemonic(ToolWindow.getMnemonic("OK Mnemonic"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("OK.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("OK.description"));
        jButton.addActionListener(new CancelButtonListener(toolDialog));
        this.addNewComponent(toolDialog.getContentPane(), jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        toolDialog.getRootPane().setDefaultButton(jButton);
        toolDialog.pack();
        toolDialog.setVisible(true);
    }

    char displayYesNoDialog(Window window, String string, String string2, String string3, String string4) {
        final ToolDialog toolDialog = new ToolDialog(string, this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setBounds(point.x + 75, point.y + 100, 400, 150);
        toolDialog.setLayout(new GridBagLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.getAccessibleContext().setAccessibleName(string);
        jTextArea.getAccessibleContext().setAccessibleDescription(PolicyTool.splitToWords(string2));
        jTextArea.setText(string2);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        this.addNewComponent(toolDialog.getContentPane(), jTextArea, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        jTextArea.setFocusable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        final StringBuffer stringBuffer = new StringBuffer();
        JButton jButton = new JButton(string3);
        jButton.setMnemonic(ToolWindow.getMnemonic("Retain Mnemonic"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Retain.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("Retain.description"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                stringBuffer.append('Y');
                toolDialog.setVisible(false);
                toolDialog.dispose();
            }
        });
        this.addNewComponent(jPanel, jButton, 0, 0, 0, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        jButton = new JButton(string4);
        jButton.setMnemonic(ToolWindow.getMnemonic("Edit Mnemonic"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("EditKey.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("Edit.description"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                stringBuffer.append('N');
                toolDialog.setVisible(false);
                toolDialog.dispose();
            }
        });
        this.addNewComponent(jPanel, jButton, 1, 1, 0, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        this.addNewComponent(toolDialog.getContentPane(), jPanel, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        toolDialog.setVisible(true);
        if (stringBuffer.length() > 0) {
            return stringBuffer.charAt(0);
        }
        return 'N';
    }
}

