/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import java.text.MessageFormat;
import sun.security.provider.PolicyParser;
import sun.security.tools.LegacyList;
import sun.security.tools.PolicyTool;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindow;

class NewPolicyPermOKButtonListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;
    private ToolDialog listDialog;
    private ToolDialog infoDialog;
    private boolean edit;

    NewPolicyPermOKButtonListener(PolicyTool policyTool, ToolWindow toolWindow, ToolDialog toolDialog, ToolDialog toolDialog2, boolean bl) {
        this.tool = policyTool;
        this.tw = toolWindow;
        this.listDialog = toolDialog;
        this.infoDialog = toolDialog2;
        this.edit = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object;
            PolicyParser.PermissionEntry permissionEntry = this.infoDialog.getPermFromDialog();
            try {
                this.tool.verifyPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = new MessageFormat(PolicyTool.rb.getString("Warning: Class not found: class"));
                Object[] objectArray = new Object[]{permissionEntry.permission};
                this.tool.warnings.addElement(((Format)object).format(objectArray));
                this.tw.displayStatusDialog(this.infoDialog, ((Format)object).format(objectArray));
            }
            LegacyList legacyList = (LegacyList)this.listDialog.getContentPane().getComponent(8);
            object = ToolDialog.PermissionEntryToUserFriendlyString(permissionEntry);
            if (this.edit) {
                int n = legacyList.getSelectedIndex();
                legacyList.replaceItem((String)object, permissionEntry, n);
            } else {
                legacyList.addTaggedItem((String)object, permissionEntry);
            }
            this.infoDialog.dispose();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.tw.displayErrorDialog((Window)this.infoDialog, invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            this.tw.displayErrorDialog((Window)this.infoDialog, exception);
        }
    }
}

