/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.security.fortress.BootstrapHelper;
import org.apache.harmony.security.fortress.Services;
import sun.security.jca.ServiceId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetInstance {
    private static List<Provider> getProvidersList() {
        ArrayList<Provider> arrayList = null;
        if (BootstrapHelper.isInJarVerify()) {
            arrayList = new ArrayList<Provider>();
            arrayList.add(BootstrapHelper.getBootstrapProvider());
        } else {
            arrayList = Services.getProvidersList();
        }
        return arrayList;
    }

    private static Provider getProvider(String string) {
        Provider provider = null;
        if (BootstrapHelper.isInJarVerify()) {
            Provider provider2 = BootstrapHelper.getBootstrapProvider();
            if (provider2.getName().equals(string)) {
                provider = provider2;
            }
        } else {
            provider = Services.getProvider((String)string);
        }
        return provider;
    }

    private GetInstance() {
    }

    public static Provider.Service getService(String string, String string2) throws NoSuchAlgorithmException {
        Provider provider;
        Provider.Service service = null;
        List<Provider> list = GetInstance.getProvidersList();
        Iterator<Provider> iterator = list.iterator();
        while (iterator.hasNext() && (service = (provider = iterator.next()).getService(string, string2)) == null) {
        }
        if (service == null) {
            throw new NoSuchAlgorithmException(string2 + " " + string + " not available");
        }
        return service;
    }

    public static Provider.Service getService(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Provider provider = GetInstance.getProvider(string3);
        if (provider == null) {
            throw new NoSuchProviderException("no such provider: " + string3);
        }
        Provider.Service service = provider.getService(string, string2);
        if (service == null) {
            throw new NoSuchAlgorithmException("no such algorithm: " + string2 + " for provider " + string3);
        }
        return service;
    }

    public static Provider.Service getService(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Provider.Service service = provider.getService(string, string2);
        if (service == null) {
            throw new NoSuchAlgorithmException("no such algorithm: " + string2 + " for provider " + provider.getName());
        }
        return service;
    }

    public static List<Provider.Service> getServices(String string, String string2) {
        ArrayList<Provider.Service> arrayList = new ArrayList<Provider.Service>();
        List<Provider> list = GetInstance.getProvidersList();
        for (Provider provider : list) {
            Provider.Service service = provider.getService(string, string2);
            if (service == null) continue;
            arrayList.add(service);
        }
        return arrayList;
    }

    @Deprecated
    public static List<Provider.Service> getServices(String string, List<String> list) {
        ArrayList<Provider.Service> arrayList = new ArrayList<Provider.Service>();
        for (String string2 : list) {
            List<Provider> list2 = GetInstance.getProvidersList();
            for (Provider provider : list2) {
                Provider.Service service = provider.getService(string, string2);
                if (service == null) continue;
                arrayList.add(service);
            }
        }
        return arrayList;
    }

    public static List<Provider.Service> getServices(List<ServiceId> list) {
        ArrayList<Provider.Service> arrayList = new ArrayList<Provider.Service>();
        for (ServiceId serviceId : list) {
            List<Provider> list2 = GetInstance.getProvidersList();
            for (Provider provider : list2) {
                Provider.Service service = provider.getService(serviceId.type, serviceId.algorithm);
                if (service == null) continue;
                arrayList.add(service);
            }
        }
        return arrayList;
    }

    public static Instance getInstance(String string, Class clazz, String string2) throws NoSuchAlgorithmException {
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string2 + " " + string + " not available");
        List<Provider> list = GetInstance.getProvidersList();
        for (Provider provider : list) {
            Provider.Service service = provider.getService(string, string2);
            if (service == null) continue;
            try {
                return GetInstance.getInstance(service, clazz);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
            }
        }
        throw noSuchAlgorithmException;
    }

    public static Instance getInstance(String string, Class clazz, String string2, Object object) throws NoSuchAlgorithmException {
        List<Provider.Service> list = GetInstance.getServices(string, string2);
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (Provider.Service service : list) {
            try {
                return GetInstance.getInstance(service, clazz, object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string2 + " " + string + " not available");
    }

    public static Instance getInstance(String string, Class clazz, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        return GetInstance.getInstance(GetInstance.getService(string, string2, string3), clazz);
    }

    public static Instance getInstance(String string, Class clazz, String string2, Object object, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        return GetInstance.getInstance(GetInstance.getService(string, string2, string3), clazz, object);
    }

    public static Instance getInstance(String string, Class clazz, String string2, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(GetInstance.getService(string, string2, provider), clazz);
    }

    public static Instance getInstance(String string, Class clazz, String string2, Object object, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(GetInstance.getService(string, string2, provider), clazz, object);
    }

    public static Instance getInstance(Provider.Service service, Class clazz) throws NoSuchAlgorithmException {
        Object object = service.newInstance(null);
        GetInstance.checkSuperClass(service, object.getClass(), clazz);
        return new Instance(service.getProvider(), object);
    }

    public static Instance getInstance(Provider.Service service, Class clazz, Object object) throws NoSuchAlgorithmException {
        Object object2 = service.newInstance(object);
        GetInstance.checkSuperClass(service, object2.getClass(), clazz);
        return new Instance(service.getProvider(), object2);
    }

    public static void checkSuperClass(Provider.Service service, Class clazz, Class clazz2) throws NoSuchAlgorithmException {
        if (clazz2 == null) {
            return;
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new NoSuchAlgorithmException("class configured for " + service.getType() + ": " + service.getClassName() + " not a " + service.getType());
        }
    }

    public static final class Instance {
        public final Provider provider;
        public final Object impl;

        private Instance(Provider provider, Object object) {
            this.provider = provider;
            this.impl = object;
        }

        public Object[] toArray() {
            return new Object[]{this.impl, this.provider};
        }
    }
}

