/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.Console;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.jar.JarFile;
import sun.misc.JavaIOAccess;
import sun.misc.JavaIODeleteOnExitAccess;
import sun.misc.JavaLangAccess;
import sun.misc.JavaNetAccess;
import sun.misc.JavaUtilJarAccess;
import sun.misc.Unsafe;
import sun.nio.ch.Interruptible;
import sun.reflect.ConstantPool;
import sun.reflect.annotation.AnnotationType;

public class SharedSecrets {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static JavaUtilJarAccess javaUtilJarAccess;
    private static JavaLangAccess javaLangAccess;
    private static JavaIOAccess javaIOAccess;
    private static JavaIODeleteOnExitAccess javaIODeleteOnExitAccess;
    private static JavaNetAccess javaNetAccess;

    public static JavaUtilJarAccess javaUtilJarAccess() {
        if (javaUtilJarAccess == null) {
            unsafe.ensureClassInitialized(JarFile.class);
        }
        return javaUtilJarAccess;
    }

    public static void setJavaUtilJarAccess(JavaUtilJarAccess javaUtilJarAccess) {
        SharedSecrets.javaUtilJarAccess = javaUtilJarAccess;
    }

    public static void setJavaLangAccess(JavaLangAccess javaLangAccess) {
        throw new UnsupportedOperationException("You cannot set the JavaLangAccess Object in this implementation");
    }

    public static JavaLangAccess getJavaLangAccess() {
        return javaLangAccess;
    }

    public static void setJavaNetAccess(JavaNetAccess javaNetAccess) {
        SharedSecrets.javaNetAccess = javaNetAccess;
    }

    public static JavaNetAccess getJavaNetAccess() {
        return javaNetAccess;
    }

    public static void setJavaIOAccess(JavaIOAccess javaIOAccess) {
        SharedSecrets.javaIOAccess = javaIOAccess;
    }

    public static JavaIOAccess getJavaIOAccess() {
        if (javaIOAccess == null) {
            unsafe.ensureClassInitialized(Console.class);
        }
        return javaIOAccess;
    }

    public static void setJavaIODeleteOnExitAccess(JavaIODeleteOnExitAccess javaIODeleteOnExitAccess) {
        SharedSecrets.javaIODeleteOnExitAccess = javaIODeleteOnExitAccess;
    }

    public static JavaIODeleteOnExitAccess getJavaIODeleteOnExitAccess() {
        if (javaIODeleteOnExitAccess == null) {
            unsafe.ensureClassInitialized(File.class);
        }
        return javaIODeleteOnExitAccess;
    }

    static {
        javaLangAccess = new JavaLangAccess(){
            private HashMap<Class, AnnotationType> classToAnnotationType = new HashMap();
            private Method blockedOnMethod = null;

            @Override
            public ConstantPool getConstantPool(Class clazz) {
                throw new UnsupportedOperationException("You cannot access class constant pools this way in this implementation");
            }

            @Override
            public void setAnnotationType(Class clazz, AnnotationType annotationType) {
                this.classToAnnotationType.put(clazz, annotationType);
            }

            @Override
            public AnnotationType getAnnotationType(Class clazz) {
                return this.classToAnnotationType.get(clazz);
            }

            @Override
            public <E extends Enum<E>> E[] getEnumConstantsShared(Class<E> clazz) {
                throw new UnsupportedOperationException("You cannot access Enumeration constant pools this way in this implementation");
            }

            @Override
            public void blockedOn(Thread thread, Interruptible interruptible) {
                if (this.blockedOnMethod == null) {
                    this.initBlockedOn();
                }
                try {
                    this.blockedOnMethod.invoke(thread, interruptible);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new Error(illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Error(illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new Error(invocationTargetException);
                }
            }

            private synchronized void initBlockedOn() {
                if (this.blockedOnMethod != null) {
                    return;
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Class<?> clazz = Class.forName("java.lang.Thread");
                            Method method = clazz.getDeclaredMethod("blockedOn", Interruptible.class);
                            method.setAccessible(true);
                            blockedOnMethod = method;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new Error(classNotFoundException);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new Error(noSuchMethodException);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new Error(illegalArgumentException);
                        }
                        catch (ClassCastException classCastException) {
                            throw new Error(classCastException);
                        }
                        return null;
                    }
                });
            }
        };
    }
}

