/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcPreparedStatement;
import sun.jdbc.odbc.OdbcDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOdbcCallableStatement
extends JdbcOdbcPreparedStatement
implements CallableStatement {
    public byte[] scalez = new byte[200];
    private boolean lastParameterNull = false;

    public JdbcOdbcCallableStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        super(jdbcOdbcConnectionInterface);
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        void var7_10;
        int n4;
        this.setSqlType(n, n2);
        if (n <= 200) {
            this.scalez[n] = (byte)n3;
        }
        this.setOutputParameter(n, true);
        switch (n2) {
            case 91: {
                n4 = 10;
                break;
            }
            case 92: {
                n4 = 8;
                break;
            }
            case 93: {
                n4 = 15;
                if (n3 <= 0) break;
                n4 += n3 + 1;
                break;
            }
            case -7: {
                n4 = 3;
                break;
            }
            case -6: {
                n4 = 4;
                break;
            }
            case 5: {
                n4 = 6;
                break;
            }
            case 4: {
                n4 = 11;
                break;
            }
            case -5: {
                n4 = 20;
                break;
            }
            case 7: {
                n4 = 13;
                break;
            }
            case 6: 
            case 8: {
                n4 = 22;
                break;
            }
            case 2: 
            case 3: {
                n4 = 38;
                break;
            }
            default: {
                n4 = this.getPrecision(n2);
                if (n4 > 0 && n4 <= 8000) break;
                n4 = 8000;
            }
        }
        byte[] byArray = this.getLengthBuf(n);
        n2 = OdbcDef.jdbcTypeToOdbc(n2);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        Object var7_7 = null;
        if (this.boundParams[n - 1].isInOutParameter() && this.boundParams[n - 1].boundValue == null) {
            Object var7_8 = null;
        } else {
            byte[] byArray2 = this.allocBindBuf(n, n4 + 1);
        }
        if (this.boundParams[n - 1].isInOutParameter()) {
            if (this.boundParams[n - 1].boundValue == null) {
                this.OdbcApi.SQLBindInOutParameterNull(this.hStmt, n, n2, n4, this.boundParams[n - 1].scale, byArray, lArray);
            } else if (n2 == 4) {
                if (this.boundParams[n - 1].boundType != 4) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n, n2, n4, (byte[])var7_10, byArray, lArray);
            } else if (n2 == -7) {
                if (this.boundParams[n - 1].boundType != -7) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n, n2, n4, (byte[])var7_10, byArray, lArray);
            } else if (n2 == -6) {
                if (this.boundParams[n - 1].boundType != -6) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n, n2, n4, (byte[])var7_10, byArray, lArray);
            } else if (n2 == 5) {
                if (this.boundParams[n - 1].boundType != 5) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n, n2, n4, (byte[])var7_10, byArray, lArray);
            } else if (n2 == 8 || n2 == 6 || n2 == 7) {
                if (this.boundParams[n - 1].boundType != 8 && this.boundParams[n - 1].boundType != 6 && this.boundParams[n - 1].boundType != 7) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n, 8, n4, (byte[])var7_10, byArray, lArray);
            } else if (n2 == -5) {
                if (this.boundParams[n - 1].boundType != -5) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                this.OdbcApi.SQLBindInOutParameterFixed(this.hStmt, n, n2, n4, (byte[])var7_10, byArray, lArray);
            } else if (n2 == 1 || n2 == 12) {
                int n5;
                if (this.boundParams[n - 1].boundType != 1) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                byte[] byArray3 = new byte[n4 + 1];
                for (n5 = 0; n5 < byArray3.length; ++n5) {
                    byArray3[n5] = 0;
                }
                for (n5 = 0; n5 < ((void)var7_10).length; ++n5) {
                    byArray3[n5] = var7_10[n5];
                }
                this.boundParams[n - 1].resetBindDataBuffer(byArray3);
                this.OdbcApi.SQLBindInOutParameterStr(this.hStmt, n, n2, n4, byArray3, byArray, lArray, -3);
            } else if (n2 == -2 || n2 == -3) {
                int n6;
                if (this.boundParams[n - 1].boundType != -2 && this.boundParams[n - 1].boundType != -3) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                byte[] byArray4 = new byte[n4 + 1];
                for (n6 = 0; n6 < byArray4.length; ++n6) {
                    byArray4[n6] = 0;
                }
                for (n6 = 0; n6 < ((void)var7_10).length; ++n6) {
                    byArray4[n6] = var7_10[n6];
                }
                this.boundParams[n - 1].resetBindDataBuffer(byArray4);
                this.OdbcApi.SQLBindInOutParameterBin(this.hStmt, n, n2, n4, byArray4, byArray, lArray, ((void)var7_10).length);
            } else if (n2 == 2 || n2 == 3) {
                String string = null;
                try {
                    string = this.BytesToChars(this.OdbcApi.charSet, (byte[])var7_10);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                BigDecimal bigDecimal = new BigDecimal(string);
                byte[] byArray5 = null;
                byte[] byArray6 = null;
                if (n3 >= bigDecimal.scale()) {
                    int n7;
                    BigDecimal bigDecimal2 = bigDecimal.movePointRight(n3).movePointLeft(n3);
                    byArray5 = new byte[n4];
                    for (n7 = 0; n7 < byArray5.length; ++n7) {
                        byArray5[n7] = 48;
                    }
                    try {
                        byArray6 = this.CharsToBytes(this.OdbcApi.charSet, bigDecimal2.toString().toCharArray());
                        for (n7 = byArray5.length - byArray6.length; n7 < byArray5.length; ++n7) {
                            byArray5[n7] = byArray6[n7 - (byArray5.length - byArray6.length)];
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.boundParams[n - 1].resetBindDataBuffer(byArray5);
                    this.boundParams[n - 1].scale = bigDecimal2.scale();
                }
                this.OdbcApi.SQLBindInOutParameterString(this.hStmt, n, n2, n4, this.boundParams[n - 1].scale, byArray5, byArray, lArray);
            } else if (n2 == 11) {
                if (this.boundParams[n - 1].boundType != 93) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                int n8 = 0;
                int n9 = 0;
                Timestamp timestamp = (Timestamp)this.boundParams[n - 1].boundValue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                int n10 = calendar.get(1);
                int n11 = calendar.get(2);
                int n12 = calendar.get(5);
                int n13 = calendar.get(11);
                int n14 = calendar.get(12);
                int n15 = calendar.get(13);
                int n16 = timestamp.getNanos();
                byte[] byArray7 = new byte[16];
                this.OdbcApi.getTimestampStruct(byArray7, n10, ++n11, n12, n13, n14, n15, n16);
                this.boundParams[n - 1].resetBindDataBuffer(byArray7);
                Integer n17 = new Integer(n16);
                String string = n17.toString();
                char[] cArray = string.toCharArray();
                for (n8 = cArray.length; n8 > 0 && cArray[n8 - 1] == '0'; --n8) {
                }
                if (n16 == 0) {
                    n8 = 1;
                }
                n9 = 20 + n8;
                this.OdbcApi.SQLBindInOutParameterTimestamp(this.hStmt, n, 29, 9, byArray7, byArray, lArray);
            } else if (n2 == 9) {
                if (this.boundParams[n - 1].boundType != 91) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                Date date = (Date)this.boundParams[n - 1].boundValue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n18 = calendar.get(1);
                int n19 = calendar.get(2);
                int n20 = calendar.get(5);
                byte[] byArray8 = new byte[6];
                this.OdbcApi.getDateStruct(byArray8, n18, ++n19, n20);
                this.boundParams[n - 1].resetBindDataBuffer(byArray8);
                this.OdbcApi.SQLBindInOutParameterDate(this.hStmt, n, this.boundParams[n - 1].scale, byArray8, byArray, lArray);
            } else if (n2 == 10) {
                if (this.boundParams[n - 1].boundType != 92) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                Time time = (Time)this.boundParams[n - 1].boundValue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                int n21 = calendar.get(11);
                int n22 = calendar.get(12);
                int n23 = calendar.get(13);
                byte[] byArray9 = new byte[6];
                this.OdbcApi.getTimeStruct(byArray9, n21, n22, n23);
                this.boundParams[n - 1].resetBindDataBuffer(byArray9);
                this.OdbcApi.SQLBindInOutParameterTime(this.hStmt, n, this.boundParams[n - 1].scale, byArray9, byArray, lArray);
            } else if (n2 == -1) {
                if (this.boundParams[n - 1].boundType != -1 && this.boundParams[n - 1].boundType != 12 && this.boundParams[n - 1].boundType != 1) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                if (this.boundParams[n - 1].boundValue instanceof InputStream) {
                    int n24;
                    byte[] byArray10 = new byte[8000];
                    for (n24 = 0; n24 < byArray10.length; ++n24) {
                        byArray10[n24] = 0;
                    }
                    for (n24 = 0; n24 < ((void)var7_10).length; ++n24) {
                        byArray10[n24] = var7_10[n24];
                    }
                    this.boundParams[n - 1].resetBindDataBuffer(byArray10);
                    byte[] byArray11 = this.getLengthBuf(n);
                    this.OdbcApi.SQLBindInOutParameterAtExec(this.hStmt, n, 1, -1, byArray10.length, byArray10, this.boundParams[n - 1].getInputStreamLen(), byArray11, lArray);
                } else {
                    if (!(this.boundParams[n - 1].boundValue instanceof String)) throw new UnsupportedOperationException();
                    byte[] byArray12 = null;
                    try {
                        byArray12 = ((String)this.boundParams[n - 1].boundValue).getBytes(this.OdbcApi.charSet);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new SQLException(unsupportedEncodingException.getMessage());
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray12);
                    this.boundParams[n - 1].setInputStream(byteArrayInputStream, byArray12.length);
                    byte[] byArray13 = new byte[8000];
                    for (int i = 0; i < byArray13.length; ++i) {
                        byArray13[i] = 0;
                    }
                    JdbcOdbc.intTo4Bytes(n, byArray13);
                    this.boundParams[n - 1].resetBindDataBuffer(byArray13);
                    byte[] byArray14 = this.getLengthBuf(n);
                    this.OdbcApi.SQLBindInOutParameterAtExec(this.hStmt, n, 1, -1, byArray13.length, byArray13, this.boundParams[n - 1].getInputStreamLen(), byArray14, lArray);
                }
            } else {
                if (n2 != -4) throw new UnsupportedOperationException();
                if (this.boundParams[n - 1].boundType != -4 && this.boundParams[n - 1].boundType != -3 && this.boundParams[n - 1].boundType != -2) throw new SQLException("Type mismatch between the set function and registerOutParameter");
                if (this.boundParams[n - 1].boundValue instanceof InputStream) {
                    int n25;
                    byte[] byArray15 = new byte[8000];
                    for (n25 = 0; n25 < byArray15.length; ++n25) {
                        byArray15[n25] = 48;
                    }
                    for (n25 = 0; n25 < ((void)var7_10).length; ++n25) {
                        byArray15[n25] = var7_10[n25];
                    }
                    this.boundParams[n - 1].resetBindDataBuffer(byArray15);
                    byte[] byArray16 = this.getLengthBuf(n);
                    this.OdbcApi.SQLBindInOutParameterAtExec(this.hStmt, n, -2, -4, byArray15.length, byArray15, this.boundParams[n - 1].getInputStreamLen(), byArray16, lArray);
                } else {
                    if (!(this.boundParams[n - 1].boundValue instanceof byte[])) throw new UnsupportedOperationException();
                    byte[] byArray17 = (byte[])this.boundParams[n - 1].boundValue;
                    this.boundParams[n - 1].setInputStream(new ByteArrayInputStream(byArray17), byArray17.length);
                    byte[] byArray18 = new byte[8000];
                    for (int i = 0; i < byArray18.length; ++i) {
                        byArray18[i] = 48;
                    }
                    JdbcOdbc.intTo4Bytes(n, byArray18);
                    this.boundParams[n - 1].resetBindDataBuffer(byArray18);
                    byte[] byArray19 = this.getLengthBuf(n);
                    this.OdbcApi.SQLBindInOutParameterAtExec(this.hStmt, n, -2, -4, byArray18.length, byArray18, this.boundParams[n - 1].getInputStreamLen(), byArray19, lArray);
                }
            }
        } else if (n2 == 0) {
            this.OdbcApi.SQLBindOutParameterNull(this.hStmt, n, n2, n4, this.boundParams[n - 1].scale, byArray, lArray);
        } else if (n2 == 8 || n2 == 6 || n2 == 7) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n, 8, n4, (byte[])var7_10, byArray, lArray);
        } else if (n2 == 4) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n, n2, n4, (byte[])var7_10, byArray, lArray);
        } else if (n2 == -6) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n, n2, n4, (byte[])var7_10, byArray, lArray);
        } else if (n2 == 5) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n, n2, n4, (byte[])var7_10, byArray, lArray);
        } else if (n2 == -7) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n, n2, 1, (byte[])var7_10, byArray, lArray);
        } else if (n2 == -5) {
            this.OdbcApi.SQLBindOutParameterFixed(this.hStmt, n, n2, n4, (byte[])var7_10, byArray, lArray);
        } else if (n2 == 2 || n2 == 3) {
            this.OdbcApi.SQLBindOutParameterString(this.hStmt, n, n2, n3, (byte[])var7_10, byArray, lArray);
        } else if (n2 == 11) {
            this.OdbcApi.SQLBindOutParameterTimestamp(this.hStmt, n, n4, (byte[])var7_10, byArray, lArray);
        } else if (n2 == 9) {
            this.OdbcApi.SQLBindOutParameterDate(this.hStmt, n, this.boundParams[n - 1].scale, (byte[])var7_10, byArray, lArray);
        } else if (n2 == 10) {
            this.OdbcApi.SQLBindOutParameterTime(this.hStmt, n, this.boundParams[n - 1].scale, (byte[])var7_10, byArray, lArray);
        } else if (n2 == -2 || n2 == -3 || n2 == -4) {
            this.OdbcApi.SQLBindOutParameterBinary(this.hStmt, n, n2, n4, n3, (byte[])var7_10, byArray, lArray);
        } else if (n2 == 1 || n2 == 12 || n2 == -1) {
            this.OdbcApi.SQLBindOutParameterString(this.hStmt, n, n2, n3, (byte[])var7_10, byArray, lArray);
        } else {
            this.OdbcApi.SQLBindOutParameterString(this.hStmt, n, n2, n3, (byte[])var7_10, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].pB1 = lArray[2];
        this.boundParams[n - 1].pB2 = lArray[3];
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastParameterNull;
    }

    @Override
    public String getString(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        int n2 = this.getSqlType(n);
        String string = null;
        try {
            byte[] byArray = this.getDataBuf(n);
            if (byArray != null) {
                string = this.BytesToChars(this.OdbcApi.charSet, byArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("String value for OUT parameter " + n + "=" + string);
        }
        return string;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        if (this.isNull(n)) {
            return false;
        }
        return this.getInt(n) == 1;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    @Override
    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    @Override
    public int getInt(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0;
        }
        return this.OdbcApi.bufferToInt(this.getDataBuf(n));
    }

    @Override
    public long getLong(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0L;
        }
        return this.OdbcApi.bufferToLong(this.getDataBuf(n));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0.0f;
        }
        return (float)this.OdbcApi.bufferToDouble(this.getDataBuf(n));
    }

    @Override
    public double getDouble(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0.0;
        }
        return this.OdbcApi.bufferToDouble(this.getDataBuf(n));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n).trim());
        return bigDecimal.setScale(n2, 6);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        if (this.boundParams[n - 1].isInOutParameter() || this.boundParams[n - 1].isOutputParameter()) {
            byte[] byArray;
            int n2 = this.getParamLength(n);
            if (n2 < (byArray = this.getDataBuf(n)).length) {
                byte[] byArray2 = new byte[n2];
                for (int i = 0; i < this.getParamLength(n); ++i) {
                    byArray2[i] = byArray[i];
                }
                this.boundParams[n - 1].resetBindDataBuffer(byArray2);
                return byArray2;
            }
            return byArray;
        }
        return JdbcOdbcCallableStatement.hexStringToByteArray(this.getString(n).trim());
    }

    @Override
    public Date getDate(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        byte[] byArray = this.getDataBuf(n);
        byte[] byArray2 = new byte[11];
        this.OdbcApi.convertDateString(byArray, byArray2);
        return Date.valueOf(new String(byArray2).trim());
    }

    @Override
    public Time getTime(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        byte[] byArray = this.getDataBuf(n);
        byte[] byArray2 = new byte[9];
        this.OdbcApi.convertTimeString(byArray, byArray2);
        return Time.valueOf(new String(byArray2).trim());
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        byte[] byArray = this.getDataBuf(n);
        byte[] byArray2 = new byte[30];
        this.OdbcApi.convertTimestampString(byArray, byArray2);
        return Timestamp.valueOf(new String(byArray2).trim());
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object = null;
        int n2 = this.getSqlType(n);
        if (this.isNull(n)) {
            return null;
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                if (n <= 200) {
                    object = this.getBigDecimal(n, this.scalez[n]);
                    break;
                }
                object = this.getBigDecimal(n, 4);
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: {
                object = new Integer(this.getByte(n));
                break;
            }
            case 5: {
                object = new Integer(this.getShort(n));
                break;
            }
            case 4: {
                object = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 6: 
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
            }
        }
        return object;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n).trim());
        return bigDecimal;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        long l = 0L;
        if (this.getDate(n) == null) {
            return null;
        }
        if (this.getDate(n) != null) {
            l = this.utils.convertFromGMT(this.getDate(n), calendar);
        }
        if (l == 0L) {
            return null;
        }
        return new Date(l);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        long l = 0L;
        if (this.getTime(n) == null) {
            return null;
        }
        if (this.getTime(n) != null) {
            try {
                l = this.utils.convertFromGMT(this.getTime(n), calendar);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (l == 0L) {
            return null;
        }
        return new Time(l);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        long l = 0L;
        if (this.getTimestamp(n) == null) {
            return null;
        }
        try {
            l = this.utils.convertFromGMT(this.getTimestamp(n), calendar);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l == 0L) {
            return null;
        }
        return new Timestamp(l);
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected boolean isNull(int n) throws SQLException {
        if (!this.isOutputParameter(n)) {
            throw new SQLException("Parameter " + n + " is not an OUTPUT parameter");
        }
        boolean bl = false;
        boolean bl2 = bl = this.getParamLength(n) == -1;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("Output Parameter " + n + " null: " + bl);
        }
        this.lastParameterNull = bl;
        return bl;
    }

    protected void setOutputParameter(int n, boolean bl) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setOutputParameter(bl);
        }
    }

    protected boolean isOutputParameter(int n) {
        boolean bl = false;
        if (n >= 1 && n <= this.numParams) {
            bl = this.boundParams[n - 1].isOutputParameter();
        }
        return bl;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0L) {
                if (this.closeCalledFromFinalize) {
                    if (!this.myConnection.isFreeStmtsFromConnectionOnly()) {
                        this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                    }
                } else {
                    this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                }
                this.hStmt = 0L;
                this.FreeParams();
                for (int i = 1; this.boundParams != null && i <= this.boundParams.length; ++i) {
                    this.boundParams[i - 1].binaryData = null;
                    this.boundParams[i - 1].initialize();
                    this.boundParams[i - 1].paramInputStream = null;
                    this.boundParams[i - 1].inputParameter = false;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.myConnection.deregisterStatement(this);
    }

    @Override
    public synchronized void FreeParams() throws NullPointerException {
        try {
            for (int i = 1; i <= this.boundParams.length; ++i) {
                if (this.boundParams[i - 1].pA1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[i - 1].pA1, this.boundParams[i - 1].pA2);
                    this.boundParams[i - 1].pA1 = 0L;
                    this.boundParams[i - 1].pA2 = 0L;
                }
                if (this.boundParams[i - 1].pB1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[i - 1].pB1, this.boundParams[i - 1].pB2);
                    this.boundParams[i - 1].pB1 = 0L;
                    this.boundParams[i - 1].pB2 = 0L;
                }
                if (this.boundParams[i - 1].pC1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[i - 1].pC1, this.boundParams[i - 1].pC2);
                    this.boundParams[i - 1].pC1 = 0L;
                    this.boundParams[i - 1].pC2 = 0L;
                }
                if (this.boundParams[i - 1].pS1 == 0L) continue;
                JdbcOdbc.ReleaseStoredChars(this.boundParams[i - 1].pS1, this.boundParams[i - 1].pS2);
                this.boundParams[i - 1].pS1 = 0L;
                this.boundParams[i - 1].pS2 = 0L;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
    }
}

