/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicScrollBarUI
extends ScrollBarUI
implements LayoutManager,
SwingConstants {
    private static final int POSITIVE_SCROLL = 1;
    private static final int NEGATIVE_SCROLL = -1;
    private static final int MIN_SCROLL = 2;
    private static final int MAX_SCROLL = 3;
    protected Dimension minimumThumbSize;
    protected Dimension maximumThumbSize;
    protected Color thumbHighlightColor;
    protected Color thumbLightShadowColor;
    protected Color thumbDarkShadowColor;
    protected Color thumbColor;
    protected Color trackColor;
    protected Color trackHighlightColor;
    protected JScrollBar scrollbar;
    protected JButton incrButton;
    protected JButton decrButton;
    protected boolean isDragging;
    protected TrackListener trackListener;
    protected ArrowButtonListener buttonListener;
    protected ModelListener modelListener;
    protected Rectangle thumbRect;
    protected Rectangle trackRect;
    protected int trackHighlight;
    protected static final int NO_HIGHLIGHT = 0;
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    protected Timer scrollTimer;
    private static final int scrollSpeedThrottle = 60;
    private boolean supportsAbsolutePositioning;
    private int scrollBarWidth;
    private Handler handler;
    private boolean thumbActive;
    private boolean useCachedValue = false;
    private int scrollBarValue;

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("positiveUnitIncrement"));
        lazyActionMap.put(new Actions("positiveBlockIncrement"));
        lazyActionMap.put(new Actions("negativeUnitIncrement"));
        lazyActionMap.put(new Actions("negativeBlockIncrement"));
        lazyActionMap.put(new Actions("minScroll"));
        lazyActionMap.put(new Actions("maxScroll"));
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollBarUI();
    }

    protected void configureScrollBarColors() {
        LookAndFeel.installColors(this.scrollbar, "ScrollBar.background", "ScrollBar.foreground");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbShadow");
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
    }

    public void installUI(JComponent jComponent) {
        this.scrollbar = (JScrollBar)jComponent;
        this.thumbRect = new Rectangle(0, 0, 0, 0);
        this.trackRect = new Rectangle(0, 0, 0, 0);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.scrollbar = (JScrollBar)jComponent;
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallKeyboardActions();
        this.thumbRect = null;
        this.scrollbar = null;
        this.incrButton = null;
        this.decrButton = null;
    }

    protected void installDefaults() {
        this.scrollBarWidth = UIManager.getInt("ScrollBar.width");
        if (this.scrollBarWidth <= 0) {
            this.scrollBarWidth = 16;
        }
        this.minimumThumbSize = (Dimension)UIManager.get("ScrollBar.minimumThumbSize");
        this.maximumThumbSize = (Dimension)UIManager.get("ScrollBar.maximumThumbSize");
        Boolean bl = (Boolean)UIManager.get("ScrollBar.allowsAbsolutePositioning");
        this.supportsAbsolutePositioning = bl != null ? bl : false;
        this.trackHighlight = 0;
        if (this.scrollbar.getLayout() == null || this.scrollbar.getLayout() instanceof UIResource) {
            this.scrollbar.setLayout(this);
        }
        this.configureScrollBarColors();
        LookAndFeel.installBorder(this.scrollbar, "ScrollBar.border");
        LookAndFeel.installProperty(this.scrollbar, "opaque", Boolean.TRUE);
        this.scrollBarValue = this.scrollbar.getValue();
    }

    protected void installComponents() {
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                this.incrButton = this.createIncreaseButton(5);
                this.decrButton = this.createDecreaseButton(1);
                break;
            }
            case 0: {
                if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    this.incrButton = this.createIncreaseButton(3);
                    this.decrButton = this.createDecreaseButton(7);
                    break;
                }
                this.incrButton = this.createIncreaseButton(7);
                this.decrButton = this.createDecreaseButton(3);
            }
        }
        this.scrollbar.add(this.incrButton);
        this.scrollbar.add(this.decrButton);
        this.scrollbar.setEnabled(this.scrollbar.isEnabled());
    }

    protected void uninstallComponents() {
        this.scrollbar.remove(this.incrButton);
        this.scrollbar.remove(this.decrButton);
    }

    protected void installListeners() {
        this.trackListener = this.createTrackListener();
        this.buttonListener = this.createArrowButtonListener();
        this.modelListener = this.createModelListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.scrollbar.addMouseListener(this.trackListener);
        this.scrollbar.addMouseMotionListener(this.trackListener);
        this.scrollbar.getModel().addChangeListener(this.modelListener);
        this.scrollbar.addPropertyChangeListener(this.propertyChangeListener);
        this.scrollbar.addFocusListener(this.getHandler());
        if (this.incrButton != null) {
            this.incrButton.addMouseListener(this.buttonListener);
        }
        if (this.decrButton != null) {
            this.decrButton.addMouseListener(this.buttonListener);
        }
        this.scrollListener = this.createScrollListener();
        this.scrollTimer = new Timer(60, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
    }

    protected void installKeyboardActions() {
        LazyActionMap.installLazyActionMap(this.scrollbar, BasicScrollBarUI.class, "ScrollBar.actionMap");
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.scrollbar, 0, inputMap);
        inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.scrollbar, 1, inputMap);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.scrollbar, 0, null);
        SwingUtilities.replaceUIActionMap(this.scrollbar, null);
    }

    private InputMap getInputMap(int n) {
        if (n == 0) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)DefaultLookup.get(this.scrollbar, this, "ScrollBar.focusInputMap");
            if (this.scrollbar.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)DefaultLookup.get(this.scrollbar, this, "ScrollBar.focusInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        if (n == 1) {
            InputMap inputMap;
            InputMap inputMap3 = (InputMap)DefaultLookup.get(this.scrollbar, this, "ScrollBar.ancestorInputMap");
            if (this.scrollbar.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)DefaultLookup.get(this.scrollbar, this, "ScrollBar.ancestorInputMap.RightToLeft")) == null) {
                return inputMap3;
            }
            inputMap.setParent(inputMap3);
            return inputMap;
        }
        return null;
    }

    protected void uninstallListeners() {
        this.scrollTimer.stop();
        this.scrollTimer = null;
        if (this.decrButton != null) {
            this.decrButton.removeMouseListener(this.buttonListener);
        }
        if (this.incrButton != null) {
            this.incrButton.removeMouseListener(this.buttonListener);
        }
        this.scrollbar.getModel().removeChangeListener(this.modelListener);
        this.scrollbar.removeMouseListener(this.trackListener);
        this.scrollbar.removeMouseMotionListener(this.trackListener);
        this.scrollbar.removePropertyChangeListener(this.propertyChangeListener);
        this.scrollbar.removeFocusListener(this.getHandler());
        this.handler = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.scrollbar);
        if (this.scrollbar.getLayout() == this) {
            this.scrollbar.setLayout(null);
        }
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    protected ArrowButtonListener createArrowButtonListener() {
        return new ArrowButtonListener();
    }

    protected ModelListener createModelListener() {
        return new ModelListener();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private void updateThumbState(int n, int n2) {
        Rectangle rectangle = this.getThumbBounds();
        this.setThumbRollover(rectangle.contains(n, n2));
    }

    protected void setThumbRollover(boolean bl) {
        if (this.thumbActive != bl) {
            this.thumbActive = bl;
            this.scrollbar.repaint(this.getThumbBounds());
        }
    }

    public boolean isThumbRollover() {
        return this.thumbActive;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintTrack(graphics, jComponent, this.getTrackBounds());
        Rectangle rectangle = this.getThumbBounds();
        if (rectangle.intersects(graphics.getClipBounds())) {
            this.paintThumb(graphics, jComponent, rectangle);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.scrollbar.getOrientation() == 1 ? new Dimension(this.scrollBarWidth, 48) : new Dimension(48, this.scrollBarWidth);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected JButton createDecreaseButton(int n) {
        return new BasicArrowButton(n, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    protected JButton createIncreaseButton(int n) {
        return new BasicArrowButton(n, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    protected void paintDecreaseHighlight(Graphics graphics) {
        Insets insets = this.scrollbar.getInsets();
        Rectangle rectangle = this.getThumbBounds();
        graphics.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 1) {
            int n = insets.left;
            int n2 = this.decrButton.getY() + this.decrButton.getHeight();
            int n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
            int n4 = rectangle.y - n2;
            graphics.fillRect(n, n2, n3, n4);
        } else {
            int n;
            int n5;
            if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                n5 = this.decrButton.getX() + this.decrButton.getWidth();
                n = rectangle.x - n5;
            } else {
                n5 = rectangle.x + rectangle.width;
                n = this.decrButton.getX() - n5;
            }
            int n6 = insets.top;
            int n7 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            graphics.fillRect(n5, n6, n, n7);
        }
    }

    protected void paintIncreaseHighlight(Graphics graphics) {
        Insets insets = this.scrollbar.getInsets();
        Rectangle rectangle = this.getThumbBounds();
        graphics.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 1) {
            int n = insets.left;
            int n2 = rectangle.y + rectangle.height;
            int n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
            int n4 = this.incrButton.getY() - n2;
            graphics.fillRect(n, n2, n3, n4);
        } else {
            int n;
            int n5;
            if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                n5 = rectangle.x + rectangle.width;
                n = this.incrButton.getX() - n5;
            } else {
                n5 = this.incrButton.getX() + this.incrButton.getWidth();
                n = rectangle.x - n5;
            }
            int n6 = insets.top;
            int n7 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            graphics.fillRect(n5, n6, n, n7);
        }
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(this.trackColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(graphics);
        } else if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(graphics);
        }
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(this.thumbDarkShadowColor);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.thumbColor);
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.thumbHighlightColor);
        graphics.drawLine(1, 1, 1, n2 - 2);
        graphics.drawLine(2, 1, n - 3, 1);
        graphics.setColor(this.thumbLightShadowColor);
        graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
        graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    protected Dimension getMaximumThumbSize() {
        return this.maximumThumbSize;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize((JComponent)container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getMinimumSize((JComponent)container);
    }

    private int getValue(JScrollBar jScrollBar) {
        return this.useCachedValue ? this.scrollBarValue : jScrollBar.getValue();
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = insets.left;
        boolean bl = DefaultLookup.getBoolean(this.scrollbar, this, "ScrollBar.squareButtons", false);
        int n4 = bl ? n2 : this.decrButton.getPreferredSize().height;
        int n5 = insets.top;
        int n6 = bl ? n2 : this.incrButton.getPreferredSize().height;
        int n7 = dimension.height - (insets.bottom + n6);
        int n8 = insets.top + insets.bottom;
        int n9 = n4 + n6;
        float f = dimension.height - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = this.getValue(jScrollBar);
        int n10 = f4 <= 0.0f ? this.getMaximumThumbSize().height : (int)(f * (f3 / f4));
        n10 = Math.max(n10, this.getMinimumThumbSize().height);
        n10 = Math.min(n10, this.getMaximumThumbSize().height);
        int n11 = n7 - n10;
        if (f5 < (float)(jScrollBar.getMaximum() - jScrollBar.getVisibleAmount())) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
            n11 += n5 + n4;
        }
        if ((n = dimension.height - n8) < n9) {
            n6 = n4 = n / 2;
            n7 = dimension.height - (insets.bottom + n6);
        }
        this.decrButton.setBounds(n3, n5, n2, n4);
        this.incrButton.setBounds(n3, n7, n2, n6);
        int n12 = n5 + n4;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n3, n12, n2, n13);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n11 + n10 > n7) {
                n11 = n7 - n10;
            }
            if (n11 < n5 + n4) {
                n11 = n5 + n4 + 1;
            }
            this.setThumbBounds(n3, n11, n2, n10);
        }
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        int n;
        int n2;
        int n3;
        int n4;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n5 = dimension.height - (insets.top + insets.bottom);
        int n6 = insets.top;
        boolean bl = jScrollBar.getComponentOrientation().isLeftToRight();
        boolean bl2 = DefaultLookup.getBoolean(this.scrollbar, this, "ScrollBar.squareButtons", false);
        int n7 = bl2 ? n5 : this.decrButton.getPreferredSize().width;
        int n8 = n4 = bl2 ? n5 : this.incrButton.getPreferredSize().width;
        if (!bl) {
            n3 = n7;
            n7 = n4;
            n4 = n3;
        }
        n3 = insets.left;
        int n9 = dimension.width - (insets.right + n4);
        int n10 = insets.left + insets.right;
        int n11 = n7 + n4;
        float f = dimension.width - (n10 + n11);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getMaximum();
        float f4 = jScrollBar.getVisibleAmount();
        float f5 = f3 - f2;
        float f6 = this.getValue(jScrollBar);
        int n12 = f5 <= 0.0f ? this.getMaximumThumbSize().width : (int)(f * (f4 / f5));
        n12 = Math.max(n12, this.getMinimumThumbSize().width);
        n12 = Math.min(n12, this.getMaximumThumbSize().width);
        int n13 = n2 = bl ? n9 - n12 : n3 + n7;
        if (f6 < f3 - (float)jScrollBar.getVisibleAmount()) {
            float f7 = f - (float)n12;
            n2 = bl ? (int)(0.5f + f7 * ((f6 - f2) / (f5 - f4))) : (int)(0.5f + f7 * ((f3 - f4 - f6) / (f5 - f4)));
            n2 += n3 + n7;
        }
        if ((n = dimension.width - n10) < n11) {
            n4 = n7 = n / 2;
            n9 = dimension.width - (insets.right + n4);
        }
        (bl ? this.decrButton : this.incrButton).setBounds(n3, n6, n7, n5);
        (bl ? this.incrButton : this.decrButton).setBounds(n9, n6, n4, n5);
        int n14 = n3 + n7;
        int n15 = n9 - n14;
        this.trackRect.setBounds(n14, n6, n15, n5);
        if (n12 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n2 + n12 > n9) {
                n2 = n9 - n12;
            }
            if (n2 < n3 + n7) {
                n2 = n3 + n7 + 1;
            }
            this.setThumbBounds(n2, n6, n12, n5);
        }
    }

    public void layoutContainer(Container container) {
        if (this.isDragging) {
            return;
        }
        JScrollBar jScrollBar = (JScrollBar)container;
        switch (jScrollBar.getOrientation()) {
            case 1: {
                this.layoutVScrollbar(jScrollBar);
                break;
            }
            case 0: {
                this.layoutHScrollbar(jScrollBar);
            }
        }
    }

    protected void setThumbBounds(int n, int n2, int n3, int n4) {
        if (this.thumbRect.x == n && this.thumbRect.y == n2 && this.thumbRect.width == n3 && this.thumbRect.height == n4) {
            return;
        }
        int n5 = Math.min(n, this.thumbRect.x);
        int n6 = Math.min(n2, this.thumbRect.y);
        int n7 = Math.max(n + n3, this.thumbRect.x + this.thumbRect.width);
        int n8 = Math.max(n2 + n4, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(n, n2, n3, n4);
        this.scrollbar.repaint(n5, n6, n7 - n5, n8 - n6);
        this.setThumbRollover(false);
    }

    protected Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    protected Rectangle getTrackBounds() {
        return this.trackRect;
    }

    static void scrollByBlock(JScrollBar jScrollBar, int n) {
        int n2 = jScrollBar.getValue();
        int n3 = jScrollBar.getBlockIncrement(n);
        int n4 = n3 * (n > 0 ? 1 : -1);
        int n5 = n2 + n4;
        if (n4 > 0 && n5 < n2) {
            n5 = jScrollBar.getMaximum();
        } else if (n4 < 0 && n5 > n2) {
            n5 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n5);
    }

    protected void scrollByBlock(int n) {
        BasicScrollBarUI.scrollByBlock(this.scrollbar, n);
        this.trackHighlight = n > 0 ? 2 : 1;
        Rectangle rectangle = this.getTrackBounds();
        this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static void scrollByUnits(JScrollBar jScrollBar, int n, int n2, boolean bl) {
        int n3 = -1;
        if (bl) {
            n3 = n < 0 ? jScrollBar.getValue() - jScrollBar.getBlockIncrement(n) : jScrollBar.getValue() + jScrollBar.getBlockIncrement(n);
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = n > 0 ? jScrollBar.getUnitIncrement(n) : -jScrollBar.getUnitIncrement(n);
            int n5 = jScrollBar.getValue();
            int n6 = n5 + n4;
            if (n4 > 0 && n6 < n5) {
                n6 = jScrollBar.getMaximum();
            } else if (n4 < 0 && n6 > n5) {
                n6 = jScrollBar.getMinimum();
            }
            if (n5 == n6) break;
            if (bl && i > 0) {
                assert (n3 != -1);
                if (n < 0 && n6 < n3 || n > 0 && n6 > n3) break;
            }
            jScrollBar.setValue(n6);
        }
    }

    protected void scrollByUnit(int n) {
        BasicScrollBarUI.scrollByUnits(this.scrollbar, n, 1, false);
    }

    public boolean getSupportsAbsolutePositioning() {
        return this.supportsAbsolutePositioning;
    }

    private boolean isMouseLeftOfThumb() {
        return this.trackListener.currentMouseX < this.getThumbBounds().x;
    }

    private boolean isMouseRightOfThumb() {
        Rectangle rectangle = this.getThumbBounds();
        return this.trackListener.currentMouseX > rectangle.x + rectangle.width;
    }

    private boolean isMouseBeforeThumb() {
        return this.scrollbar.getComponentOrientation().isLeftToRight() ? this.isMouseLeftOfThumb() : this.isMouseRightOfThumb();
    }

    private boolean isMouseAfterThumb() {
        return this.scrollbar.getComponentOrientation().isLeftToRight() ? this.isMouseRightOfThumb() : this.isMouseLeftOfThumb();
    }

    private void updateButtonDirections() {
        int n = this.scrollbar.getOrientation();
        if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            if (this.incrButton instanceof BasicArrowButton) {
                ((BasicArrowButton)this.incrButton).setDirection(n == 0 ? 3 : 5);
            }
            if (this.decrButton instanceof BasicArrowButton) {
                ((BasicArrowButton)this.decrButton).setDirection(n == 0 ? 7 : 1);
            }
        } else {
            if (this.incrButton instanceof BasicArrowButton) {
                ((BasicArrowButton)this.incrButton).setDirection(n == 0 ? 7 : 5);
            }
            if (this.decrButton instanceof BasicArrowButton) {
                ((BasicArrowButton)this.decrButton).setDirection(n == 0 ? 3 : 1);
            }
        }
    }

    private class Handler
    implements FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            BasicScrollBarUI.this.scrollbar.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicScrollBarUI.this.scrollbar.repaint();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("model" == string) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                BoundedRangeModel boundedRangeModel2 = (BoundedRangeModel)propertyChangeEvent.getNewValue();
                boundedRangeModel.removeChangeListener(BasicScrollBarUI.this.modelListener);
                boundedRangeModel2.addChangeListener(BasicScrollBarUI.this.modelListener);
                BasicScrollBarUI.this.scrollbar.repaint();
                BasicScrollBarUI.this.scrollbar.revalidate();
            } else if ("orientation" == string) {
                BasicScrollBarUI.this.updateButtonDirections();
            } else if ("componentOrientation" == string) {
                BasicScrollBarUI.this.updateButtonDirections();
                InputMap inputMap = BasicScrollBarUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(BasicScrollBarUI.this.scrollbar, 0, inputMap);
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String POSITIVE_UNIT_INCREMENT = "positiveUnitIncrement";
        private static final String POSITIVE_BLOCK_INCREMENT = "positiveBlockIncrement";
        private static final String NEGATIVE_UNIT_INCREMENT = "negativeUnitIncrement";
        private static final String NEGATIVE_BLOCK_INCREMENT = "negativeBlockIncrement";
        private static final String MIN_SCROLL = "minScroll";
        private static final String MAX_SCROLL = "maxScroll";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
            String string = this.getName();
            if (string == POSITIVE_UNIT_INCREMENT) {
                this.scroll(jScrollBar, 1, false);
            } else if (string == POSITIVE_BLOCK_INCREMENT) {
                this.scroll(jScrollBar, 1, true);
            } else if (string == NEGATIVE_UNIT_INCREMENT) {
                this.scroll(jScrollBar, -1, false);
            } else if (string == NEGATIVE_BLOCK_INCREMENT) {
                this.scroll(jScrollBar, -1, true);
            } else if (string == MIN_SCROLL) {
                this.scroll(jScrollBar, 2, true);
            } else if (string == MAX_SCROLL) {
                this.scroll(jScrollBar, 3, true);
            }
        }

        private void scroll(JScrollBar jScrollBar, int n, boolean bl) {
            if (n == -1 || n == 1) {
                int n2 = bl ? (n == -1 ? -1 * jScrollBar.getBlockIncrement(-1) : jScrollBar.getBlockIncrement(1)) : (n == -1 ? -1 * jScrollBar.getUnitIncrement(-1) : jScrollBar.getUnitIncrement(1));
                jScrollBar.setValue(jScrollBar.getValue() + n2);
            } else if (n == 2) {
                jScrollBar.setValue(jScrollBar.getMinimum());
            } else if (n == 3) {
                jScrollBar.setValue(jScrollBar.getMaximum());
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicScrollBarUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    protected class ScrollListener
    implements ActionListener {
        int direction = 1;
        boolean useBlockIncrement;

        public ScrollListener() {
            this.direction = 1;
            this.useBlockIncrement = false;
        }

        public ScrollListener(int n, boolean bl) {
            this.direction = n;
            this.useBlockIncrement = bl;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.useBlockIncrement = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                BasicScrollBarUI.this.scrollByBlock(this.direction);
                if (BasicScrollBarUI.this.scrollbar.getOrientation() == 1) {
                    if (this.direction > 0) {
                        if (BasicScrollBarUI.this.getThumbBounds().y + BasicScrollBarUI.this.getThumbBounds().height >= BasicScrollBarUI.this.trackListener.currentMouseY) {
                            ((Timer)actionEvent.getSource()).stop();
                        }
                    } else if (BasicScrollBarUI.this.getThumbBounds().y <= BasicScrollBarUI.this.trackListener.currentMouseY) {
                        ((Timer)actionEvent.getSource()).stop();
                    }
                } else if (this.direction > 0 && !BasicScrollBarUI.this.isMouseAfterThumb() || this.direction < 0 && !BasicScrollBarUI.this.isMouseBeforeThumb()) {
                    ((Timer)actionEvent.getSource()).stop();
                }
            } else {
                BasicScrollBarUI.this.scrollByUnit(this.direction);
            }
            if (this.direction > 0 && BasicScrollBarUI.this.scrollbar.getValue() + BasicScrollBarUI.this.scrollbar.getVisibleAmount() >= BasicScrollBarUI.this.scrollbar.getMaximum()) {
                ((Timer)actionEvent.getSource()).stop();
            } else if (this.direction < 0 && BasicScrollBarUI.this.scrollbar.getValue() <= BasicScrollBarUI.this.scrollbar.getMinimum()) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    protected class ArrowButtonListener
    extends MouseAdapter {
        boolean handledEvent;

        protected ArrowButtonListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = mouseEvent.getSource() == BasicScrollBarUI.this.incrButton ? 1 : -1;
            BasicScrollBarUI.this.scrollByUnit(n);
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollListener.setDirection(n);
            BasicScrollBarUI.this.scrollListener.setScrollByBlock(false);
            BasicScrollBarUI.this.scrollTimer.start();
            this.handledEvent = true;
            if (!BasicScrollBarUI.this.scrollbar.hasFocus() && BasicScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                BasicScrollBarUI.this.scrollbar.requestFocus();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicScrollBarUI.this.scrollTimer.stop();
            this.handledEvent = false;
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        private transient int direction = 1;

        protected TrackListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicScrollBarUI.this.isDragging) {
                BasicScrollBarUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) || !BasicScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            Rectangle rectangle = BasicScrollBarUI.this.getTrackBounds();
            BasicScrollBarUI.this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            BasicScrollBarUI.this.trackHighlight = 0;
            BasicScrollBarUI.this.isDragging = false;
            this.offset = 0;
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.useCachedValue = true;
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || !BasicScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!BasicScrollBarUI.this.scrollbar.hasFocus() && BasicScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                BasicScrollBarUI.this.scrollbar.requestFocus();
            }
            BasicScrollBarUI.this.useCachedValue = true;
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (BasicScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (BasicScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - BasicScrollBarUI.this.getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - BasicScrollBarUI.this.getThumbBounds().x;
                    }
                }
                BasicScrollBarUI.this.isDragging = true;
                return;
            }
            if (BasicScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                switch (BasicScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = BasicScrollBarUI.this.getThumbBounds().height / 2;
                        break;
                    }
                    case 0: {
                        this.offset = BasicScrollBarUI.this.getThumbBounds().width / 2;
                    }
                }
                BasicScrollBarUI.this.isDragging = true;
                this.setValueFrom(mouseEvent);
                return;
            }
            BasicScrollBarUI.this.isDragging = false;
            Dimension dimension = BasicScrollBarUI.this.scrollbar.getSize();
            this.direction = 1;
            switch (BasicScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (BasicScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int n = dimension.height / 2;
                        this.direction = this.currentMouseY < n ? -1 : 1;
                        break;
                    }
                    int n = BasicScrollBarUI.this.getThumbBounds().y;
                    this.direction = this.currentMouseY < n ? -1 : 1;
                    break;
                }
                case 0: {
                    if (BasicScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int n = dimension.width / 2;
                        this.direction = this.currentMouseX < n ? -1 : 1;
                    } else {
                        int n = BasicScrollBarUI.this.getThumbBounds().x;
                        int n2 = this.direction = this.currentMouseX < n ? -1 : 1;
                    }
                    if (BasicScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) break;
                    this.direction = -this.direction;
                }
            }
            BasicScrollBarUI.this.scrollByBlock(this.direction);
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollListener.setDirection(this.direction);
            BasicScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || !BasicScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicScrollBarUI.this.scrollbar.isEnabled() || BasicScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            if (BasicScrollBarUI.this.isDragging) {
                this.setValueFrom(mouseEvent);
            } else {
                this.currentMouseX = mouseEvent.getX();
                this.currentMouseY = mouseEvent.getY();
                BasicScrollBarUI.this.updateThumbState(this.currentMouseX, this.currentMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        private void setValueFrom(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3;
            boolean bl = BasicScrollBarUI.this.isThumbRollover();
            BoundedRangeModel boundedRangeModel = BasicScrollBarUI.this.scrollbar.getModel();
            Rectangle rectangle = BasicScrollBarUI.this.getThumbBounds();
            if (BasicScrollBarUI.this.scrollbar.getOrientation() == 1) {
                n3 = BasicScrollBarUI.this.decrButton.getY() + BasicScrollBarUI.this.decrButton.getHeight();
                n2 = BasicScrollBarUI.this.incrButton.getY() - rectangle.height;
                n = Math.min(n2, Math.max(n3, mouseEvent.getY() - this.offset));
                BasicScrollBarUI.this.setThumbBounds(rectangle.x, n, rectangle.width, rectangle.height);
                float f = BasicScrollBarUI.this.getTrackBounds().height;
            } else {
                if (BasicScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    n3 = BasicScrollBarUI.this.decrButton.getX() + BasicScrollBarUI.this.decrButton.getWidth();
                    n2 = BasicScrollBarUI.this.incrButton.getX() - rectangle.width;
                } else {
                    n3 = BasicScrollBarUI.this.incrButton.getX() + BasicScrollBarUI.this.incrButton.getWidth();
                    n2 = BasicScrollBarUI.this.decrButton.getX() - rectangle.width;
                }
                n = Math.min(n2, Math.max(n3, mouseEvent.getX() - this.offset));
                BasicScrollBarUI.this.setThumbBounds(n, rectangle.y, rectangle.width, rectangle.height);
                float f = BasicScrollBarUI.this.getTrackBounds().width;
            }
            if (n == n2) {
                if (BasicScrollBarUI.this.scrollbar.getOrientation() == 1 || BasicScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    BasicScrollBarUI.this.scrollbar.setValue(boundedRangeModel.getMaximum() - boundedRangeModel.getExtent());
                } else {
                    BasicScrollBarUI.this.scrollbar.setValue(boundedRangeModel.getMinimum());
                }
            } else {
                float f = boundedRangeModel.getMaximum() - boundedRangeModel.getExtent();
                float f2 = f - (float)boundedRangeModel.getMinimum();
                float f3 = n - n3;
                float f4 = n2 - n3;
                int n4 = BasicScrollBarUI.this.scrollbar.getOrientation() == 1 || BasicScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(f3 / f4 * f2)) : (int)(0.5 + (double)((float)(n2 - n) / f4 * f2));
                BasicScrollBarUI.this.useCachedValue = true;
                BasicScrollBarUI.this.scrollBarValue = n4 + boundedRangeModel.getMinimum();
                BasicScrollBarUI.this.scrollbar.setValue(this.adjustValueIfNecessary(BasicScrollBarUI.this.scrollBarValue));
            }
            BasicScrollBarUI.this.setThumbRollover(bl);
        }

        private int adjustValueIfNecessary(int n) {
            JList jList;
            JScrollPane jScrollPane;
            JViewport jViewport;
            Component component;
            if (BasicScrollBarUI.this.scrollbar.getParent() instanceof JScrollPane && (component = (jViewport = (jScrollPane = (JScrollPane)BasicScrollBarUI.this.scrollbar.getParent()).getViewport()).getView()) instanceof JList && DefaultLookup.getBoolean(jList = (JList)component, jList.getUI(), "List.lockToPositionOnScroll", false)) {
                int n2;
                Rectangle rectangle;
                int n3 = n;
                int n4 = jList.getLayoutOrientation();
                int n5 = BasicScrollBarUI.this.scrollbar.getOrientation();
                if (n5 == 1 && n4 == 0 && (rectangle = jList.getCellBounds(n2 = jList.locationToIndex(new Point(0, n)), n2)) != null) {
                    n3 = rectangle.y;
                }
                if (n5 == 0 && (n4 == 1 || n4 == 2)) {
                    if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                        n2 = jList.locationToIndex(new Point(n, 0));
                        rectangle = jList.getCellBounds(n2, n2);
                        if (rectangle != null) {
                            n3 = rectangle.x;
                        }
                    } else {
                        Point point = new Point(n, 0);
                        int n6 = jViewport.getExtentSize().width;
                        point.x += n6 - 1;
                        int n7 = jList.locationToIndex(point);
                        Rectangle rectangle2 = jList.getCellBounds(n7, n7);
                        if (rectangle2 != null) {
                            n3 = rectangle2.x + rectangle2.width - n6;
                        }
                    }
                }
                n = n3;
            }
            return n;
        }

        private void startScrollTimerIfNecessary() {
            if (BasicScrollBarUI.this.scrollTimer.isRunning()) {
                return;
            }
            Rectangle rectangle = BasicScrollBarUI.this.getThumbBounds();
            switch (BasicScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (this.direction > 0) {
                        if (rectangle.y + rectangle.height >= BasicScrollBarUI.this.trackListener.currentMouseY) break;
                        BasicScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (rectangle.y <= BasicScrollBarUI.this.trackListener.currentMouseY) break;
                    BasicScrollBarUI.this.scrollTimer.start();
                    break;
                }
                case 0: {
                    if ((this.direction <= 0 || !BasicScrollBarUI.this.isMouseAfterThumb()) && (this.direction >= 0 || !BasicScrollBarUI.this.isMouseBeforeThumb())) break;
                    BasicScrollBarUI.this.scrollTimer.start();
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!BasicScrollBarUI.this.isDragging) {
                BasicScrollBarUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!BasicScrollBarUI.this.isDragging) {
                BasicScrollBarUI.this.setThumbRollover(false);
            }
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!BasicScrollBarUI.this.useCachedValue) {
                BasicScrollBarUI.this.scrollBarValue = BasicScrollBarUI.this.scrollbar.getValue();
            }
            BasicScrollBarUI.this.layoutContainer(BasicScrollBarUI.this.scrollbar);
            BasicScrollBarUI.this.useCachedValue = false;
        }
    }
}

