/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionPropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;

public class JTextField
extends JTextComponent
implements SwingConstants {
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;
    public static final String notifyAction = "notify-field-accept";
    private BoundedRangeModel visibility;
    private int horizontalAlignment = 10;
    private int columns;
    private int columnWidth;
    private String command;
    private static final Action[] defaultActions = new Action[]{new NotifyAction()};
    private static final String uiClassID = "TextFieldUI";

    public JTextField() {
        this(null, null, 0);
    }

    public JTextField(String string) {
        this(null, string, 0);
    }

    public JTextField(int n) {
        this(null, null, n);
    }

    public JTextField(String string, int n) {
        this(null, string, n);
    }

    public JTextField(Document document, String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        this.visibility = new DefaultBoundedRangeModel();
        this.visibility.addChangeListener(new ScrollRepainter());
        this.columns = n;
        if (document == null) {
            document = this.createDefaultModel();
        }
        this.setDocument(document);
        if (string != null) {
            this.setText(string);
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setDocument(Document document) {
        if (document != null) {
            document.putProperty("filterNewlines", Boolean.TRUE);
        }
        super.setDocument(document);
    }

    public boolean isValidateRoot() {
        Container container = this.getParent();
        return !(container instanceof JViewport);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.horizontalAlignment) {
            return;
        }
        int n2 = this.horizontalAlignment;
        if (n != 2 && n != 0 && n != 4 && n != 10 && n != 11) {
            throw new IllegalArgumentException("horizontalAlignment");
        }
        this.horizontalAlignment = n;
        this.firePropertyChange("horizontalAlignment", n2, this.horizontalAlignment);
        this.invalidate();
        this.repaint();
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        int n2 = this.columns;
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n != n2) {
            this.columns = n;
            this.invalidate();
        }
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.columnWidth = fontMetrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.columns != 0) {
            Insets insets = this.getInsets();
            dimension.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        return dimension;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.columnWidth = 0;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener != null && this.getAction() == actionListener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(ActionListener.class, actionListener);
        }
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n = ((ActionEvent)aWTEvent).getModifiers();
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.command != null ? this.command : this.getText(), EventQueue.getMostRecentEventTime(), n);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(ActionListener.class, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
        }
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl = false;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != clazz || objectArray[i + 1] != actionListener) continue;
            bl = true;
        }
        return bl;
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action action) {
        AbstractAction.setEnabledFromAction(this, action);
        AbstractAction.setToolTipTextFromAction(this, action);
        this.setActionCommandFromAction(action);
    }

    protected void actionPropertyChanged(Action action, String string) {
        if (string == "ActionCommandKey") {
            this.setActionCommandFromAction(action);
        } else if (string == "enabled") {
            AbstractAction.setEnabledFromAction(this, action);
        } else if (string == "ShortDescription") {
            AbstractAction.setToolTipTextFromAction(this, action);
        }
    }

    private void setActionCommandFromAction(Action action) {
        this.setActionCommand(action == null ? null : (String)action.getValue("ActionCommandKey"));
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new TextFieldActionPropertyChangeListener(this, action);
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public void postActionEvent() {
        this.fireActionPerformed();
    }

    public BoundedRangeModel getHorizontalVisibility() {
        return this.visibility;
    }

    public int getScrollOffset() {
        return this.visibility.getValue();
    }

    public void setScrollOffset(int n) {
        this.visibility.setValue(n);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Insets insets = this.getInsets();
        int n = rectangle.x + this.visibility.getValue() - insets.left;
        int n2 = n + rectangle.width;
        if (n < this.visibility.getValue()) {
            this.visibility.setValue(n);
        } else if (n2 > this.visibility.getValue() + this.visibility.getExtent()) {
            this.visibility.setValue(n2 - this.visibility.getExtent());
        }
    }

    boolean hasActionListener() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string = this.horizontalAlignment == 2 ? "LEFT" : (this.horizontalAlignment == 0 ? "CENTER" : (this.horizontalAlignment == 4 ? "RIGHT" : (this.horizontalAlignment == 10 ? "LEADING" : (this.horizontalAlignment == 11 ? "TRAILING" : ""))));
        String string2 = this.command != null ? this.command : "";
        return super.paramString() + ",columns=" + this.columns + ",columnWidth=" + this.columnWidth + ",command=" + string2 + ",horizontalAlignment=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextField();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTextField
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJTextField() {
            super(JTextField.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }
    }

    class ScrollRepainter
    implements ChangeListener,
    Serializable {
        ScrollRepainter() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTextField.this.repaint();
        }
    }

    static class NotifyAction
    extends TextAction {
        NotifyAction() {
            super(JTextField.notifyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jTextComponent;
                jTextField.postActionEvent();
            }
        }

        public boolean isEnabled() {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JTextField) {
                return ((JTextField)jTextComponent).hasActionListener();
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextFieldActionPropertyChangeListener
    extends ActionPropertyChangeListener<JTextField> {
        TextFieldActionPropertyChangeListener(JTextField jTextField, Action action) {
            super(jTextField, action);
        }

        @Override
        protected void actionPropertyChanged(JTextField jTextField, Action action, PropertyChangeEvent propertyChangeEvent) {
            if (AbstractAction.shouldReconfigure(propertyChangeEvent)) {
                jTextField.configurePropertiesFromAction(action);
            } else {
                jTextField.actionPropertyChanged(action, propertyChangeEvent.getPropertyName());
            }
        }
    }
}

