/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicLong
extends Number
implements Serializable {
    private static final long serialVersionUID = 1927816293512124184L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    static final boolean VM_SUPPORTS_LONG_CAS;
    private long value;

    private static native boolean VMSupportsCS8();

    public AtomicLong(long l) {
        this.value = l;
    }

    public AtomicLong() {
    }

    public final synchronized long get() {
        return this.value;
    }

    public final synchronized void set(long l) {
        this.value = l;
    }

    public final synchronized void lazySet(long l) {
        this.value = l;
    }

    public final synchronized long getAndSet(long l) {
        long l2 = this.value;
        this.value = l;
        return l2;
    }

    public final synchronized boolean compareAndSet(long l, long l2) {
        if (this.value == l) {
            this.value = l2;
            return true;
        }
        return false;
    }

    public final boolean weakCompareAndSet(long l, long l2) {
        return this.compareAndSet(l, l2);
    }

    public final synchronized long getAndIncrement() {
        long l = this.value++;
        return l;
    }

    public final synchronized long getAndDecrement() {
        long l = this.value--;
        return l;
    }

    public final synchronized long getAndAdd(long l) {
        long l2 = this.value;
        this.value += l;
        return l2;
    }

    public final synchronized long incrementAndGet() {
        ++this.value;
        return this.value;
    }

    public final synchronized long decrementAndGet() {
        --this.value;
        return this.value;
    }

    public final synchronized long addAndGet(long l) {
        this.value += l;
        return this.value;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    public int intValue() {
        return (int)this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    static {
        VM_SUPPORTS_LONG_CAS = AtomicLong.VMSupportsCS8();
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicLong.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

