/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicBoolean
implements Serializable {
    private static final long serialVersionUID = 4654671469794556979L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    private volatile int value;

    public AtomicBoolean(boolean bl) {
        this.value = bl ? 1 : 0;
    }

    public AtomicBoolean() {
    }

    public final boolean get() {
        return this.value != 0;
    }

    public final boolean compareAndSet(boolean bl, boolean bl2) {
        int n = bl ? 1 : 0;
        int n2 = bl2 ? 1 : 0;
        return unsafe.compareAndSwapInt(this, valueOffset, n, n2);
    }

    public boolean weakCompareAndSet(boolean bl, boolean bl2) {
        int n = bl ? 1 : 0;
        int n2 = bl2 ? 1 : 0;
        return unsafe.compareAndSwapInt(this, valueOffset, n, n2);
    }

    public final void set(boolean bl) {
        this.value = bl ? 1 : 0;
    }

    public final void lazySet(boolean bl) {
        int n = bl ? 1 : 0;
        unsafe.putIntVolatile(this, valueOffset, n);
    }

    public final boolean getAndSet(boolean bl) {
        boolean bl2;
        while (!this.compareAndSet(bl2 = this.get(), bl)) {
        }
        return bl2;
    }

    public String toString() {
        return Boolean.toString(this.get());
    }

    static {
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicBoolean.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

