/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CyclicBarrier {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition trip = this.lock.newCondition();
    private final int parties;
    private final Runnable barrierCommand;
    private Generation generation = new Generation();
    private int count;

    private void nextGeneration() {
        this.trip.signalAll();
        this.count = this.parties;
        this.generation = new Generation();
    }

    private void breakBarrier() {
        this.generation.broken = true;
        this.count = this.parties;
        this.trip.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int dowait(boolean bl, long l) throws InterruptedException, BrokenBarrierException, TimeoutException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            Generation generation = this.generation;
            if (generation.broken) {
                throw new BrokenBarrierException();
            }
            if (Thread.interrupted()) {
                this.breakBarrier();
                throw new InterruptedException();
            }
            if ((n = --this.count) == 0) {
                int n2;
                boolean bl2 = false;
                try {
                    Runnable runnable = this.barrierCommand;
                    if (runnable != null) {
                        runnable.run();
                    }
                    bl2 = true;
                    this.nextGeneration();
                    n2 = 0;
                    Object var11_11 = null;
                    if (!bl2) {
                        this.breakBarrier();
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (bl2) throw throwable;
                    this.breakBarrier();
                    throw throwable;
                }
                Object var13_13 = null;
                reentrantLock.unlock();
                return n2;
            }
            do {
                block16: {
                    try {
                        if (!bl) {
                            this.trip.await();
                            break block16;
                        }
                        if (l > 0L) {
                            l = this.trip.awaitNanos(l);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (generation == this.generation && !generation.broken) {
                            this.breakBarrier();
                            throw interruptedException;
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                if (generation.broken) {
                    throw new BrokenBarrierException();
                }
                if (generation == this.generation) continue;
                int n3 = n;
                Object var13_14 = null;
                reentrantLock.unlock();
                return n3;
            } while (!bl || l > 0L);
            this.breakBarrier();
            throw new TimeoutException();
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    public CyclicBarrier(int n, Runnable runnable) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties = n;
        this.count = n;
        this.barrierCommand = runnable;
    }

    public CyclicBarrier(int n) {
        this(n, null);
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            return this.dowait(false, 0L);
        }
        catch (TimeoutException timeoutException) {
            throw new Error(timeoutException);
        }
    }

    public int await(long l, TimeUnit timeUnit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        return this.dowait(true, timeUnit.toNanos(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroken() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.generation.broken;
            Object var4_3 = null;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.breakBarrier();
            this.nextGeneration();
            Object var3_2 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberWaiting() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.parties - this.count;
            Object var4_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    private static class Generation {
        boolean broken = false;

        private Generation() {
        }
    }
}

