/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.Converters;
import sun.io.MalformedInputException;
import sun.misc.MessageUtils;
import sun.nio.cs.HistoricallyNamedCharset;

class StringCoding {
    private static ThreadLocal decoder = new ThreadLocal();
    private static ThreadLocal encoder = new ThreadLocal();

    private StringCoding() {
    }

    private static Object getDecoder(String string) throws UnsupportedEncodingException {
        DecoderCache decoderCache = (DecoderCache)decoder.get();
        if (decoderCache == null) {
            decoderCache = (DecoderCache)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new DecoderCache();
                }
            });
            decoder.set(decoderCache);
        }
        return decoderCache.getDecoder(string);
    }

    private static Object getEncoder(String string) throws UnsupportedEncodingException {
        EncoderCache encoderCache = (EncoderCache)encoder.get();
        if (encoderCache == null) {
            encoderCache = (EncoderCache)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new EncoderCache();
                }
            });
            encoder.set(encoderCache);
        }
        return encoderCache.getEncoder(string);
    }

    private static byte[] trim(byte[] byArray, int n) {
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static char[] trim(char[] cArray, int n) {
        if (n == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    private static void warnUnsupportedCharset(String string, Object object) {
        String string2;
        int n;
        if (object == null) {
            MessageUtils.err("Error: The encoding ISO-8859-1 is not available.");
            System.exit(1);
        }
        if ((n = (string2 = object.toString()).indexOf(": ")) >= 0) {
            string2 = string2.substring(n + 2);
        }
        Converters.setDefaultEncodingName(string2);
        MessageUtils.err("[ Warning: The encoding '" + string + "' is not supported; using '" + string2 + "' instead. ]");
    }

    static char[] decode(String string, byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        Object object = StringCoding.getDecoder(string);
        if (object instanceof ByteToCharConverter) {
            ByteToCharConverter byteToCharConverter = (ByteToCharConverter)object;
            int n3 = byteToCharConverter.getMaxCharsPerByte() * n2;
            char[] cArray = new char[n3];
            if (n2 == 0) {
                return cArray;
            }
            byteToCharConverter.reset();
            int n4 = 0;
            int n5 = n + n2;
            while (true) {
                try {
                    n4 += byteToCharConverter.convert(byArray, n, n5, cArray, n4, n3);
                }
                catch (MalformedInputException malformedInputException) {
                    int n6 = byteToCharConverter.nextByteIndex() + byteToCharConverter.getBadInputLength();
                    if (n6 <= n) break;
                    n = n6;
                    n4 = byteToCharConverter.nextCharIndex();
                    continue;
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
                break;
            }
            try {
                n4 += byteToCharConverter.flush(cArray, byteToCharConverter.nextCharIndex(), n3);
            }
            catch (MalformedInputException malformedInputException) {
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
            return StringCoding.trim(cArray, n4);
        }
        CharsetDecoder charsetDecoder = (CharsetDecoder)object;
        int n7 = (int)(charsetDecoder.maxCharsPerByte() * (float)n2);
        char[] cArray = new char[n7];
        if (n2 == 0) {
            return cArray;
        }
        charsetDecoder.reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
        coderResult = charsetDecoder.flush(charBuffer);
        return StringCoding.trim(cArray, charBuffer.position());
    }

    static char[] decode(byte[] byArray, int n, int n2) {
        try {
            return StringCoding.decode("\ufffc", byArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    static byte[] encode(String string, char[] cArray, int n, int n2) throws UnsupportedEncodingException {
        Object object = StringCoding.getEncoder(string);
        if (object instanceof CharToByteConverter) {
            CharToByteConverter charToByteConverter = (CharToByteConverter)object;
            int n3 = charToByteConverter.getMaxBytesPerChar() * n2;
            byte[] byArray = new byte[n3];
            if (n2 == 0) {
                return byArray;
            }
            charToByteConverter.reset();
            int n4 = 0;
            int n5 = n + n2;
            while (true) {
                try {
                    n4 += charToByteConverter.convert(cArray, n, n5, byArray, n4, n3);
                }
                catch (MalformedInputException malformedInputException) {
                    int n6 = charToByteConverter.nextCharIndex() + charToByteConverter.getBadInputLength();
                    if (n6 <= n) break;
                    n = n6;
                    n4 = charToByteConverter.nextByteIndex();
                    continue;
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
                break;
            }
            try {
                n4 += charToByteConverter.flush(byArray, charToByteConverter.nextByteIndex(), n3);
            }
            catch (MalformedInputException malformedInputException) {
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
            return StringCoding.trim(byArray, n4);
        }
        CharsetEncoder charsetEncoder = (CharsetEncoder)object;
        int n7 = (int)(charsetEncoder.maxBytesPerChar() * (float)n2);
        byte[] byArray = new byte[n7];
        if (n2 == 0) {
            return byArray;
        }
        charsetEncoder.reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
        coderResult = charsetEncoder.flush(byteBuffer);
        return StringCoding.trim(byArray, byteBuffer.position());
    }

    static byte[] encode(char[] cArray, int n, int n2) {
        try {
            return StringCoding.encode("\ufffc", cArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static byte[] safeTrim(byte[] byArray, int n, Charset charset) {
        if (n == byArray.length && (System.getSecurityManager() == null || charset.getClass().getClassLoaderImpl() == ClassLoader.systemClassLoader)) {
            return byArray;
        }
        return Arrays.copyOf(byArray, n);
    }

    private static char[] safeTrim(char[] cArray, int n, Charset charset) {
        if (n == cArray.length && (System.getSecurityManager() == null || charset.getClass().getClassLoaderImpl() == ClassLoader.systemClassLoader)) {
            return cArray;
        }
        return Arrays.copyOf(cArray, n);
    }

    private static int scale(int n, float f) {
        return (int)((double)n * (double)f);
    }

    static char[] decode(Charset charset, byte[] byArray, int n, int n2) {
        StringDecoder stringDecoder = new StringDecoder(charset, charset.name());
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        return stringDecoder.decode(byArray2, n, n2);
    }

    static byte[] encode(Charset charset, char[] cArray, int n, int n2) {
        StringEncoder stringEncoder = new StringEncoder(charset, charset.name());
        char[] cArray2 = Arrays.copyOf(cArray, cArray.length);
        return stringEncoder.encode(cArray2, n, n2);
    }

    private static class StringEncoder {
        private Charset cs;
        private CharsetEncoder ce;
        private final String requestedCharsetName;

        private StringEncoder(Charset charset, String string) {
            this.requestedCharsetName = string;
            this.cs = charset;
            this.ce = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.ce.maxBytesPerChar());
            byte[] byArray = new byte[n3];
            if (n2 == 0) {
                return byArray;
            }
            this.ce.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            try {
                CoderResult coderResult = this.ce.encode(charBuffer, byteBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.ce.flush(byteBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.safeTrim(byArray, byteBuffer.position(), this.cs);
        }
    }

    private static class StringDecoder {
        private final String requestedCharsetName;
        private final Charset cs;
        private final CharsetDecoder cd;

        private StringDecoder(Charset charset, String string) {
            this.requestedCharsetName = string;
            this.cs = charset;
            this.cd = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        char[] decode(byte[] byArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.cd.maxCharsPerByte());
            char[] cArray = new char[n3];
            if (n2 == 0) {
                return cArray;
            }
            this.cd.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            try {
                CoderResult coderResult = this.cd.decode(byteBuffer, charBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.cd.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.safeTrim(cArray, charBuffer.position(), this.cs);
        }
    }

    private static final class EncoderCache {
        private static final int CACHE_SIZE = 6;
        private int max = 0;
        private int reuse = 0;
        private int current = 0;
        private String[] encoding = new String[6];
        private Object[] encoders = new Object[6];

        private EncoderCache() {
        }

        Object makeEncoder(String string) {
            String string2 = string;
            if (string.equals("\ufffc")) {
                string2 = Converters.getDefaultEncodingName();
            }
            try {
                return CharToByteConverter.getConverter(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Charset charset;
                try {
                    charset = Charset.forName(string2);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    Object object = null;
                    if (string.equals("\ufffc")) {
                        String string3 = string2;
                        while (object == null && (string2 = Converters.getFallbackEncoding(string2)) != null) {
                            object = this.makeEncoder(string2);
                        }
                        StringCoding.warnUnsupportedCharset(string3, object);
                    }
                    return object;
                }
                return charset.newEncoder().onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
        }

        Object getEncoder(final String string) throws UnsupportedEncodingException {
            Object t;
            int n;
            if (this.max > 0 && this.encoding[this.current].equals(string)) {
                return this.encoders[this.current];
            }
            for (n = 0; n < this.max; ++n) {
                if (n == this.current || !this.encoding[n].equals(string)) continue;
                this.current = n;
                return this.encoders[n];
            }
            try {
                t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return EncoderCache.this.makeEncoder(string);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (UnsupportedEncodingException)privilegedActionException.getException();
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new UnsupportedEncodingException(string);
            }
            if (t == null) {
                throw new UnsupportedEncodingException(string);
            }
            if (this.max < 6) {
                n = this.max++;
            } else {
                n = this.reuse++;
                if (this.reuse == 6) {
                    this.reuse = 0;
                }
            }
            this.encoders[n] = t;
            this.encoding[n] = string;
            this.current = n;
            return t;
        }
    }

    private static final class DecoderCache {
        private static final int CACHE_SIZE = 6;
        private int max = 0;
        private int reuse = 0;
        private int current = 0;
        private String[] encoding = new String[6];
        private Object[] decoders = new Object[6];

        private DecoderCache() {
        }

        Object makeDecoder(String string) {
            String string2 = string;
            if (string.equals("\ufffc")) {
                string2 = Converters.getDefaultEncodingName();
            }
            try {
                return ByteToCharConverter.getConverter(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Charset charset;
                try {
                    charset = Charset.forName(string2);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    Object object = null;
                    if (string.equals("\ufffc")) {
                        String string3 = string2;
                        while (object == null && (string2 = Converters.getFallbackEncoding(string2)) != null) {
                            object = this.makeDecoder(string2);
                        }
                        StringCoding.warnUnsupportedCharset(string3, object);
                    }
                    return object;
                }
                return charset.newDecoder().onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
        }

        Object getDecoder(final String string) throws UnsupportedEncodingException {
            Object t;
            int n;
            if (this.max > 0 && this.encoding[this.current].equals(string)) {
                return this.decoders[this.current];
            }
            for (n = 0; n < this.max; ++n) {
                if (n == this.current || !this.encoding[n].equals(string)) continue;
                this.current = n;
                return this.decoders[n];
            }
            try {
                t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return DecoderCache.this.makeDecoder(string);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (UnsupportedEncodingException)privilegedActionException.getException();
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new UnsupportedEncodingException(string);
            }
            if (t == null) {
                throw new UnsupportedEncodingException(string);
            }
            if (this.max < 6) {
                n = this.max++;
            } else {
                n = this.reuse++;
                if (this.reuse == 6) {
                    this.reuse = 0;
                }
            }
            this.decoders[n] = t;
            this.encoding[n] = string;
            this.current = n;
            return t;
        }
    }
}

