/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.ibm.security.util.DerValue;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509SKI
extends SignatureElementProxy
implements XMLX509DataContent {
    static Logger log = Logger.getLogger(XMLX509SKI.class.getName());
    public static final String SKI_OID = "2.5.29.14";

    public XMLX509SKI(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public XMLX509SKI(Document document, X509Certificate x509Certificate) throws XMLSecurityException {
        super(document);
        this.addBase64Text(XMLX509SKI.getSKIBytesFromCert(x509Certificate));
    }

    public XMLX509SKI(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public byte[] getSKIBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getSKIBytesFromCert(X509Certificate x509Certificate) throws XMLSecurityException {
        try {
            Object object;
            byte[] byArray = x509Certificate.getExtensionValue(SKI_OID);
            if (x509Certificate.getVersion() < 3) {
                Object[] objectArray = new Object[]{new Integer(x509Certificate.getVersion())};
                throw new XMLSecurityException("certificate.noSki.lowVersion", objectArray);
            }
            byte[] byArray2 = null;
            try {
                object = new DerValue(byArray);
                if (object == null) {
                    throw new XMLSecurityException("certificate.noSki.null");
                }
                if (object.getTag() != 4) {
                    throw new XMLSecurityException("certificate.noSki.notOctetString");
                }
                byArray2 = object.getOctetString();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (byArray2 == null) {
                try {
                    object = Class.forName("org.bouncycastle.asn1.DERInputStream");
                    if (object != null) {
                        Constructor constructor = ((Class)object).getConstructor(InputStream.class);
                        InputStream inputStream = (InputStream)constructor.newInstance(new ByteArrayInputStream(byArray));
                        Method method = ((Class)object).getMethod("readObject", new Class[0]);
                        Object object2 = method.invoke(inputStream, new Object[0]);
                        if (object2 == null) {
                            throw new XMLSecurityException("certificate.noSki.null");
                        }
                        Class<?> clazz = Class.forName("org.bouncycastle.asn1.ASN1OctetString");
                        if (!clazz.isInstance(object2)) {
                            throw new XMLSecurityException("certificate.noSki.notOctetString");
                        }
                        Method method2 = clazz.getMethod("getOctets", new Class[0]);
                        byArray2 = (byte[])method2.invoke(object2, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            object = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, object, 0, ((DerValue)object).length);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Base64 of SKI is " + Base64.encode((byte[])object));
            }
            return object;
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("generic.EmptyMessage", iOException);
        }
    }

    public boolean equals(Object object) {
        if (!object.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509SKI xMLX509SKI = (XMLX509SKI)object;
        try {
            return MessageDigest.isEqual(xMLX509SKI.getSKIBytes(), this.getSKIBytes());
        }
        catch (XMLSecurityException xMLSecurityException) {
            return false;
        }
    }

    public String getBaseLocalName() {
        return "X509SKI";
    }
}

