/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.MBeanServerAccessController;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.security.auth.Subject;

public class MBeanServerFileAccessController
extends MBeanServerAccessController {
    public static final String READONLY = "readonly";
    public static final String READWRITE = "readwrite";
    private Properties props;
    private Properties originalProps;
    private String accessFileName;

    public MBeanServerFileAccessController(String string) throws IOException {
        this.accessFileName = string;
        this.props = MBeanServerFileAccessController.propertiesFromFile(string);
        this.checkValues(this.props);
    }

    public MBeanServerFileAccessController(String string, MBeanServer mBeanServer) throws IOException {
        this(string);
        this.setMBeanServer(mBeanServer);
    }

    public MBeanServerFileAccessController(Properties properties) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("Null properties");
        }
        this.originalProps = properties;
        this.props = (Properties)properties.clone();
        this.checkValues(this.props);
    }

    public MBeanServerFileAccessController(Properties properties, MBeanServer mBeanServer) throws IOException {
        this(properties);
        this.setMBeanServer(mBeanServer);
    }

    public void checkRead() {
        this.checkAccessLevel(READONLY);
    }

    public void checkWrite() {
        this.checkAccessLevel(READWRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IOException {
        Properties properties = this.props;
        synchronized (properties) {
            this.props = this.accessFileName == null ? (Properties)this.originalProps.clone() : MBeanServerFileAccessController.propertiesFromFile(this.accessFileName);
            this.checkValues(this.props);
        }
    }

    private static Properties propertiesFromFile(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        fileInputStream.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAccessLevel(String string) {
        final AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Subject.getSubject(accessControlContext);
            }
        });
        if (subject == null) {
            return;
        }
        Set<Principal> set = subject.getPrincipals();
        for (Principal principal : set) {
            String string2;
            Properties properties = this.props;
            synchronized (properties) {
                string2 = this.props.getProperty(principal.getName());
            }
            if (string2 == null) continue;
            if (string.equals(READONLY) && (string2.equals(READONLY) || string2.equals(READWRITE))) {
                return;
            }
            if (!string.equals(READWRITE) || !string2.equals(READWRITE)) continue;
            return;
        }
        throw new SecurityException("Access denied! Invalid access level for requested MBeanServer operation.");
    }

    private void checkValues(Properties properties) {
        Collection<Object> collection = properties.values();
        for (String string : collection) {
            if (string.equals(READONLY) || string.equals(READWRITE)) continue;
            throw new IllegalArgumentException("Syntax error in access level entry [" + string + "]");
        }
    }
}

