/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.oa.poa;

import com.sun.corba.se.impl.logging.POASystemException;
import com.sun.corba.se.impl.oa.poa.POAFactory;
import com.sun.corba.se.impl.oa.poa.POAImpl;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.spi.protocol.PIHandler;
import java.util.HashSet;
import java.util.Set;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public class POAManagerImpl
extends LocalObject
implements POAManager {
    private final POAFactory factory;
    private PIHandler pihandler;
    private State state;
    private Set poas = new HashSet(4);
    private int nInvocations = 0;
    private int nWaiters = 0;
    private int myId = 0;
    private boolean debug;
    private boolean explicitStateChange;

    private String stateToString(State state) {
        switch (state.value()) {
            case 0: {
                return "State[HOLDING]";
            }
            case 1: {
                return "State[ACTIVE]";
            }
            case 2: {
                return "State[DISCARDING]";
            }
            case 3: {
                return "State[INACTIVE]";
            }
        }
        return "State[UNKNOWN]";
    }

    public String toString() {
        return "POAManagerImpl[myId=" + this.myId + " state=" + this.stateToString(this.state) + " nInvocations=" + this.nInvocations + " nWaiters=" + this.nWaiters + "]";
    }

    POAFactory getFactory() {
        return this.factory;
    }

    PIHandler getPIHandler() {
        return this.pihandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countedWait() {
        try {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Calling countedWait on POAManager " + (Object)((Object)this) + " nWaiters=" + this.nWaiters);
            }
            ++this.nWaiters;
            ((Object)((Object)this)).wait();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            --this.nWaiters;
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting countedWait on POAManager " + (Object)((Object)this) + " nWaiters=" + this.nWaiters);
            }
        }
    }

    private void notifyWaiters() {
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Calling notifyWaiters on POAManager " + (Object)((Object)this) + " nWaiters=" + this.nWaiters);
        }
        if (this.nWaiters > 0) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public int getManagerId() {
        return this.myId;
    }

    POAManagerImpl(POAFactory pOAFactory, PIHandler pIHandler) {
        this.factory = pOAFactory;
        pOAFactory.addPoaManager(this);
        this.pihandler = pIHandler;
        this.myId = pOAFactory.newPOAManagerId();
        this.state = State.HOLDING;
        this.debug = pOAFactory.getORB().poaDebugFlag;
        this.explicitStateChange = false;
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Creating POAManagerImpl " + (Object)((Object)this));
        }
    }

    synchronized void addPOA(POA pOA) {
        if (this.state.value() == 3) {
            POASystemException pOASystemException = this.factory.getWrapper();
            throw pOASystemException.addPoaInactive(CompletionStatus.COMPLETED_NO);
        }
        this.poas.add(pOA);
    }

    synchronized void removePOA(POA pOA) {
        this.poas.remove(pOA);
        if (this.poas.isEmpty()) {
            this.factory.removePoaManager(this);
        }
    }

    public short getORTState() {
        switch (this.state.value()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void activate() throws AdapterInactive {
        this.explicitStateChange = true;
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Calling activate on POAManager " + (Object)((Object)this));
        }
        try {
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.ACTIVE;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting activate on POAManager " + (Object)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void hold_requests(boolean bl) throws AdapterInactive {
        this.explicitStateChange = true;
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Calling hold_requests on POAManager " + (Object)((Object)this));
        }
        try {
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.HOLDING;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
            if (bl) {
                while (this.state.value() == 0 && this.nInvocations > 0) {
                    this.countedWait();
                }
            }
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting hold_requests on POAManager " + (Object)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void discard_requests(boolean bl) throws AdapterInactive {
        this.explicitStateChange = true;
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Calling hold_requests on POAManager " + (Object)((Object)this));
        }
        try {
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.DISCARDING;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
            if (bl) {
                while (this.state.value() == 2 && this.nInvocations > 0) {
                    this.countedWait();
                }
            }
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting hold_requests on POAManager " + (Object)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
        Object object;
        this.explicitStateChange = true;
        try {
            object = this;
            synchronized (object) {
                if (this.debug) {
                    ORBUtility.dprint((Object)this, "Calling deactivate on POAManager " + (Object)((Object)this));
                }
                if (this.state.value() == 3) {
                    throw new AdapterInactive();
                }
                this.state = State.INACTIVE;
                this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
                this.notifyWaiters();
            }
            object = new POAManagerDeactivator(this, bl, this.debug);
            if (bl2) {
                ((POAManagerDeactivator)object).run();
            } else {
                Thread thread = new Thread((Runnable)object);
                thread.start();
            }
        }
        finally {
            object = this;
            synchronized (object) {
                if (this.debug) {
                    ORBUtility.dprint((Object)this, "Exiting deactivate on POAManager " + (Object)((Object)this));
                }
            }
        }
    }

    public State get_state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void checkIfActive() {
        try {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Calling checkIfActive for POAManagerImpl " + (Object)((Object)this));
            }
            this.checkState();
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting checkIfActive for POAManagerImpl " + (Object)((Object)this));
            }
        }
    }

    private void checkState() {
        while (this.state.value() != 1) {
            switch (this.state.value()) {
                case 0: {
                    while (this.state.value() == 0) {
                        this.countedWait();
                    }
                    break;
                }
                case 2: {
                    throw this.factory.getWrapper().poaDiscarding();
                }
                case 3: {
                    throw this.factory.getWrapper().poaInactive();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void enter() {
        try {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Calling enter for POAManagerImpl " + (Object)((Object)this));
            }
            this.checkState();
            ++this.nInvocations;
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting enter for POAManagerImpl " + (Object)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void exit() {
        try {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Calling exit for POAManagerImpl " + (Object)((Object)this));
            }
            --this.nInvocations;
            if (this.nInvocations == 0) {
                this.notifyWaiters();
            }
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting exit for POAManagerImpl " + (Object)((Object)this));
            }
        }
    }

    public synchronized void implicitActivation() {
        if (!this.explicitStateChange) {
            try {
                this.activate();
            }
            catch (AdapterInactive adapterInactive) {
                // empty catch block
            }
        }
    }

    private class POAManagerDeactivator
    implements Runnable {
        private boolean etherealize_objects;
        private POAManagerImpl pmi;
        private boolean debug;

        POAManagerDeactivator(POAManagerImpl pOAManagerImpl2, boolean bl, boolean bl2) {
            this.etherealize_objects = bl;
            this.pmi = pOAManagerImpl2;
            this.debug = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block24: {
                Object object;
                try {
                    object = this.pmi;
                    synchronized (object) {
                        if (this.debug) {
                            ORBUtility.dprint(this, "Calling run with etherealize_objects=" + this.etherealize_objects + " pmi=" + (Object)((Object)this.pmi));
                        }
                        while (this.pmi.nInvocations > 0) {
                            POAManagerImpl.this.countedWait();
                        }
                    }
                    if (!this.etherealize_objects) break block24;
                    object = null;
                    POAManagerImpl pOAManagerImpl = this.pmi;
                    synchronized (pOAManagerImpl) {
                        if (this.debug) {
                            ORBUtility.dprint(this, "run: Preparing to etherealize with pmi=" + (Object)((Object)this.pmi));
                        }
                        object = new HashSet(this.pmi.poas).iterator();
                    }
                    while (object.hasNext()) {
                        ((POAImpl)object.next()).etherealizeAll();
                    }
                    pOAManagerImpl = this.pmi;
                    synchronized (pOAManagerImpl) {
                        if (this.debug) {
                            ORBUtility.dprint(this, "run: removing POAManager and clearing poas with pmi=" + (Object)((Object)this.pmi));
                        }
                        POAManagerImpl.this.factory.removePoaManager(this.pmi);
                        POAManagerImpl.this.poas.clear();
                    }
                }
                finally {
                    if (this.debug) {
                        object = this.pmi;
                        synchronized (object) {
                            ORBUtility.dprint(this, "Exiting run");
                        }
                    }
                }
            }
        }
    }
}

