/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.util.DataChainPolicy;
import com.ibm.jvm.util.DataLink;
import java.io.IOException;
import java.io.OutputStream;

public class DataChain {
    protected DataLink start;
    protected DataLink currentLink;
    protected int dataSize = 0;
    protected DataChainPolicy policy;

    public DataChain() {
        this(new DataChainPolicy());
    }

    public DataChain(DataChainPolicy dataChainPolicy) {
        this.policy = dataChainPolicy;
        this.currentLink = this.start = new DataLink();
    }

    public synchronized void write(byte by) {
        byte[] byArray = new byte[]{by};
        this.write(byArray, 0, 1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = Math.min(n2, this.currentLink.availableToWrite());
            this.currentLink.write(byArray, n, n3);
            this.dataSize += n3;
            n += n3;
            if ((n2 -= n3) <= n3) continue;
            this.currentLink = this.currentLink.getNextWriteableLink(this.policy);
        }
    }

    public synchronized int size() {
        return this.dataSize;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.dataSize];
        int n = 0;
        DataLink dataLink = this.start;
        int n2 = this.dataSize;
        while (n2 > 0) {
            int n3 = Math.min(n2, dataLink.availableToRead());
            System.arraycopy(dataLink.read(), 0, byArray, n, n3);
            n += n3;
            n2 -= n3;
            dataLink = dataLink.getNextLink();
        }
        return byArray;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        DataLink dataLink = this.start;
        int n = this.dataSize;
        while (n > 0) {
            int n2 = Math.min(n, dataLink.availableToRead());
            outputStream.write(dataLink.read(), 0, n2);
            n -= n2;
            dataLink = dataLink.getNextLink();
        }
    }

    public synchronized void reset() {
        DataLink dataLink = this.start;
        do {
            dataLink.reset();
        } while ((dataLink = dataLink.getNextLink()) != this.start);
        this.currentLink = this.start;
        this.dataSize = 0;
        this.policy.reset();
    }

    public synchronized void close() {
        this.dataSize = 0;
        this.start = null;
        this.currentLink = null;
        this.policy.reset();
        this.currentLink = this.start = new DataLink();
    }

    public synchronized void prune() {
        this.currentLink.prune();
        this.start = this.currentLink.getNextLink();
    }
}

