/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.InterruptibleContext;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class InterruptibleIOContext
implements InterruptibleContext {
    private static Method SOCK_getThreadTag = null;
    private static Method SOCK_isBlocked = null;
    private static Method SOCK_interrupt = null;
    private Object[] interruptArgs = null;
    private long NET_tag = InterruptibleIOContext.NET_getThreadTag();

    public InterruptibleIOContext() {
        this.interruptArgs = new Object[]{new Long(this.NET_tag)};
    }

    static long NET_getThreadTag() {
        if (SOCK_getThreadTag == null) {
            InterruptibleIOContext.initRefs();
        }
        try {
            Object[] objectArray = null;
            return (Long)SOCK_getThreadTag.invoke(null, objectArray);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return 0L;
        }
    }

    boolean NET_isBlocked(long l) {
        if (SOCK_isBlocked == null) {
            InterruptibleIOContext.initRefs();
        }
        try {
            return (Boolean)SOCK_isBlocked.invoke(null, this.interruptArgs);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    boolean NET_interrupt(long l) {
        if (SOCK_interrupt == null) {
            InterruptibleIOContext.initRefs();
        }
        try {
            Object[] objectArray = new Object[]{new Long(l)};
            return (Boolean)SOCK_interrupt.invoke(null, this.interruptArgs);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    private static synchronized void initRefs() {
        if (SOCK_getThreadTag == null || SOCK_isBlocked == null || SOCK_interrupt == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> clazz = Class.forName("java.net.SocketUtil");
                        Method method = clazz.getDeclaredMethod("getThreadTag", null);
                        method.setAccessible(true);
                        SOCK_getThreadTag = method;
                        method = clazz.getDeclaredMethod("isBlocked", Long.TYPE);
                        method.setAccessible(true);
                        SOCK_isBlocked = method;
                        method = clazz.getDeclaredMethod("interrupt", Long.TYPE);
                        method.setAccessible(true);
                        SOCK_interrupt = method;
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                    return null;
                }
            });
        }
    }

    public boolean isBlocked() {
        boolean bl = false;
        if (this.NET_tag != 0L && this.NET_isBlocked(this.NET_tag)) {
            bl = true;
        }
        return bl;
    }

    public void unblock() {
        if (this.NET_tag != 0L && this.NET_isBlocked(this.NET_tag)) {
            this.NET_interrupt(this.NET_tag);
        }
    }
}

