/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.jgss.mech.spnego;

import com.ibm.security.jgss.GSSManagerImpl;
import com.ibm.security.jgss.spi.GSSNameSpi;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SPNEGOName
implements GSSNameSpi {
    private Provider provider;
    private String name;
    private Oid nameType;

    public SPNEGOName(String string, Oid oid) throws GSSException {
        this.init(string, oid);
    }

    public SPNEGOName(byte[] byArray, Oid oid) throws GSSException {
        try {
            this.init(new String(byArray, "UTF-8"), oid);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GSSException(11, 0, "Unsupported encoding");
        }
    }

    private void init(String string, Oid oid) throws GSSException {
        this.name = string;
        this.nameType = oid;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public boolean equals(GSSNameSpi gSSNameSpi) throws GSSException {
        if (!(gSSNameSpi instanceof SPNEGOName)) {
            return false;
        }
        if (!this.name.equals(((SPNEGOName)gSSNameSpi).name)) {
            return false;
        }
        return this.nameType.equals(((SPNEGOName)gSSNameSpi).nameType);
    }

    public byte[] export() throws GSSException {
        try {
            return this.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GSSException(11, 0, "Unsupported encoding");
        }
    }

    public Oid getMechanism() {
        return GSSManagerImpl.MECH_TYPE_SPNEGO;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public Oid getStringNameType() {
        return this.nameType;
    }

    public boolean isAnonymousName() {
        return this.nameType == GSSName.NT_ANONYMOUS;
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }
}

