/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.AVAComparator;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RDN
implements DistributionPointName {
    final AVA[] assertion;
    private volatile List<AVA> avaList;
    private volatile String canonicalString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.RDN";

    public RDN(String name) throws IOException {
        this(name, Collections.EMPTY_MAP);
    }

    public RDN(String name, Map<String, String> keywordMap) throws IOException {
        AVA ava;
        String avaString;
        int quoteCount = 0;
        int searchOffset = 0;
        int avaOffset = 0;
        ArrayList<AVA> avaVec = new ArrayList<AVA>(3);
        int nextPlus = name.indexOf(43);
        while (nextPlus >= 0) {
            if (nextPlus > 0 && name.charAt(nextPlus - 1) != '\\' && (quoteCount += X500Name.countQuotes(name, searchOffset, nextPlus)) != 1) {
                avaString = name.substring(avaOffset, nextPlus);
                if (avaString.length() == 0) {
                    throw new IOException("empty AVA in RDN \"" + name + "\"");
                }
                ava = new AVA((Reader)new StringReader(avaString), keywordMap);
                avaVec.add(ava);
                avaOffset = nextPlus + 1;
                quoteCount = 0;
            }
            searchOffset = nextPlus + 1;
            nextPlus = name.indexOf(43, searchOffset);
        }
        avaString = name.substring(avaOffset);
        if (avaString.length() == 0) {
            throw new IOException("empty AVA in RDN \"" + name + "\"");
        }
        ava = new AVA((Reader)new StringReader(avaString), keywordMap);
        avaVec.add(ava);
        this.assertion = avaVec.toArray(new AVA[avaVec.size()]);
    }

    RDN(DerValue set) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RDN", set);
        }
        if (set.getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "RDN", "X500 RDN");
            }
            throw new IOException("X500 RDN");
        }
        DerInputStream deris = new DerInputStream(set.toByteArray());
        DerValue[] ders = deris.getSet(1);
        int j_max = ders.length;
        this.assertion = new AVA[j_max];
        for (int j = 0; j < j_max; ++j) {
            deris = new DerInputStream(ders[j].toByteArray());
            this.assertion[j] = new AVA(deris);
        }
        if (debug != null) {
            debug.exit(16384L, className, "RDN");
        }
    }

    public RDN(AVA[] avas) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RDN", avas);
        }
        this.assertion = new AVA[avas.length];
        for (int i = 0; i < avas.length; ++i) {
            this.assertion[i] = avas[i];
        }
        if (debug != null) {
            debug.exit(16384L, className, "RDN");
        }
    }

    RDN(int i) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RDN", new Integer(i));
        }
        this.assertion = new AVA[i];
        if (debug != null) {
            debug.exit(16384L, className, "RDN");
        }
    }

    List<AVA> avas() {
        List<AVA> list = this.avaList;
        if (list == null) {
            this.avaList = list = Collections.unmodifiableList(Arrays.asList(this.assertion));
        }
        return list;
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other instanceof RDN) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((RDN)other));
            }
            return this.equals((RDN)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    boolean equals(RDN other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (this.assertion.length != other.assertion.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        for (int i = 0; i < this.assertion.length; ++i) {
            if (this.assertion[i].equals(other.assertion[i])) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }

    public int hashCode() {
        return this.toRFC2253String(true).hashCode();
    }

    DerValue findAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "findAttribute", oid);
        }
        for (int i = 0; i < this.assertion.length; ++i) {
            if (!this.assertion[i].oid.equals(oid)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "findAttribute_1", this.assertion[i].value);
            }
            return this.assertion[i].value;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "findAttribute_2", null);
        }
        return null;
    }

    void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        out.putOrderedSetOf((byte)49, this.assertion);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream derout = new DerOutputStream();
        derout.putOrderedSetOf((byte)49, this.assertion);
        out.write(derout.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        String relname = null;
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        for (int i = 0; i < this.assertion.length; ++i) {
            relname = relname == null ? this.assertion[i].toString() : relname + " + " + this.assertion[i];
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", relname);
        }
        return relname;
    }

    public int size() {
        if (debug != null) {
            debug.entry(16384L, className, "size");
            debug.exit(16384L, (Object)className, "size", this.assertion.length);
        }
        return this.assertion.length;
    }

    public AVA getAVA(int index) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAVA", new Integer(index));
            debug.exit(16384L, (Object)className, "getAVA", this.assertion[index]);
        }
        return this.assertion[index];
    }

    public String toRFC1779String() {
        return this.toRFC1779String(Collections.EMPTY_MAP);
    }

    public String toRFC1779String(Map<String, String> oidMap) {
        String relname = null;
        for (int i = 0; i < this.assertion.length; ++i) {
            relname = relname == null ? this.assertion[i].toRFC1779String(oidMap) : relname + " + " + this.assertion[i];
        }
        return relname;
    }

    public String toRFC2253String() {
        return this.toRFC2253StringInternal(false, Collections.EMPTY_MAP);
    }

    public String toRFC2253String(Map<String, String> oidMap) {
        return this.toRFC2253StringInternal(false, oidMap);
    }

    public String toRFC2253String(boolean canonical) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253String(boolean)", new Boolean(canonical));
        }
        if (!canonical) {
            return this.toRFC2253StringInternal(false, Collections.EMPTY_MAP);
        }
        String c = this.canonicalString;
        if (c == null) {
            this.canonicalString = c = this.toRFC2253StringInternal(true, Collections.EMPTY_MAP);
        }
        return c;
    }

    private String toRFC2253StringInternal(boolean canonical, Map<String, String> oidMap) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2254StrInl(boolean)", new Boolean(canonical));
        }
        if (this.assertion.length == 1) {
            return canonical ? this.assertion[0].toRFC2253CanonicalString() : this.assertion[0].toRFC2253String(oidMap);
        }
        StringBuilder relname = new StringBuilder();
        if (!canonical) {
            for (int i = 0; i < this.assertion.length; ++i) {
                if (i > 0) {
                    relname.append('+');
                }
                relname.append(this.assertion[i].toRFC2253String(oidMap));
            }
        } else {
            int i;
            ArrayList<AVA> avaList = new ArrayList<AVA>(this.assertion.length);
            for (i = 0; i < this.assertion.length; ++i) {
                avaList.add(this.assertion[i]);
            }
            Collections.sort(avaList, AVAComparator.getInstance());
            for (i = 0; i < avaList.size(); ++i) {
                if (i > 0) {
                    relname.append('+');
                }
                relname.append(((AVA)avaList.get(i)).toRFC2253CanonicalString());
            }
        }
        return relname.toString();
    }
}

