/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.GeneralNameInterface;
import java.io.IOException;

public final class OIDName
implements GeneralNameInterface {
    private ObjectIdentifier oid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.OIDName";

    public OIDName(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "OIDName", derValue);
        }
        this.oid = derValue.getOID();
        if (debug != null) {
            debug.exit(16384L, className, "OIDName");
        }
    }

    public OIDName(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "OIDName", oid);
            debug.exit(16384L, className, "OIDName");
        }
        this.oid = oid;
    }

    public OIDName(String name) throws IOException {
        try {
            this.oid = new ObjectIdentifier(name);
        }
        catch (Exception e) {
            throw new IOException("Unable to create OIDName: " + e);
        }
    }

    @Override
    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 8);
        }
        return 8;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        out.putOID(this.oid);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "OIDName: " + this.oid.toString());
        }
        return "OIDName: " + this.oid.toString();
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OIDName)) {
            return false;
        }
        OIDName other = (OIDName)obj;
        return this.oid.equals(other.oid);
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 8) {
            constraintType = -1;
        } else if (this.equals((OIDName)inputName)) {
            constraintType = 0;
        } else {
            throw new UnsupportedOperationException("Narrowing and widening are not supported for OIDNames");
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not supported for OIDName.");
    }
}

