/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public final class KeyUsageExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.KeyUsage";
    public static final String NAME = "KeyUsage";
    public static final String DIGITAL_SIGNATURE = "digital_signature";
    public static final String NON_REPUDIATION = "non_repudiation";
    public static final String KEY_ENCIPHERMENT = "key_encipherment";
    public static final String DATA_ENCIPHERMENT = "data_encipherment";
    public static final String KEY_AGREEMENT = "key_agreement";
    public static final String KEY_CERTSIGN = "key_certsign";
    public static final String CRL_SIGN = "crl_sign";
    public static final String ENCIPHER_ONLY = "encipher_only";
    public static final String DECIPHER_ONLY = "decipher_only";
    private boolean[] bitString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.KeyUsageExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        DerOutputStream os = new DerOutputStream();
        os.putNamedBitString(new BitArray(this.bitString));
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis");
        }
    }

    private boolean isSet(int position) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "isSet", new Integer(position));
            debug.exit(8192L, (Object)className, "isSet", this.bitString.length > position ? this.bitString[position] : false);
        }
        return this.bitString.length > position ? this.bitString[position] : false;
    }

    private void set(int position, boolean val) {
        if (debug != null) {
            debug.entry(8192L, className, "set", new Integer(position), new Boolean(val));
        }
        if (position >= this.bitString.length) {
            boolean[] tmp = new boolean[position + 1];
            System.arraycopy(this.bitString, 0, tmp, 0, this.bitString.length);
            this.bitString = tmp;
        }
        this.bitString[position] = val;
        if (debug != null) {
            debug.exit(8192L, className, "set");
        }
    }

    public KeyUsageExtension(byte[] bitString) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyUsageExtension", (Object)bitString);
        }
        this.bitString = new BitArray(bitString.length * 8, bitString).toBooleanArray();
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "KeyUsageExtension");
        }
    }

    public KeyUsageExtension(boolean[] bitString) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyUsageExtension", (Object)bitString);
        }
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        if (bitString != null) {
            this.bitString = (boolean[])bitString.clone();
            this.encodeThis();
        } else {
            this.bitString = bitString;
        }
        if (debug != null) {
            debug.exit(16384L, className, "KeyUsageExtension");
        }
    }

    public KeyUsageExtension(BitArray bitString) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyUsageExtension", bitString);
        }
        this.bitString = bitString.toBooleanArray();
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "KeyUsageExtension");
        }
    }

    public KeyUsageExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "KeyUsageExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "KeyUsageExtension", "Illegal argument type");
            }
            throw new IOException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue[0] == 4 ? new DerValue(extValue).getOctetString() : extValue;
        DerValue val = new DerValue(this.extensionValue);
        this.bitString = val.getUnalignedBitString().toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "KeyUsageExtension");
        }
    }

    public KeyUsageExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "KeyUsageExtension");
        }
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.bitString = new boolean[0];
        if (debug != null) {
            debug.exit(16384L, className, "KeyUsageExtension");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof Boolean)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Boolean.");
            }
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean val = (Boolean)obj;
        if (name.equalsIgnoreCase(DIGITAL_SIGNATURE)) {
            this.set(0, val);
        } else if (name.equalsIgnoreCase(NON_REPUDIATION)) {
            this.set(1, val);
        } else if (name.equalsIgnoreCase(KEY_ENCIPHERMENT)) {
            this.set(2, val);
        } else if (name.equalsIgnoreCase(DATA_ENCIPHERMENT)) {
            this.set(3, val);
        } else if (name.equalsIgnoreCase(KEY_AGREEMENT)) {
            this.set(4, val);
        } else if (name.equalsIgnoreCase(KEY_CERTSIGN)) {
            this.set(5, val);
        } else if (name.equalsIgnoreCase(CRL_SIGN)) {
            this.set(6, val);
        } else if (name.equalsIgnoreCase(ENCIPHER_ONLY)) {
            this.set(7, val);
        } else if (name.equalsIgnoreCase(DECIPHER_ONLY)) {
            this.set(8, val);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:KeyUsage.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:KeyUsage.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(DIGITAL_SIGNATURE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", new Boolean(this.isSet(0)));
            }
            return new Boolean(this.isSet(0));
        }
        if (name.equalsIgnoreCase(NON_REPUDIATION)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Boolean(this.isSet(1)));
            }
            return new Boolean(this.isSet(1));
        }
        if (name.equalsIgnoreCase(KEY_ENCIPHERMENT)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_3", new Boolean(this.isSet(2)));
            }
            return new Boolean(this.isSet(2));
        }
        if (name.equalsIgnoreCase(DATA_ENCIPHERMENT)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_4", new Boolean(this.isSet(3)));
            }
            return new Boolean(this.isSet(3));
        }
        if (name.equalsIgnoreCase(KEY_AGREEMENT)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_5", new Boolean(this.isSet(4)));
            }
            return new Boolean(this.isSet(4));
        }
        if (name.equalsIgnoreCase(KEY_CERTSIGN)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_6", new Boolean(this.isSet(5)));
            }
            return new Boolean(this.isSet(5));
        }
        if (name.equalsIgnoreCase(CRL_SIGN)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_7", new Boolean(this.isSet(6)));
            }
            return new Boolean(this.isSet(6));
        }
        if (name.equalsIgnoreCase(ENCIPHER_ONLY)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_8", new Boolean(this.isSet(7)));
            }
            return new Boolean(this.isSet(7));
        }
        if (name.equalsIgnoreCase(DECIPHER_ONLY)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_9", new Boolean(this.isSet(8)));
            }
            return new Boolean(this.isSet(8));
        }
        if (debug != null) {
            debug.text(16384L, className, "get_10", "Attribute name not recognized by CertAttrSet:KeyUsage.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:KeyUsage.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (name.equalsIgnoreCase(DIGITAL_SIGNATURE)) {
            this.set(0, false);
        } else if (name.equalsIgnoreCase(NON_REPUDIATION)) {
            this.set(1, false);
        } else if (name.equalsIgnoreCase(KEY_ENCIPHERMENT)) {
            this.set(2, false);
        } else if (name.equalsIgnoreCase(DATA_ENCIPHERMENT)) {
            this.set(3, false);
        } else if (name.equalsIgnoreCase(KEY_AGREEMENT)) {
            this.set(4, false);
        } else if (name.equalsIgnoreCase(KEY_CERTSIGN)) {
            this.set(5, false);
        } else if (name.equalsIgnoreCase(CRL_SIGN)) {
            this.set(6, false);
        } else if (name.equalsIgnoreCase(ENCIPHER_ONLY)) {
            this.set(7, false);
        } else if (name.equalsIgnoreCase(DECIPHER_ONLY)) {
            this.set(8, false);
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:KeyUsage.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        String s;
        block13: {
            if (debug != null) {
                debug.entry(16384L, className, "toString");
            }
            s = super.toString() + "KeyUsage [\n";
            try {
                if (this.isSet(0)) {
                    s = s + "  DigitalSignature\n";
                }
                if (this.isSet(1)) {
                    s = s + "  Non_repudiation\n";
                }
                if (this.isSet(2)) {
                    s = s + "  Key_Encipherment\n";
                }
                if (this.isSet(3)) {
                    s = s + "  Data_Encipherment\n";
                }
                if (this.isSet(4)) {
                    s = s + "  Key_Agreement\n";
                }
                if (this.isSet(5)) {
                    s = s + "  Key_CertSign\n";
                }
                if (this.isSet(6)) {
                    s = s + "  Crl_Sign\n";
                }
                if (this.isSet(7)) {
                    s = s + "  Encipher_Only\n";
                }
                if (this.isSet(8)) {
                    s = s + "  Decipher_Only\n";
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                if (debug == null) break block13;
                debug.exception(16384L, className, "toString", ex);
            }
        }
        s = s + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.KeyUsage_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(DIGITAL_SIGNATURE);
        elements.addElement(NON_REPUDIATION);
        elements.addElement(KEY_ENCIPHERMENT);
        elements.addElement(DATA_ENCIPHERMENT);
        elements.addElement(KEY_AGREEMENT);
        elements.addElement(KEY_CERTSIGN);
        elements.addElement(CRL_SIGN);
        elements.addElement(ENCIPHER_ONLY);
        elements.addElement(DECIPHER_ONLY);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    public boolean[] getBits() {
        if (debug != null) {
            debug.entry(16384L, className, "getBits");
            debug.exit(16384L, (Object)className, "getBits", (boolean[])this.bitString.clone());
        }
        return (boolean[])this.bitString.clone();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

