/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateIssuerName;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateSubjectName;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X500Signer;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;

public final class CertAndKeyGen {
    private SecureRandom prng;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertAndKeyGen";

    public CertAndKeyGen(String keyType, String sigAlg) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "CertAndKeyGen", keyType, sigAlg);
        }
        this.keyGen = KeyPairGenerator.getInstance(keyType);
        this.sigAlg = sigAlg;
        if (debug != null) {
            debug.exit(16384L, className, "CertAndKeyGen");
        }
    }

    public CertAndKeyGen(String keyType, String sigAlg, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            Object[] parms = new Object[]{keyType, sigAlg, provider};
            debug.entry(16384L, (Object)className, "CertAndKeyGen", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
            this.keyGen = KeyPairGenerator.getInstance(keyType, provider);
        } else {
            this.keyGen = KeyPairGenerator.getInstance(keyType);
        }
        this.sigAlg = sigAlg;
        if (debug != null) {
            debug.exit(16384L, className, "CertAndKeyGen");
        }
    }

    public void setRandom(SecureRandom generator) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setRandom", generator);
            debug.exit(16384L, className, "setRandom");
        }
        this.prng = generator;
    }

    public void generate(int keyBits) throws InvalidKeyException {
        KeyPair pair;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generate", new Integer(keyBits));
        }
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(keyBits, this.prng);
            pair = this.keyGen.generateKeyPair();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "generate", e);
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
        if (debug != null) {
            debug.exit(16384L, className, "generate");
        }
    }

    public void generate(AlgorithmParameterSpec params) throws InvalidKeyException {
        KeyPair pair;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generate", params);
        }
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(params, this.prng);
            pair = this.keyGen.generateKeyPair();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "generate", e);
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
        if (debug != null) {
            debug.exit(16384L, className, "generate");
        }
    }

    public X509Key getPublicKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getPublicKey");
        }
        if (!(this.publicKey instanceof X509Key)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPublicKey_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPublicKey_2", (X509Key)this.publicKey);
        }
        return (X509Key)this.publicKey;
    }

    public Key newGetPublicKey() {
        if (debug != null) {
            debug.entry(16384L, className, "newGetPublicKey");
            debug.exit(16384L, (Object)className, "newGetPublicKey", this.publicKey);
        }
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getPrivateKey");
            debug.exit(16384L, (Object)className, "getPrivateKey", this.privateKey);
        }
        return this.privateKey;
    }

    public KeyPairGenerator getKeyPairGenerator() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyPairGenerator");
            debug.exit(16384L, (Object)className, "getKeyPairGenerator", this.keyGen);
        }
        return this.keyGen;
    }

    public X509Certificate getSelfCert(X500Name myname, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            if (debug != null) {
                Object[] parms = new Object[]{myname, new Long(validity)};
                debug.entry(16384L, (Object)className, "getSelfCert", parms);
            }
            X500Signer issuer = this.getSigner2(myname);
            Date firstDate = new Date();
            Date lastDate = new Date();
            lastDate.setTime(lastDate.getTime() + validity * 1000L);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.set("version", new CertificateVersion(2));
            info.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
            AlgorithmId algID = issuer.getAlgorithmId();
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", new CertificateSubjectName(myname));
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", new CertificateIssuerName(issuer.getSigner()));
            X509CertImpl cert = new X509CertImpl(info);
            if (this.provider == null) {
                cert.sign(this.privateKey, this.sigAlg);
            } else {
                cert.sign(this.privateKey, this.sigAlg, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSelfCert", cert);
            }
            return cert;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSelfCert", e);
            }
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, className, "getSelfCertificate", myname, new Long(validity));
            debug.exit(16384L, (Object)className, "getSelfCertificate", this.getSelfCertificate(myname, validity, 2));
        }
        return this.getSelfCertificate(myname, validity, 2);
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity, int version) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            if (debug != null) {
                Object[] parms = new Object[]{myname, new Long(validity), new Integer(version)};
                debug.entry(16384L, (Object)className, "getSelfCertificate", parms);
            }
            X500Signer issuer = this.getSigner(myname);
            Date firstDate = new Date();
            Date lastDate = new Date();
            lastDate.setTime(lastDate.getTime() + validity * 1000L);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            if (version != 0 && version != 1 && version != 2) {
                info.set("version", new CertificateVersion(2));
            } else {
                info.set("version", new CertificateVersion(version));
            }
            info.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
            AlgorithmId algID = issuer.getAlgorithmId();
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", new CertificateSubjectName(myname));
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", new CertificateIssuerName(issuer.getSigner()));
            X509CertImpl cert = new X509CertImpl(info);
            if (this.provider == null) {
                cert.sign(this.privateKey, this.sigAlg);
            } else {
                cert.sign(this.privateKey, this.sigAlg, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSelfCertificate", cert);
            }
            return cert;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSelfCertificate", e);
            }
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public CertificationRequest getCertRequest(X500Name myname) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        CertificationRequest req2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCertRequest", myname);
        }
        CertificationRequestInfo cri = new CertificationRequestInfo(myname, this.publicKey, null, this.provider);
        CertificationRequest req = new CertificationRequest(cri, this.provider);
        try {
            req2 = req.sign(this.sigAlg, this.privateKey);
        }
        catch (PKCSException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getCertRequest", e);
            }
            throw new SignatureException(this.sigAlg + " PKCSException");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertRequest", req2);
        }
        return req2;
    }

    private X500Signer getSigner(X500Name me) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        Signature signature = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSigner", me);
        }
        signature = this.provider != null ? Signature.getInstance(this.sigAlg, this.provider) : Signature.getInstance(this.sigAlg);
        signature.initSign(this.privateKey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigner", new X500Signer(signature, me));
        }
        return new X500Signer(signature, me);
    }

    private X500Signer getSigner2(X500Name me) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        Signature signature = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSigner", me);
        }
        signature = this.provider != null ? Signature.getInstance(this.sigAlg, this.provider) : Signature.getInstance(this.sigAlg);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigner", new X500Signer(signature, me));
        }
        return new X500Signer(signature, me);
    }
}

