/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X509AttributeName;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;

public final class CRLExtensions {
    private Hashtable<String, Extension> map = new Hashtable(11);
    private boolean unsupportedCritExt = false;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CRLExtensions";

    public CRLExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "CRLExtensions");
            debug.exit(16384L, className, "CRLExtensions");
        }
    }

    public CRLExtensions(DerInputStream in) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CRLExtensions", in);
        }
        this.init(in);
        if (debug != null) {
            debug.exit(16384L, className, "CRLExtensions");
        }
    }

    private void init(DerInputStream derStrm) throws CRLException {
        try {
            if (debug != null) {
                debug.entry(8192L, (Object)className, "init", derStrm);
            }
            DerInputStream str = derStrm;
            byte nextByte = (byte)derStrm.peekByte();
            if ((nextByte & 0xC0) == 128 && (nextByte & 0x1F) == 0) {
                DerValue val = str.getDerValue();
                str = val.getData();
            }
            DerValue[] exts = str.getSequence(5);
            for (int i = 0; i < exts.length; ++i) {
                Extension ext = new Extension(exts[i]);
                this.parseExtension(ext);
            }
            if (debug != null) {
                debug.exit(8192L, className, "init");
            }
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(8192L, className, "init", e);
            }
            throw new CRLException("Parsing error: " + e.toString());
        }
    }

    private Extension copyExtension(Extension ext) {
        try {
            Class extClass;
            if (debug != null) {
                debug.entry(8192L, (Object)className, "copyExtension", ext);
            }
            if ((extClass = OIDMap.getClass(ext.getExtensionId())) == null) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "copyExtension_1", new Extension(ext));
                }
                return new Extension(ext);
            }
            Class[] params = new Class[]{Boolean.class, Object.class};
            Constructor cons = extClass.getConstructor(params);
            byte[] extData = ext.getExtensionValue();
            int extLen = extData.length;
            Object value = Array.newInstance(Byte.TYPE, extLen);
            for (int i = 0; i < extLen; ++i) {
                Array.setByte(value, i, extData[i]);
            }
            Object[] passed = new Object[]{new Boolean(ext.isCritical()), value};
            if (debug != null) {
                debug.exit(8192L, (Object)className, "copyExtension_2", (CertAttrSet)cons.newInstance(passed));
            }
            return (Extension)cons.newInstance(passed);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "copyExtension", e);
                debug.exit(8192L, (Object)className, "copyExtension_3", null);
            }
            return null;
        }
    }

    private void parseExtension(Extension ext) throws CRLException {
        try {
            Class extClass;
            if (debug != null) {
                debug.entry(8192L, (Object)className, "parseExtension", ext);
            }
            if ((extClass = OIDMap.getClass(ext.getExtensionId())) == null) {
                if (ext.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(ext.getExtensionId().toString(), ext) != null) {
                    if (debug != null) {
                        debug.text(8192L, className, "parseExtension", "Duplicate extensions not allowed");
                    }
                    throw new CRLException("Duplicate extensions not allowed");
                }
                if (debug != null) {
                    debug.exit(8192L, className, "parseExtension_1");
                }
                return;
            }
            Class[] params = new Class[]{Boolean.class, Object.class};
            Constructor cons = extClass.getConstructor(params);
            byte[] extData = ext.getExtensionValue();
            int extLen = extData.length;
            Object value = Array.newInstance(Byte.TYPE, extLen);
            for (int i = 0; i < extLen; ++i) {
                Array.setByte(value, i, extData[i]);
            }
            Object[] passed = new Object[]{new Boolean(ext.isCritical()), value};
            CertAttrSet crlExt = (CertAttrSet)cons.newInstance(passed);
            if (this.map.put(crlExt.getName(), (Extension)((Object)crlExt)) != null) {
                if (debug != null) {
                    debug.text(8192L, className, "parseExtension", "Duplicate extensions not allowed");
                }
                throw new CRLException("Duplicate extensions not allowed");
            }
            if (debug != null) {
                debug.exit(8192L, className, "parseExtension_2");
            }
        }
        catch (InvocationTargetException invk) {
            if (debug != null) {
                debug.exception(8192L, className, "parseExtension", invk);
            }
            throw new CRLException(invk.getTargetException().getMessage());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "parseExtension", e);
            }
            throw new CRLException(e.toString());
        }
    }

    public void encode(OutputStream out, boolean isExplicit) throws CRLException {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "encode", out, new Boolean(isExplicit));
            }
            DerOutputStream extOut = new DerOutputStream();
            Collection<Extension> allExts = this.map.values();
            Object[] objs = allExts.toArray();
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] instanceof CertAttrSet) {
                    ((CertAttrSet)objs[i]).encode(extOut);
                    continue;
                }
                if (objs[i] instanceof Extension) {
                    ((Extension)objs[i]).encode(extOut);
                    continue;
                }
                if (debug != null) {
                    debug.text(16384L, className, "encode", "Illegal extension object");
                }
                throw new CRLException("Illegal extension object");
            }
            DerOutputStream seq = new DerOutputStream();
            seq.write((byte)48, extOut);
            DerOutputStream tmp = new DerOutputStream();
            if (isExplicit) {
                tmp.write(DerValue.createTag((byte)-128, true, (byte)0), seq);
            } else {
                tmp = seq;
            }
            out.write(tmp.toByteArray());
            if (debug != null) {
                debug.exit(16384L, className, "encode");
            }
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e);
            }
            throw new CRLException("Encoding error: " + e.toString());
        }
        catch (CertificateException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e);
            }
            throw new CRLException("Encoding error: " + e.toString());
        }
    }

    public Extension get(String alias) {
        String name;
        X509AttributeName attr;
        String id;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", alias);
        }
        if ((id = (attr = new X509AttributeName(alias)).getPrefix()).equalsIgnoreCase("x509")) {
            int index = alias.lastIndexOf(".");
            name = alias.substring(index + 1);
        } else {
            name = alias;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", this.copyExtension(this.map.get(name)));
        }
        return this.copyExtension(this.map.get(name));
    }

    public void set(String alias, Object obj) {
        this.map.put(alias, (Extension)obj);
    }

    public void delete(String alias) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", alias);
        }
        this.map.remove(alias);
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration<Extension> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        Enumeration<Extension> enumCount = this.map.elements();
        Hashtable<String, Extension> table = new Hashtable<String, Extension>(11);
        while (enumCount.hasMoreElements()) {
            Extension ext = enumCount.nextElement();
            table.put(ext.getExtensionId().toString(), this.copyExtension(ext));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", table.elements());
        }
        return table.elements();
    }

    public Collection<Extension> getAllExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "getAllExtensions");
        }
        ArrayList<Extension> values = Collections.list(this.getElements());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAllExtensions", values);
        }
        return values;
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
            debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", this.unsupportedCritExt);
        }
        return this.unsupportedCritExt;
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (this == other) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof CRLExtensions)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        Collection<Extension> otherC = ((CRLExtensions)other).getAllExtensions();
        Object[] objs = otherC.toArray();
        int len = objs.length;
        if (len != this.map.size()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        String key = null;
        for (int i = 0; i < len; ++i) {
            Extension thisExt;
            if (objs[i] instanceof CertAttrSet) {
                key = ((CertAttrSet)objs[i]).getName();
            }
            Extension otherExt = (Extension)objs[i];
            if (key == null) {
                key = otherExt.getExtensionId().toString();
            }
            if ((thisExt = this.map.get(key)) == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals_4", false);
                }
                return false;
            }
            if (thisExt.equals(otherExt)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_5", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_6", true);
        }
        return true;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
            debug.exit(16384L, (Object)className, "hashCode", this.map.hashCode());
        }
        return this.map.hashCode();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.map.toString());
        }
        return this.map.toString();
    }
}

