/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.GeneralName;
import java.io.IOException;

public class AccessDescription {
    private int myhash = -1;
    protected ObjectIdentifier accessMethod = null;
    protected GeneralName accessLocation = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AccessDescription";
    public static final ObjectIdentifier Ad_OCSP_Id = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1});
    public static final ObjectIdentifier Ad_CAISSUERS_Id = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 2});

    public AccessDescription(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AccessDecription", (Object)der);
        }
        DerInputStream derin = new DerInputStream(der);
        DerValue encoding = derin.getDerValue();
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "AccessDecription");
        }
    }

    public AccessDescription(DerValue derVal) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AccessDescription", derVal);
        }
        DerInputStream in = derVal.toDerInputStream();
        this.accessMethod = in.getOID();
        this.accessLocation = new GeneralName(in.getDerValue());
        if (debug != null) {
            debug.exit(16384L, className, "AccessDescription");
        }
    }

    public AccessDescription(ObjectIdentifier accessMethod, GeneralName accessLocation) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{accessMethod, accessLocation};
            debug.entry(16384L, (Object)className, "AccessDescription", parms);
        }
        this.accessMethod = accessMethod;
        this.accessLocation = accessLocation;
        if (debug != null) {
            debug.exit(16384L, className, "AccessDescription");
        }
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.accessMethod == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Null OID to encode for the AccessDescription!");
            }
            throw new IOException("Null OID to encode for the AccessDescription!");
        }
        if (this.accessLocation == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "No value to encode for the AccessDescription!");
            }
            throw new IOException("No value to encode for the AccessDescription!");
        }
        DerOutputStream dos = new DerOutputStream();
        dos.putOID(this.accessMethod);
        this.accessLocation.encode(dos);
        out.write((byte)48, dos);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid encoding for AccessDescription.");
            }
            throw new IOException("Invalid encoding for AccessDescription.");
        }
        this.accessMethod = encoding.getData().getOID();
        this.accessLocation = new GeneralName(encoding.getData().getDerValue());
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public ObjectIdentifier getAccessMethod() {
        if (debug != null) {
            debug.entry(16384L, className, "getaccessMethod");
            debug.exit(16384L, (Object)className, "getaccessMethod", this.accessMethod);
        }
        return this.accessMethod;
    }

    public GeneralName getAccessLocation() {
        if (debug != null) {
            debug.entry(16384L, className, "getAccessLocation");
        }
        return this.accessLocation;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = "accessMethod: " + this.accessMethod.toString() + "\n";
        s = s + "accessLocation: " + this.accessLocation.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (!(other instanceof AccessDescription)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((AccessDescription)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.accessMethod.hashCode() + this.accessLocation.hashCode();
        }
        return this.myhash;
    }
}

