/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.Collections;
import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleEMTestCase
extends SingleEMFTestCase {
    protected OpenJPAEntityManager em;

    @Override
    public void setUp() {
        this.setUp(new Object[0]);
    }

    @Override
    public void setUp(Object ... props) {
        super.setUp(props);
        this.em = this.emf.createEntityManager();
    }

    protected void reset() {
        this.close();
        this.em = this.emf.createEntityManager();
    }

    @Override
    public void tearDown() throws Exception {
        this.rollback();
        this.close();
        super.tearDown();
    }

    protected boolean begin() {
        OpenJPAEntityTransaction tx = this.em.getTransaction();
        if (tx.isActive()) {
            return false;
        }
        tx.begin();
        return true;
    }

    protected boolean commit() {
        OpenJPAEntityTransaction tx = this.em.getTransaction();
        if (!tx.isActive()) {
            return false;
        }
        tx.commit();
        return true;
    }

    protected boolean rollback() {
        OpenJPAEntityTransaction tx = this.em.getTransaction();
        if (!tx.isActive()) {
            return false;
        }
        tx.rollback();
        return true;
    }

    protected boolean close() {
        if (this.em == null) {
            return false;
        }
        this.rollback();
        if (!this.em.isOpen()) {
            return false;
        }
        this.em.close();
        return !this.em.isOpen();
    }

    protected void remove(Object ... obs) {
        boolean tx = this.begin();
        for (Object ob : obs) {
            this.em.remove(ob);
        }
        if (tx) {
            this.commit();
        }
    }

    protected void persist(Object ... obs) {
        boolean tx = this.begin();
        for (Object ob : obs) {
            this.em.persist(ob);
        }
        if (tx) {
            this.commit();
        }
    }

    protected OpenJPAQuery query(String str) {
        return this.em.createQuery(str);
    }

    protected OpenJPAQuery query(Class c, String str, Object ... params) {
        String query = "select x from " + this.entityName(this.emf, c) + " x " + (str == null ? "" : str);
        OpenJPAQuery q = this.em.createQuery(query);
        for (int i = 0; params != null && i < params.length; ++i) {
            q.setParameter(i + 1, params[i]);
        }
        return q;
    }

    protected <E> List<E> find(Class<E> c, String q, Object ... params) {
        return Collections.checkedList(this.query(c, q, params).getResultList(), c);
    }

    protected <E> List<E> find(Class<E> c) {
        return this.find(c, null, new Object[0]);
    }
}

