/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.lib.jdbc.AbstractJDBCListener;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public abstract class SQLListenerTestCase
extends SingleEMFTestCase {
    protected List<String> sql = new ArrayList<String>();
    protected int sqlCount;

    public void setUp(Object ... props) {
        Object[] copy = new Object[props.length + 2];
        System.arraycopy(props, 0, copy, 0, props.length);
        copy[copy.length - 2] = "openjpa.jdbc.JDBCListeners";
        copy[copy.length - 1] = new JDBCListener[]{new Listener()};
        super.setUp(copy);
    }

    public void assertSQL(String sqlExp) {
        for (String statement : this.sql) {
            if (!statement.matches(sqlExp)) continue;
            return;
        }
        SQLListenerTestCase.fail((String)("Expected regular expression <" + sqlExp + "> to have" + " existed in SQL statements: " + this.sql));
    }

    public void assertNotSQL(String sqlExp) {
        boolean failed = false;
        for (String statement : this.sql) {
            if (!statement.matches(sqlExp)) continue;
            failed = true;
        }
        if (failed) {
            SQLListenerTestCase.fail((String)("Regular expression <" + sqlExp + ">" + " should not have been executed in SQL statements: " + this.sql));
        }
    }

    public void assertContainsSQL(String sqlExp) {
        for (String statement : this.sql) {
            if (!statement.contains(sqlExp)) continue;
            return;
        }
        SQLListenerTestCase.fail((String)("Expected regular expression <" + sqlExp + "> to be" + " contained in SQL statements: " + this.sql));
    }

    public int getSQLCount() {
        return this.sqlCount;
    }

    public int resetSQLCount() {
        int tmp = this.sqlCount;
        this.sqlCount = 0;
        return tmp;
    }

    public void assertSQLCount(String regex, int num) {
        int matches = 0;
        for (String statement : this.sql) {
            if (!statement.matches(regex)) continue;
            ++matches;
        }
        if (matches != num) {
            SQLListenerTestCase.fail((String)("Regular expression <" + regex + "> should have occurred " + num + " time(s) in SQL statements. It was found " + matches + "time(s). SQL recorded :  " + this.sql));
        }
    }

    public class Listener
    extends AbstractJDBCListener {
        public void beforeExecuteStatement(JDBCEvent event) {
            if (event.getSQL() != null && SQLListenerTestCase.this.sql != null) {
                SQLListenerTestCase.this.sql.add(event.getSQL());
                ++SQLListenerTestCase.this.sqlCount;
            }
        }
    }
}

