/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;
import javax.persistence.TemporalType;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.kernel.DelegatingQuery;
import org.apache.openjpa.kernel.DelegatingResultList;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.OpenJPAQuerySPI;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryOperationType;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class QueryImpl
implements OpenJPAQuerySPI,
Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Localizer _loc = Localizer.forPackage(QueryImpl.class);
    private final DelegatingQuery _query;
    private transient EntityManagerImpl _em;
    private transient FetchPlan _fetch;
    private Map _named;
    private List _positional;

    public QueryImpl(EntityManagerImpl em, RuntimeExceptionTranslator ret, Query query) {
        this._em = em;
        this._query = new DelegatingQuery(query, ret);
    }

    public QueryImpl(EntityManagerImpl em, Query query) {
        this(em, null, query);
    }

    public Query getDelegate() {
        return this._query.getDelegate();
    }

    public OpenJPAEntityManager getEntityManager() {
        return this._em;
    }

    public String getLanguage() {
        return this._query.getLanguage();
    }

    public QueryOperationType getOperation() {
        return QueryOperationType.fromKernelConstant(this._query.getOperation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchPlan getFetchPlan() {
        this._em.assertNotCloseInvoked();
        this._query.assertNotSerialized();
        this._query.lock();
        try {
            if (this._fetch == null) {
                this._fetch = ((EntityManagerFactoryImpl)this._em.getEntityManagerFactory()).toFetchPlan(this._query.getBroker(), this._query.getFetchConfiguration());
            }
            FetchPlan fetchPlan = this._fetch;
            return fetchPlan;
        }
        finally {
            this._query.unlock();
        }
    }

    public String getQueryString() {
        return this._query.getQueryString();
    }

    public boolean getIgnoreChanges() {
        return this._query.getIgnoreChanges();
    }

    public OpenJPAQuery setIgnoreChanges(boolean ignore) {
        this._em.assertNotCloseInvoked();
        this._query.setIgnoreChanges(ignore);
        return this;
    }

    public OpenJPAQuery addFilterListener(FilterListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.addFilterListener(listener);
        return this;
    }

    public OpenJPAQuery removeFilterListener(FilterListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.removeFilterListener(listener);
        return this;
    }

    public OpenJPAQuery addAggregateListener(AggregateListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.addAggregateListener(listener);
        return this;
    }

    public OpenJPAQuery removeAggregateListener(AggregateListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.removeAggregateListener(listener);
        return this;
    }

    public Collection getCandidateCollection() {
        return this._query.getCandidateCollection();
    }

    public OpenJPAQuery setCandidateCollection(Collection coll) {
        this._em.assertNotCloseInvoked();
        this._query.setCandidateCollection(coll);
        return this;
    }

    public Class getResultClass() {
        Class res = this._query.getResultType();
        if (res != null) {
            return res;
        }
        return this._query.getCandidateType();
    }

    public OpenJPAQuery setResultClass(Class cls) {
        this._em.assertNotCloseInvoked();
        if (ImplHelper.isManagedType(this._em.getConfiguration(), cls)) {
            this._query.setCandidateType(cls, true);
        } else {
            this._query.setResultType(cls);
        }
        return this;
    }

    public boolean hasSubclasses() {
        return this._query.hasSubclasses();
    }

    public OpenJPAQuery setSubclasses(boolean subs) {
        this._em.assertNotCloseInvoked();
        Class cls = this._query.getCandidateType();
        this._query.setCandidateExtent(this._query.getBroker().newExtent(cls, subs));
        return this;
    }

    public int getFirstResult() {
        return QueryImpl.asInt(this._query.getStartRange());
    }

    public OpenJPAQuery setFirstResult(int startPosition) {
        this._em.assertNotCloseInvoked();
        long end = this._query.getEndRange() == Long.MAX_VALUE ? Long.MAX_VALUE : (long)startPosition + (this._query.getEndRange() - this._query.getStartRange());
        this._query.setRange(startPosition, end);
        return this;
    }

    public int getMaxResults() {
        return QueryImpl.asInt(this._query.getEndRange() - this._query.getStartRange());
    }

    public OpenJPAQuery setMaxResults(int max) {
        this._em.assertNotCloseInvoked();
        long start = this._query.getStartRange();
        if (max == Integer.MAX_VALUE) {
            this._query.setRange(start, Long.MAX_VALUE);
        } else {
            this._query.setRange(start, start + (long)max);
        }
        return this;
    }

    public OpenJPAQuery compile() {
        this._em.assertNotCloseInvoked();
        this._query.compile();
        return this;
    }

    private Object execute() {
        if (this._query.getOperation() != 1) {
            throw new InvalidStateException(_loc.get("not-select-query", this._query.getQueryString()), null, null, false);
        }
        this.validateParameters();
        if (this._positional != null) {
            return this._query.execute(this._positional.toArray());
        }
        if (this._named != null) {
            return this._query.execute(this._named);
        }
        return this._query.execute();
    }

    private void validateParameters() {
        block3: {
            block2: {
                if (this._positional == null) break block2;
                LinkedMap types = this._query.getParameterTypes();
                int size = Math.min(this._positional.size(), types.size());
                for (int i = 0; i < size; ++i) {
                    this.validateParameter(String.valueOf(i), (Class)types.getValue(i), this._positional.get(i));
                }
                break block3;
            }
            if (this._named == null) break block3;
            LinkedMap types = this._query.getParameterTypes();
            for (Map.Entry entry : this._named.entrySet()) {
                String name = (String)entry.getKey();
                this.validateParameter(name, (Class)types.get(name), entry.getValue());
            }
        }
    }

    private void validateParameter(String paramDesc, Class type, Object param) {
        if (param == null || type == null) {
            return;
        }
        if (!Filters.wrap(type).isInstance(param)) {
            throw new ArgumentException(_loc.get("bad-param-type", paramDesc, param.getClass().getName(), type.getName()), null, null, false);
        }
    }

    public List getResultList() {
        this._em.assertNotCloseInvoked();
        Object ob = this.execute();
        if (ob instanceof List) {
            List ret = (List)ob;
            if (ret instanceof ResultList) {
                return new DelegatingResultList((ResultList)ret, PersistenceExceptions.getRollbackTranslator(this._em));
            }
            return ret;
        }
        return Collections.singletonList(ob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSingleResult() {
        this._em.assertNotCloseInvoked();
        this._query.setUnique(true);
        try {
            Object object = this.execute();
            return object;
        }
        finally {
            this._query.setUnique(false);
        }
    }

    public int executeUpdate() {
        this._em.assertNotCloseInvoked();
        if (this._query.getOperation() == 2) {
            if (this._positional != null) {
                return QueryImpl.asInt(this._query.deleteAll(this._positional.toArray()));
            }
            if (this._named != null) {
                return QueryImpl.asInt(this._query.deleteAll(this._named));
            }
            return QueryImpl.asInt(this._query.deleteAll());
        }
        if (this._query.getOperation() == 3) {
            if (this._positional != null) {
                return QueryImpl.asInt(this._query.updateAll(this._positional.toArray()));
            }
            if (this._named != null) {
                return QueryImpl.asInt(this._query.updateAll(this._named));
            }
            return QueryImpl.asInt(this._query.updateAll());
        }
        throw new InvalidStateException(_loc.get("not-update-delete-query", this._query.getQueryString()), null, null, false);
    }

    private static int asInt(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    public FlushModeType getFlushMode() {
        return EntityManagerImpl.fromFlushBeforeQueries(this._query.getFetchConfiguration().getFlushBeforeQueries());
    }

    public OpenJPAQuery setFlushMode(FlushModeType flushMode) {
        this._em.assertNotCloseInvoked();
        this._query.getFetchConfiguration().setFlushBeforeQueries(EntityManagerImpl.toFlushBeforeQueries(flushMode));
        return this;
    }

    public OpenJPAQuery setHint(String key, Object value) {
        this._em.assertNotCloseInvoked();
        if (key == null || !key.startsWith("openjpa.")) {
            return this;
        }
        String k = key.substring("openjpa.".length());
        try {
            if ("Subclasses".equals(k)) {
                if (value instanceof String) {
                    value = Boolean.valueOf((String)value);
                }
                this.setSubclasses((Boolean)value);
            } else if ("FilterListener".equals(k)) {
                this.addFilterListener(Filters.hintToFilterListener(value, this._query.getBroker().getClassLoader()));
            } else if ("FilterListeners".equals(k)) {
                FilterListener[] arr = Filters.hintToFilterListeners(value, this._query.getBroker().getClassLoader());
                for (int i = 0; i < arr.length; ++i) {
                    this.addFilterListener(arr[i]);
                }
            } else if ("AggregateListener".equals(k)) {
                this.addAggregateListener(Filters.hintToAggregateListener(value, this._query.getBroker().getClassLoader()));
            } else if ("FilterListeners".equals(k)) {
                AggregateListener[] arr = Filters.hintToAggregateListeners(value, this._query.getBroker().getClassLoader());
                for (int i = 0; i < arr.length; ++i) {
                    this.addAggregateListener(arr[i]);
                }
            } else if (k.startsWith("FetchPlan.")) {
                k = k.substring("FetchPlan.".length());
                this.hintToSetter(this.getFetchPlan(), k, value);
            } else if (k.startsWith("hint.")) {
                if ("hint.OptimizeResultCount".equals(k)) {
                    if (value instanceof String) {
                        try {
                            value = new Integer((String)value);
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                    if (!(value instanceof Number) || ((Number)value).intValue() < 0) {
                        throw new ArgumentException(_loc.get("bad-query-hint-value", key, value), null, null, false);
                    }
                }
                this._query.getFetchConfiguration().setHint(key, value);
            } else {
                throw new ArgumentException(_loc.get("bad-query-hint", key), null, null, false);
            }
            return this;
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    private void hintToSetter(FetchPlan fetchPlan, String k, Object value) {
        if (fetchPlan == null || k == null) {
            return;
        }
        Method setter = Reflection.findSetter(fetchPlan.getClass(), k, true);
        Class<?> paramType = setter.getParameterTypes()[0];
        if (Enum.class.isAssignableFrom(paramType) && value instanceof String) {
            value = Enum.valueOf(paramType, (String)value);
        }
        Filters.hintToSetter(fetchPlan, k, value);
    }

    public OpenJPAQuery setParameter(int position, Calendar value, TemporalType t) {
        return this.setParameter(position, (Object)value);
    }

    public OpenJPAQuery setParameter(int position, Date value, TemporalType type) {
        return this.setParameter(position, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenJPAQuery setParameter(int position, Object value) {
        this._query.assertOpen();
        this._em.assertNotCloseInvoked();
        this._query.lock();
        try {
            if (this.isNative() && position < 1) {
                throw new IllegalArgumentException(_loc.get("bad-pos-params", position, this._query.getQueryString()).toString());
            }
            if (this._named != null) {
                throw new InvalidStateException(_loc.get("no-pos-named-params-mix", this._query.getQueryString()), null, null, false);
            }
            if (position < 1) {
                throw new InvalidStateException(_loc.get("illegal-index", position), null, null, false);
            }
            if (this._positional == null) {
                this._positional = new ArrayList();
            }
            while (this._positional.size() < position) {
                this._positional.add(null);
            }
            this._positional.set(position - 1, value);
            QueryImpl queryImpl = this;
            return queryImpl;
        }
        finally {
            this._query.unlock();
        }
    }

    public OpenJPAQuery setParameter(String name, Calendar value, TemporalType t) {
        return this.setParameter(name, (Object)value);
    }

    public OpenJPAQuery setParameter(String name, Date value, TemporalType type) {
        return this.setParameter(name, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenJPAQuery setParameter(String name, Object value) {
        this._query.assertOpen();
        this._em.assertNotCloseInvoked();
        this._query.lock();
        try {
            if (this.isNative()) {
                throw new IllegalArgumentException(_loc.get("no-named-params", name, this._query.getQueryString()).toString());
            }
            if (this._positional != null) {
                throw new InvalidStateException(_loc.get("no-pos-named-params-mix", this._query.getQueryString()), null, null, false);
            }
            if (this._named == null) {
                this._named = new HashMap();
            }
            this._named.put(name, value);
            QueryImpl queryImpl = this;
            return queryImpl;
        }
        finally {
            this._query.unlock();
        }
    }

    public boolean isNative() {
        return "openjpa.SQL".equals(this.getLanguage());
    }

    public boolean hasPositionalParameters() {
        return this._positional != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getPositionalParameters() {
        this._query.lock();
        try {
            Object[] objectArray = this._positional == null ? EMPTY_ARRAY : this._positional.toArray();
            return objectArray;
        }
        finally {
            this._query.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenJPAQuery setParameters(Object ... params) {
        this._query.assertOpen();
        this._em.assertNotCloseInvoked();
        this._query.lock();
        try {
            this._positional = null;
            this._named = null;
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    this.setParameter(i + 1, params[i]);
                }
            }
            QueryImpl queryImpl = this;
            return queryImpl;
        }
        finally {
            this._query.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getNamedParameters() {
        this._query.lock();
        try {
            Map map = this._named == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this._named);
            return map;
        }
        finally {
            this._query.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenJPAQuery setParameters(Map params) {
        this._query.assertOpen();
        this._em.assertNotCloseInvoked();
        this._query.lock();
        try {
            this._positional = null;
            this._named = null;
            if (params != null) {
                for (Map.Entry e : params.entrySet()) {
                    this.setParameter((String)e.getKey(), e.getValue());
                }
            }
            QueryImpl queryImpl = this;
            return queryImpl;
        }
        finally {
            this._query.unlock();
        }
    }

    public OpenJPAQuery closeAll() {
        this._query.closeAll();
        return this;
    }

    public String[] getDataStoreActions(Map params) {
        return this._query.getDataStoreActions(params);
    }

    public int hashCode() {
        return this._query.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof QueryImpl)) {
            return false;
        }
        return this._query.equals(((QueryImpl)other)._query);
    }
}

