/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DelegatingBrokerFactory;
import org.apache.openjpa.kernel.DelegatingFetchConfiguration;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.FetchPlanImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryResultCache;
import org.apache.openjpa.persistence.QueryResultCacheImpl;
import org.apache.openjpa.persistence.StoreCache;
import org.apache.openjpa.persistence.StoreCacheImpl;
import org.apache.openjpa.util.OpenJPAException;
import serp.util.Strings;

public class EntityManagerFactoryImpl
implements OpenJPAEntityManagerFactory,
OpenJPAEntityManagerFactorySPI,
Closeable {
    private static final Localizer _loc = Localizer.forPackage(EntityManagerFactoryImpl.class);
    private DelegatingBrokerFactory _factory = null;
    private transient Constructor<FetchPlan> _plan = null;
    private transient StoreCache _cache = null;
    private transient QueryResultCache _queryCache = null;

    public EntityManagerFactoryImpl() {
    }

    public EntityManagerFactoryImpl(BrokerFactory factory) {
        this.setBrokerFactory(factory);
    }

    public BrokerFactory getBrokerFactory() {
        return this._factory.getDelegate();
    }

    public void setBrokerFactory(BrokerFactory factory) {
        this._factory = new DelegatingBrokerFactory(factory, PersistenceExceptions.TRANSLATOR);
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._factory.getConfiguration();
    }

    public Properties getProperties() {
        return this._factory.getProperties();
    }

    public Object putUserObject(Object key, Object val) {
        return this._factory.putUserObject(key, val);
    }

    public Object getUserObject(Object key) {
        return this._factory.getUserObject(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreCache getStoreCache() {
        this._factory.lock();
        try {
            if (this._cache == null) {
                OpenJPAConfiguration conf = this._factory.getConfiguration();
                this._cache = new StoreCacheImpl(this, conf.getDataCacheManagerInstance().getSystemDataCache());
            }
            StoreCache storeCache = this._cache;
            return storeCache;
        }
        finally {
            this._factory.unlock();
        }
    }

    public StoreCache getStoreCache(String cacheName) {
        return new StoreCacheImpl(this, this._factory.getConfiguration().getDataCacheManagerInstance().getDataCache(cacheName, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResultCache getQueryResultCache() {
        this._factory.lock();
        try {
            if (this._queryCache == null) {
                this._queryCache = new QueryResultCacheImpl(this._factory.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache());
            }
            QueryResultCache queryResultCache = this._queryCache;
            return queryResultCache;
        }
        finally {
            this._factory.unlock();
        }
    }

    public OpenJPAEntityManagerSPI createEntityManager() {
        return this.createEntityManager(null);
    }

    public OpenJPAEntityManagerSPI createEntityManager(Map props) {
        int retainMode;
        boolean managed;
        String str;
        String pass;
        if (props == null) {
            props = Collections.EMPTY_MAP;
        } else if (!props.isEmpty()) {
            props = new HashMap(props);
        }
        OpenJPAConfiguration conf = this.getConfiguration();
        String user = (String)Configurations.removeProperty("ConnectionUserName", props);
        if (user == null) {
            user = conf.getConnectionUserName();
        }
        if ((pass = (String)Configurations.removeProperty("ConnectionPassword", props)) == null) {
            pass = conf.getConnectionPassword();
        }
        if ((str = (String)Configurations.removeProperty("TransactionMode", props)) == null) {
            managed = conf.isTransactionModeManaged();
        } else {
            Value val = conf.getValue("TransactionMode");
            managed = Boolean.parseBoolean(val.unalias(str));
        }
        Object obj = Configurations.removeProperty("ConnectionRetainMode", props);
        if (obj instanceof Number) {
            retainMode = ((Number)obj).intValue();
        } else if (obj == null) {
            retainMode = conf.getConnectionRetainModeConstant();
        } else {
            Value val = conf.getValue("ConnectionRetainMode");
            try {
                retainMode = Integer.parseInt(val.unalias((String)obj));
            }
            catch (Exception e) {
                throw new ArgumentException(_loc.get("bad-em-prop", "openjpa.ConnectionRetainMode", obj), new Throwable[]{e}, obj, true);
            }
        }
        Broker broker = this._factory.newBroker(user, pass, managed, retainMode, false);
        broker.setAutoDetach(2, true);
        broker.setAutoDetach(16, true);
        broker.setDetachedNew(false);
        EntityManagerImpl em = this.newEntityManagerImpl(broker);
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        LinkedList<RuntimeException> errs = null;
        for (Map.Entry entry : props.entrySet()) {
            Method setter;
            String prop = (String)entry.getKey();
            String prefix = null;
            for (int i = 0; i < prefixes.length && !prop.startsWith(prefix = prefixes[i] + "."); ++i) {
                prefix = null;
            }
            if (prefix == null) continue;
            prop = prop.substring(prefix.length());
            try {
                setter = Reflection.findSetter(em.getClass(), prop, true);
            }
            catch (OpenJPAException ke) {
                if (errs == null) {
                    errs = new LinkedList<RuntimeException>();
                }
                errs.add(PersistenceExceptions.toPersistenceException(ke));
                continue;
            }
            Object val = entry.getValue();
            try {
                if (val instanceof String) {
                    val = "null".equals(val) ? null : Strings.parse((String)val, setter.getParameterTypes()[0]);
                }
                Reflection.set((Object)em, setter, val);
            }
            catch (Throwable t) {
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                ArgumentException err = new ArgumentException(_loc.get("bad-em-prop", prop, entry.getValue()), new Throwable[]{t}, null, true);
                if (errs == null) {
                    errs = new LinkedList();
                }
                errs.add(err);
            }
        }
        if (errs != null) {
            em.close();
            if (errs.size() == 1) {
                throw (RuntimeException)errs.get(0);
            }
            throw new ArgumentException(_loc.get("bad-em-props"), errs.toArray(new Throwable[errs.size()]), null, true);
        }
        return em;
    }

    protected EntityManagerImpl newEntityManagerImpl(Broker broker) {
        return new EntityManagerImpl(this, broker);
    }

    public void addLifecycleListener(Object listener, Class ... classes) {
        this._factory.addLifecycleListener(listener, classes);
    }

    public void removeLifecycleListener(Object listener) {
        this._factory.removeLifecycleListener(listener);
    }

    public void addTransactionListener(Object listener) {
        this._factory.addTransactionListener(listener);
    }

    public void removeTransactionListener(Object listener) {
        this._factory.removeTransactionListener(listener);
    }

    public void close() {
        this._factory.close();
    }

    public boolean isOpen() {
        return !this._factory.isClosed();
    }

    public int hashCode() {
        return this._factory.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EntityManagerFactoryImpl)) {
            return false;
        }
        return this._factory.equals(((EntityManagerFactoryImpl)other)._factory);
    }

    FetchPlan toFetchPlan(Broker broker, FetchConfiguration fetch) {
        if (fetch == null) {
            return null;
        }
        if (fetch instanceof DelegatingFetchConfiguration) {
            fetch = ((DelegatingFetchConfiguration)fetch).getInnermostDelegate();
        }
        try {
            if (this._plan == null) {
                Class<?> storeType = broker == null ? null : broker.getStoreManager().getInnermostDelegate().getClass();
                Class cls = this._factory.getConfiguration().getStoreFacadeTypeRegistry().getImplementation(FetchPlan.class, storeType, FetchPlanImpl.class);
                this._plan = cls.getConstructor(FetchConfiguration.class);
            }
            return this._plan.newInstance(fetch);
        }
        catch (InvocationTargetException ite) {
            throw PersistenceExceptions.toPersistenceException(ite.getTargetException());
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }
}

