/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.jdbc.meta;

import com.ibm.pdq.runtime.internal.xml.PDQXml;
import com.ibm.pdq.runtime.internal.xml.PDQXmlParameterMetaData;
import com.ibm.pdq.runtime.internal.xml.PDQXmlResultSetMetaData;
import com.ibm.pdq.runtime.internal.xml.PDQXmlStatement;
import com.ibm.pdq.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.pdq.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.pdq.runtime.statement.SqlStatementType;
import com.ibm.ws.persistence.jdbc.sql.DB2Dictionary;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticSequenceMapping;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticDB2Dictionary;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticSelectImpl;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMeta;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMetas;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.SequenceMetaData;

public class StaticMappingRepository
extends MappingRepository {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(StaticMappingRepository.class);
    protected Log _logs = null;
    private PDQMetas _pdqmetas = null;
    private String _pu;
    private boolean _singlePackage = false;
    private String _pkgName = null;
    private String _collectionId = null;
    private String _runtimeSignature = null;
    private SqlStatementType _stmtType = SqlStatementType.OTHERSQL;
    private Map<String, String> entity2packageMap = new HashMap<String, String>();
    private Map<String, String> package2entityMap = new HashMap<String, String>();
    private Map<String, Integer> packageNumMap = new HashMap<String, Integer>();
    private int packageNum = 0;
    private Map<String, PDQXmlResultSetMetaData> rmdMap = new HashMap<String, PDQXmlResultSetMetaData>();
    private Map<StaticSelectImpl.StaticSelectResult, List> resMap = new HashMap<StaticSelectImpl.StaticSelectResult, List>();
    private long oldConsistencyToken = 0L;
    private String SEQ_PKG_NAME = "pkgseq";
    private int serverType = -1;

    public StaticMappingRepository() {
        this._pdqmetas = new PDQMetas();
    }

    public void setPU(String pu) {
        this._pu = pu;
    }

    public String getPU() {
        return this._pu;
    }

    public void setSinglePackage(boolean singlePackage) {
        this._singlePackage = singlePackage;
    }

    public boolean getSinglePackage() {
        return this._singlePackage;
    }

    public void setCollection(String col) {
        this._collectionId = col;
    }

    public String getCollection() {
        return this._collectionId;
    }

    public void setRuntimeSignature(String signature) {
        this._runtimeSignature = signature;
    }

    public String getRuntimeSignature() {
        return this._runtimeSignature;
    }

    public void setPkgName(String name) {
        if (this._singlePackage) {
            this._pkgName = name;
            return;
        }
        String pkgName = this.entity2packageMap.get(name);
        if (pkgName == null) {
            pkgName = this.makeNewPackageName(name);
        }
        this._pkgName = pkgName;
        if (this.serverType == -1) {
            DBDictionary dict = this.getDBDictionary();
            if (dict instanceof DB2Dictionary) {
                this.serverType = ((DB2Dictionary)dict).getDb2ServerType();
            }
            if (this.serverType == 1 || this.serverType == 5) {
                this.SEQ_PKG_NAME = this.SEQ_PKG_NAME.toUpperCase();
            }
        }
        if (this.serverType == 1 || this.serverType == 5) {
            this._pkgName = this._pkgName.toUpperCase();
        }
    }

    public String makeNewPackageName(String entityName) {
        String entityName1 = entityName.substring(entityName.lastIndexOf(".") + 1);
        if (entityName1.length() <= StaticSQLGenUtil.PACKAGE_NAME_LENGTH) {
            this.entity2packageMap.put(entityName, entityName1);
            this.package2entityMap.put(entityName1, entityName);
            return entityName1;
        }
        String prefix = entityName1.substring(0, StaticSQLGenUtil.PACKAGE_NAME_LENGTH);
        return this.makeNewPackageName1(entityName, prefix);
    }

    protected String makeNewPackageName1(String entityName, String prefix) {
        String pkgName = null;
        int pkgNum = 0;
        if (!this.packageNumMap.containsKey(prefix)) {
            pkgName = prefix;
            if (!this.package2entityMap.containsKey(pkgName)) {
                this.entity2packageMap.put(entityName, pkgName);
                this.package2entityMap.put(pkgName, entityName);
                this.packageNumMap.put(prefix, 1);
                return pkgName;
            }
            if (prefix.length() == 1) {
                return this.generatePkgName(entityName);
            }
            String prefix1 = prefix.substring(0, prefix.length() - 1);
            return this.makeNewPackageName1(entityName, prefix1);
        }
        pkgNum = this.packageNumMap.get(prefix);
        if (pkgNum < 9 && !this.package2entityMap.containsKey(pkgName = prefix.substring(0, prefix.length() - 1) + ++pkgNum)) {
            this.entity2packageMap.put(entityName, pkgName);
            this.package2entityMap.put(pkgName, entityName);
            this.packageNumMap.put(prefix, pkgNum);
            return pkgName;
        }
        if (prefix.length() == 1) {
            return this.generatePkgName(entityName);
        }
        String prefix1 = prefix.substring(0, prefix.length() - 1);
        return this.makeNewPackageName1(entityName, prefix1);
    }

    protected String generatePkgName(String entityName) {
        String pkgName = "pkg" + this.packageNum;
        ++this.packageNum;
        this.entity2packageMap.put(entityName, pkgName);
        this.package2entityMap.put(pkgName, entityName);
        return pkgName;
    }

    public void setStmtType(SqlStatementType type) {
        this._stmtType = type;
    }

    public SqlStatementType getStmtType() {
        return this._stmtType;
    }

    public void createPDQMeta(String sqlStr, PreparedStatement stmnt, int type) {
        PDQMeta meta;
        if (sqlStr.substring(0, 6).equalsIgnoreCase("values")) {
            return;
        }
        if (this._logs == null) {
            this._logs = this.getConfiguration().getLog("wsjpa.Sqlgen");
        }
        if ((meta = this._pdqmetas.getPackage(this._pkgName)) == null) {
            meta = this.createPDQXmlPackage();
            this._pdqmetas.addPackage(this._pkgName, meta);
        }
        if (meta.exists(sqlStr)) {
            if (this._runtimeSignature != null) {
                meta.updateMethodName(sqlStr, this._runtimeSignature);
            }
            return;
        }
        PDQXmlStatement pdqStmnt = this.createPDQXmlStatement(sqlStr, stmnt, type);
        if (pdqStmnt == null) {
            return;
        }
        meta.addStatement(pdqStmnt);
        this._pdqmetas.incrementCount();
    }

    private PDQMeta createPDQXmlPackage() {
        long consistencyToken = 0L;
        if (this._pkgName == null) {
            this.setPkgName(this.SEQ_PKG_NAME);
        }
        if (this._collectionId == null) {
            this._collectionId = "NULLID";
        }
        PDQMeta pkg = new PDQMeta();
        pkg.setPackageName(this._pkgName);
        pkg.setCollectionName(this._collectionId);
        consistencyToken = System.currentTimeMillis();
        if (consistencyToken == this.oldConsistencyToken) {
            ++consistencyToken;
        }
        pkg.setConsistencyToken(consistencyToken);
        this.oldConsistencyToken = consistencyToken;
        return pkg;
    }

    private PDQXmlStatement createPDQXmlStatement(String sqlStr, PreparedStatement stmnt, int type) {
        PDQXmlStatement pdqStmnt = new PDQXmlStatement();
        PDQXmlStatementDescriptor pdqStmntD = new PDQXmlStatementDescriptor();
        pdqStmnt.setPDQXmlStatementDescriptor(pdqStmntD);
        pdqStmntD.setMethodName(this._runtimeSignature);
        pdqStmntD.setParameterHandlerName(null);
        if (!this.setMetaData(stmnt, sqlStr, pdqStmntD)) {
            return null;
        }
        pdqStmntD.setRowHandlerName(null);
        PDQXmlStatementAttributes cursor = new PDQXmlStatementAttributes();
        cursor.setHoldability(Integer.valueOf(1));
        pdqStmntD.setStatementAttributes(cursor);
        pdqStmntD.setSql(sqlStr);
        if (type == 0) {
            pdqStmntD.setStatementType(SqlStatementType.UPDATE.name());
        } else if (type == 1) {
            pdqStmntD.setStatementType(SqlStatementType.INSERT.name());
        } else if (type == 2) {
            pdqStmntD.setStatementType(SqlStatementType.DELETE.name());
        } else {
            pdqStmntD.setStatementType(SqlStatementType.QUERY.name());
        }
        return pdqStmnt;
    }

    private boolean setMetaData(PreparedStatement stmnt, String sqlStr, PDQXmlStatementDescriptor pdqStmntD) {
        PreparedStatement stmnt3 = null;
        Object stmnt2 = stmnt;
        try {
            while (true) {
                Method getInnermostDelegate = stmnt2.getClass().getMethod("getInnermostDelegate", null);
                stmnt2 = getInnermostDelegate.invoke(stmnt2, (Object[])null);
            }
        }
        catch (Exception ne) {
            stmnt3 = stmnt2;
            try {
                PDQXmlParameterMetaData pmd = new PDQXmlParameterMetaData();
                pmd.init(stmnt3);
                PDQXmlResultSetMetaData rmd = new PDQXmlResultSetMetaData();
                rmd.init(stmnt3);
                this.rmdMap.put(sqlStr, rmd);
                pdqStmntD.setParameterMetadata(pmd);
                pdqStmntD.setResultSetMetaData(rmd);
                return true;
            }
            catch (SQLException e) {
                if (this._logs.isTraceEnabled()) {
                    this._logs.trace(_loc.get("fail-to-retrieve-ParameterMetaData-or-ResultSetMetaData", sqlStr));
                    StaticSQLGenUtil.printException(this._logs, e);
                }
                return false;
            }
        }
    }

    public List getColumns(String sql2) {
        try {
            return this.rmdMap.get(sql2).getColumns();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setColumns(StaticSelectImpl.StaticSelectResult res, List columns) {
        this.resMap.put(res, columns);
    }

    public List getColumns(StaticSelectImpl.StaticSelectResult res) {
        return this.resMap.get(res);
    }

    public PDQMetas getPDQMetas() {
        PDQXml pdqXml = ((StaticDB2Dictionary)this.getDBDictionary()).getPDQXml();
        this._pdqmetas.setPDQXml(pdqXml);
        PDQMeta meta = this._pdqmetas.getPackage(this.SEQ_PKG_NAME);
        if (meta != null) {
            if (this._singlePackage) {
                meta.setPackageName(this._pkgName);
            }
            if (this._collectionId != null) {
                meta.setCollectionName(this._collectionId);
            }
        }
        if (this._logs != null && this._logs.isTraceEnabled()) {
            this.dumpPackageNames();
        }
        return this._pdqmetas;
    }

    private void dumpPackageNames() {
        Set<String> keys = this.entity2packageMap.keySet();
        for (String entityName : keys) {
            if (entityName.equals(this.SEQ_PKG_NAME)) continue;
            String pkgName = this.entity2packageMap.get(entityName);
            this._logs.trace(_loc.get("entity-package", new Object[]{entityName, pkgName}));
        }
    }

    protected SequenceMetaData newSequenceMetaData(String name) {
        return new StaticSequenceMapping(name, this);
    }
}

