/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.gen;

import com.ibm.ws.persistence.pdqstatic.gen.StaticAbstractSQLStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenerator;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.FieldMetaData;

public class StaticInsertStmt
extends StaticAbstractSQLStmt {
    private static final Localizer _loc = Localizer.forPackage(StaticInsertStmt.class);

    public StaticInsertStmt(EntityManager em, StaticSQLGenerator.BindInfo bindInfo, Log _logs) {
        super(em, bindInfo, _logs);
    }

    public void generate() {
        this.createEntities();
    }

    public List createEntities() {
        this.em.clear();
        ArrayList<Object> entities = new ArrayList<Object>();
        HashMap<Object, Object[]> failedEntities = new HashMap<Object, Object[]>();
        ArrayList<ClassMapping> entitiesToBeCreated = new ArrayList<ClassMapping>();
        this.em.getTransaction().begin();
        for (int i = 0; i < this.clms.length; ++i) {
            if (this.clms[i].isEmbeddedOnly()) continue;
            Class cls = this.clms[i].getDescribedType();
            String entityClassName = cls.getName();
            int modifiers = cls.getModifiers();
            boolean isAbstract = Modifier.isAbstract(modifiers);
            boolean isInterface = Modifier.isInterface(modifiers);
            if (isAbstract || isInterface) continue;
            entitiesToBeCreated.add(this.clms[i]);
            FieldMetaData[] pks = this.clms[i].getPrimaryKeyFields();
            if (this.clms[i].getIdentityType() != 2 || this.clms[i].isOpenJPAIdentity() && pks[0].getDeclaredTypeCode() == 29) continue;
            entitiesToBeCreated.add(this.clms[i]);
        }
        for (ClassMapping clm : entitiesToBeCreated) {
            Class cls = clm.getDescribedType();
            String entityClassName = cls.getName();
            Object entity = null;
            try {
                entity = cls.newInstance();
            }
            catch (Exception e) {
                try {
                    entity = StaticSQLGenUtil.constructObjFromClass(cls, this._logs);
                }
                catch (Exception ex) {
                    StaticSQLGenUtil.printException(this._logs, ex);
                }
            }
            if (entity == null) continue;
            FieldMapping[] allPKFields = (FieldMapping[])clm.getPrimaryKeyFields();
            FieldMetaData[] fields = (FieldMapping[])clm.getFields();
            try {
                StaticSQLGenUtil.setPrimaryKey(allPKFields, entity, this._logs);
            }
            catch (Exception e) {
                failedEntities.put(entity, new Object[]{fields, clm});
                continue;
            }
            if (!StaticSQLGenUtil.setNonNullableFields(fields, entity, this._logs)) continue;
            StaticSQLGenUtil.setExternalStringFields((FieldMapping[])fields, entity, this._logs);
            this.metaRepo.setRuntimeSignature(entityClassName + ":Create");
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(entityClassName);
            }
            if (this._logs.isTraceEnabled()) {
                this._logs.trace(_loc.get("add-entity", entityClassName));
            }
            if (!StaticSQLGenUtil.persist(this.em, entity, this._logs)) {
                failedEntities.put(entity, new Object[]{fields, clm});
                continue;
            }
            StaticSQLGenUtil.setVersion(clm, entity, this._logs);
            entities.add(entity);
        }
        try {
            this.em.flush();
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(this._logs, e);
        }
        if (failedEntities.size() > 0) {
            this.persistFailedObj(failedEntities, entities);
        }
        StaticSQLGenUtil.commit(this.em, this._logs);
        return entities;
    }

    private void persistFailedObj(Map failedEntities, List managedEntities) {
        int failedCount = failedEntities.size();
        HashMap failedEntities1 = new HashMap();
        Set failedObjs = failedEntities.keySet();
        for (Object failedObj : failedObjs) {
            String failedEntityClassName = failedObj.getClass().getName();
            Object[] entityInfo = (Object[])failedEntities.get(failedObj);
            FieldMetaData[] fmd = (FieldMetaData[])entityInfo[0];
            ClassMapping clm = (ClassMapping)entityInfo[1];
            if (!StaticSQLGenUtil.setNonNullableFields(failedObj, fmd, managedEntities, this._logs)) continue;
            this.metaRepo.setRuntimeSignature(failedEntityClassName + ":Create");
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(failedEntityClassName);
            }
            if (this._logs.isTraceEnabled()) {
                this._logs.trace(_loc.get("add-entity", failedEntityClassName));
            }
            if (!StaticSQLGenUtil.persistFlush(this.em, failedObj, this._logs)) {
                failedEntities1.put(failedObj, entityInfo);
                continue;
            }
            StaticSQLGenUtil.setVersion(clm, failedObj, this._logs);
            managedEntities.add(failedObj);
        }
        if (failedEntities1.size() == 0 || failedEntities1.size() == failedCount) {
            return;
        }
        this.persistFailedObj(failedEntities1, managedEntities);
    }
}

