/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdq.meta;

import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.pdq.meta.PDQMappingRepository;
import com.ibm.ws.persistence.pdq.meta.PDQParameterHandler;
import com.ibm.ws.persistence.pdq.meta.PreparedStatementObjArray;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;

public abstract class PDQBaseData {
    private static final Localizer _loc = Localizer.forPackage(PDQBaseData.class);
    public static final String generatorVersion = "1.1.1";
    private static String heterogeneousNone = "heterogeneousNone__";
    private static String heterogeneousModify = "heterogeneousModify__";
    private static String heterogeneousQuery = "heterogeneousQuery__";
    private static String heterogeneousMixed = "heterogeneousMixed__";
    private static Class statementDescriptor;
    private static Class generatorData;
    private static Class data;
    private static Class dataFactory;
    private static Class heterogeneousBatchKind;
    private static Method getData;
    private static Method queryResultsStatic;
    private static Method queryResultsDynamic;
    private static Method updateStatic;
    private static Method updateDynamic;
    private static Method startBatch;
    private static Method endBatch;
    private static Method getBatchKind;
    private static PDQParameterHandler paramHandler;

    public static ResultSet queryResults(Connection conn, JDBCConfiguration conf, SQLBuffer buf, Object[] params) throws SQLException {
        Log _log = conf.getLog("wsjpa.pdq");
        Properties props = ((WsJpaJDBCConfiguration)conf).getPdqProperties();
        String sql2 = buf.getSQL();
        PDQMappingRepository pdqrepos = (PDQMappingRepository)conf.getMappingRepositoryInstance();
        PreparedStatementObjArray stmnt = new PreparedStatementObjArray(params);
        paramHandler.handleSQLBuffer(buf, conf.getDBDictionaryInstance(), stmnt);
        Object sd = pdqrepos.getStaticStatementDescriptor(sql2);
        try {
            boolean isStatic;
            Object data = getData.invoke((Object)dataFactory, conn, props);
            boolean bl = isStatic = sd != null && props != null && props.getProperty("pdq.executionMode").equals("STATIC");
            if (_log.isTraceEnabled()) {
                _log.trace(_loc.get(isStatic ? "pdq-static" : "pdq-dynamic", sql2));
            }
            int rsType = 1003;
            int rsConcur = 1007;
            int rsHold = 1;
            ResultSet rs = null;
            rs = sd != null ? (ResultSet)queryResultsStatic.invoke(data, sd, stmnt.data_) : (ResultSet)queryResultsDynamic.invoke(data, rsType, rsConcur, rsHold, sql2, stmnt.data_);
            return rs;
        }
        catch (InvocationTargetException de) {
            de.printStackTrace();
            throw (SQLException)de.getTargetException().getCause().getCause();
        }
        catch (IllegalAccessException e) {
            throw (SQLException)e.getCause();
        }
    }

    public static int update(Connection conn, JDBCConfiguration conf, SQLBuffer update) throws SQLException {
        Log _log = conf.getLog("wsjpa.pdq");
        Properties props = ((WsJpaJDBCConfiguration)conf).getPdqProperties();
        String sql2 = update.getSQL();
        Object[] params = update.getParameters().toArray();
        PDQMappingRepository pdqrepos = (PDQMappingRepository)conf.getMappingRepositoryInstance();
        PreparedStatementObjArray stmnt = new PreparedStatementObjArray(params);
        paramHandler.handleSQLBuffer(update, conf.getDBDictionaryInstance(), stmnt);
        Object sd = pdqrepos.getStaticStatementDescriptor(sql2);
        try {
            boolean isStatic;
            Object data = getData.invoke((Object)dataFactory, conn, props);
            boolean bl = isStatic = sd != null && props != null && props.getProperty("pdq.executionMode").equals("STATIC");
            if (_log.isTraceEnabled()) {
                _log.trace(_loc.get(isStatic ? "pdq-static" : "pdq-dynamic", sql2));
            }
            int count = 0;
            count = sd != null ? ((Integer)updateStatic.invoke(data, sd, stmnt.data_)).intValue() : ((Integer)updateDynamic.invoke(data, sql2, stmnt.data_)).intValue();
            return count;
        }
        catch (InvocationTargetException de) {
            throw (SQLException)de.getTargetException().getCause();
        }
        catch (IllegalAccessException e) {
            throw (SQLException)e.getCause();
        }
    }

    public static int update(Connection conn, JDBCStore store, RowImpl row) throws SQLException {
        return PDQBaseData.update(conn, store, row, null);
    }

    public static int update(Connection conn, JDBCStore store, RowImpl row, Object data1) throws SQLException {
        WsJpaJDBCConfiguration conf = (WsJpaJDBCConfiguration)store.getConfiguration();
        Log _log = conf.getLog("wsjpa.pdq");
        Properties props = conf.getPdqProperties();
        String sql2 = row.getSQL(store.getDBDictionary());
        PDQMappingRepository pdqrepos = (PDQMappingRepository)conf.getMappingRepositoryInstance();
        Object[] params = row.getVals();
        params = PDQBaseData.processNulls(row, params);
        PreparedStatementObjArray stmnt = new PreparedStatementObjArray(params);
        paramHandler.handleRow(row, store, stmnt);
        Object sd = pdqrepos.getStaticStatementDescriptor(sql2);
        try {
            boolean isStatic;
            Object data = data1;
            if (data == null) {
                data = getData.invoke((Object)dataFactory, conn, props);
            }
            boolean bl = isStatic = sd != null && props != null && props.getProperty("pdq.executionMode").equals("STATIC");
            if (_log.isTraceEnabled()) {
                _log.trace(_loc.get(isStatic ? "pdq-static" : "pdq-dynamic", sql2));
            }
            int count = 0;
            count = sd != null ? ((Integer)updateStatic.invoke(data, sd, stmnt.data_)).intValue() : ((Integer)updateDynamic.invoke(data, sql2, stmnt.data_)).intValue();
            return count;
        }
        catch (InvocationTargetException de) {
            de.printStackTrace();
            throw (SQLException)de.getTargetException().getCause();
        }
        catch (IllegalAccessException e) {
            throw (SQLException)e.getCause();
        }
    }

    private static Object[] processNulls(RowImpl row, Object ... vals) {
        int i = row.getAction() == 2 ? row.getColumns().length : 0;
        int length = 0;
        for (int j = i; j < vals.length; ++j) {
            if (vals[j] == null) continue;
            ++length;
        }
        Object[] params = new Object[length];
        int half = vals.length / 2;
        int j = 0;
        while (i < vals.length) {
            if (vals[i] == null) {
                --j;
            } else {
                params[j] = vals[i];
                if ((vals[i] != RowImpl.NULL || row.getAction() == 1 || i < half) && vals[i] == RowImpl.NULL) {
                    params[j] = null;
                }
            }
            ++i;
            ++j;
        }
        return params;
    }

    public static Object startBatch(Connection conn, JDBCStore store) throws SQLException {
        WsJpaJDBCConfiguration conf = (WsJpaJDBCConfiguration)store.getConfiguration();
        Properties props = conf.getPdqProperties();
        try {
            Object data = getData.invoke((Object)dataFactory, conn, props);
            Enum[] batchKinds = (Enum[])heterogeneousBatchKind.getEnumConstants();
            for (int i = 0; i < batchKinds.length; ++i) {
                if (!batchKinds[i].name().equals(heterogeneousModify)) continue;
                startBatch.invoke(data, batchKinds[i]);
                return data;
            }
            return null;
        }
        catch (InvocationTargetException de) {
            de.printStackTrace();
            throw (SQLException)de.getTargetException().getCause();
        }
        catch (IllegalAccessException e) {
            throw (SQLException)e.getCause();
        }
    }

    public static int[][] endBatch(Connection conn, JDBCStore store, Object data) throws SQLException {
        WsJpaJDBCConfiguration conf = (WsJpaJDBCConfiguration)store.getConfiguration();
        Properties props = conf.getPdqProperties();
        try {
            return (int[][])endBatch.invoke(data, null);
        }
        catch (InvocationTargetException de) {
            de.printStackTrace();
            throw (SQLException)de.getTargetException().getCause();
        }
        catch (IllegalAccessException e) {
            throw (SQLException)e.getCause();
        }
    }

    static {
        paramHandler = new PDQParameterHandler();
        try {
            ClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            statementDescriptor = Class.forName("com.ibm.pdq.runtime.statement.StatementDescriptor", false, loader);
            dataFactory = Class.forName("com.ibm.pdq.runtime.factory.DataFactory", false, loader);
            getData = dataFactory.getMethod("getData", Connection.class, Properties.class);
            generatorData = Class.forName("com.ibm.pdq.runtime.generator.GeneratorData", false, loader);
            data = Class.forName("com.ibm.pdq.runtime.Data", false, loader);
            heterogeneousBatchKind = Class.forName("com.ibm.pdq.runtime.HeterogeneousBatchKind", false, loader);
            queryResultsStatic = generatorData.getMethod("queryResults", statementDescriptor, Object[].class);
            queryResultsDynamic = data.getMethod("queryResults", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Object[].class);
            updateStatic = generatorData.getMethod("update", statementDescriptor, Object[].class);
            updateDynamic = data.getMethod("update", String.class, Object[].class);
            startBatch = data.getMethod("startBatch", heterogeneousBatchKind);
            endBatch = data.getMethod("endBatch", new Class[0]);
            getBatchKind = data.getMethod("getBatchKind", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

