/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.kernel;

import com.ibm.ws.persistence.kernel.WsJpaStateManagerImpl;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ImplHelper;

public class WsJpaBrokerImpl
extends BrokerImpl {
    private static final long serialVersionUID = 2491212973382881349L;

    protected Collection getTransactionalStates() {
        Collection col = super.getTransactionalStates();
        String updateManager = ((JDBCConfigurationImpl)this.getConfiguration()).getUpdateManager();
        if (!this.isPDQUpdateManager(updateManager)) {
            return col;
        }
        for (StateManagerImpl s : col) {
            int i;
            if (!this.isUpdate(s)) continue;
            BitSet dirty = s.getDirty();
            ClassMetaData meta = s.getMetaData();
            int size = meta.getFields().length;
            boolean updateAllEager = false;
            ArrayList<Integer> toUpdateFields = new ArrayList<Integer>();
            for (i = 0; i < size; ++i) {
                boolean isDirty = dirty.get(i);
                FieldMetaData fmd = meta.getField(i);
                boolean isEager = fmd.isInDefaultFetchGroup();
                if (isDirty && isEager) {
                    updateAllEager = true;
                    continue;
                }
                if (!isEager || fmd.isPrimaryKey() || fmd.isVersion()) continue;
                toUpdateFields.add(fmd.getIndex());
            }
            if (!updateAllEager) continue;
            for (i = 0; i < toUpdateFields.size(); ++i) {
                int idx = (Integer)toUpdateFields.get(i);
                s.dirty(idx);
                Object val = s.fetch(idx);
                s.storeField(idx, val);
            }
        }
        return col;
    }

    private boolean isUpdate(StateManagerImpl sm) {
        if (sm.getPCState() == PCState.PNEW && !sm.isFlushed()) {
            return false;
        }
        if (sm.getPCState() == PCState.PNEWFLUSHEDDELETED || sm.getPCState() == PCState.PDELETED) {
            return false;
        }
        return ImplHelper.getUpdateFields(sm) != null;
    }

    protected StateManagerImpl newStateManagerImpl(Object oid, ClassMetaData meta) {
        return new WsJpaStateManagerImpl(oid, meta, this);
    }

    public boolean isPDQUpdateManager(String updateManager) {
        boolean rval = false;
        if (updateManager.indexOf("com.ibm.ws.persistence.pdq") != -1 && (updateManager.indexOf("PDQConstraintUpdateManager") != -1 || updateManager.indexOf("StaticOperationOrderUpdateManager") != -1 || updateManager.indexOf("StaticConstraintUpdateManager") != -1)) {
            rval = true;
        }
        return rval;
    }
}

