/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.sql;

import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.StoreException;

public class DB2Dictionary
extends org.apache.openjpa.jdbc.sql.DB2Dictionary {
    private static final Localizer _loc = Localizer.forPackage(DB2Dictionary.class);
    public String versionColumnTableSyntax = null;
    public String versionColumnTimestampSyntax = null;
    public String versionColumnIntegerSyntax = null;
    public int _defaultBatchLimit = 100;

    public DB2Dictionary() {
        super.setBatchLimit(this._defaultBatchLimit);
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        if (this.db2ServerType == 3 && this.maj >= 9 || this.db2ServerType == 4 && this.maj >= 9 && this.min >= 5) {
            this.versionColumnTableSyntax = "NOT NULL GENERATED BY DEFAULT FOR EACH ROW ON UPDATE AS ROW CHANGE TIMESTAMP";
            if (this.db2ServerType == 4) {
                this.versionColumnTableSyntax = "TIMESTAMP " + this.versionColumnTableSyntax;
            }
            this.versionColumnTimestampSyntax = "ROW CHANGE TIMESTAMP FOR";
            this.versionColumnIntegerSyntax = "ROW CHANGE TOKEN FOR";
        }
    }

    public String getTypeName(Column col) {
        if (!StringUtils.isEmpty(col.getTypeName())) {
            return this.appendSize(col, col.getTypeName());
        }
        if (col.isAutoAssigned() && this.autoAssignTypeName != null) {
            return this.appendSize(col, this.autoAssignTypeName);
        }
        if (col.getVersionStrategy() != null && ColumnVersionStrategy.isVersionStrategyColumn(col.getVersionStrategy()) && this.supportsDBVersionStrategy(col)) {
            return this.appendSize(col, this.versionColumnTableSyntax);
        }
        return this.appendSize(col, this.getTypeName(col.getType()));
    }

    public boolean supportsDBVersionStrategy(Column col) {
        if (this.versionColumnTableSyntax != null) {
            return true;
        }
        throw new StoreException(_loc.get("strategy-not-supported", col.getVersionStrategy().getAlias(), col.getFullName(), this.platform));
    }

    public String getVersionColumn(Column column, String tableAlias) {
        if (ColumnVersionStrategy.isVersionStrategyColumn(column.getVersionStrategy()) && this.versionColumnTableSyntax != null) {
            StringBuffer versionColumn = new StringBuffer();
            if ("row-change-timestamp".equals(column.getVersionStrategy().getAlias())) {
                return versionColumn.append(this.versionColumnTimestampSyntax).append(" ").append(tableAlias).toString();
            }
            if ("row-change-long".equals(column.getVersionStrategy().getAlias())) {
                return versionColumn.append(this.versionColumnIntegerSyntax).append(" ").append(tableAlias).toString();
            }
        }
        return column.toString();
    }

    public boolean verifyProductVersion(String productName, String productVersion) {
        return productName.equalsIgnoreCase(this.databaseProductName) && productVersion.equalsIgnoreCase(this.databaseProductVersion);
    }

    public boolean validateDBSpecificBatchProcess(boolean disableBatch, RowImpl row, Column[] autoAssign, OpenJPAStateManager sm, ClassMapping cmd) {
        VersionStrategy strategy;
        boolean rtnValue = disableBatch;
        if (!disableBatch && sm != null && (strategy = cmd.getVersion().getStrategy()) != null && ColumnVersionStrategy.isVersionStrategyColumn(strategy)) {
            rtnValue = true;
        }
        return rtnValue;
    }

    public void setDefaultBatchLimit(int limit) {
        super.setBatchLimit(limit);
    }

    public String getProductName() {
        return this.databaseProductName;
    }

    public String getProductVersion() {
        return this.databaseProductVersion;
    }
}

