/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.meta.strats;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;

public abstract class ColumnVersionStrategy
extends org.apache.openjpa.jdbc.meta.strats.ColumnVersionStrategy {
    public static final String ROW_CHANGE_TIMESTAMP = "row-change-timestamp";
    public static final String ROW_CHANGE_LONG = "row-change-long";

    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        if (!ColumnVersionStrategy.isVersionStrategyColumn(this)) {
            Column[] cols = this.vers.getColumns();
            ColumnIO io = this.vers.getColumnIO();
            Object initial = this.nextVersion(null);
            Row row = rm.getRow(this.vers.getClassMapping().getTable(), 1, sm, true);
            for (int i = 0; i < cols.length; ++i) {
                if (!io.isInsertable(i, initial == null)) continue;
                row.setObject(cols[i], initial);
            }
            Object nextVersion = initial;
            sm.setNextVersion(nextVersion);
        }
    }

    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Object nextVersion = null;
        Column[] cols = this.vers.getColumns();
        if (cols == null || cols.length == 0 || !sm.isDirty() && !sm.isVersionUpdateRequired()) {
            return;
        }
        Object curVersion = sm.getVersion();
        if (!ColumnVersionStrategy.isVersionStrategyColumn(this)) {
            nextVersion = this.nextVersion(curVersion);
        }
        Row row = rm.getRow(this.vers.getClassMapping().getTable(), 0, sm, true);
        row.setFailedObject(sm.getManagedInstance());
        for (int i = 0; i < cols.length; ++i) {
            if (curVersion != null && sm.isVersionCheckRequired()) {
                row.whereObject(cols[i], curVersion);
            }
            if (!this.vers.getColumnIO().isUpdatable(i, nextVersion == null) || ColumnVersionStrategy.isVersionStrategyColumn(this)) continue;
            row.setObject(cols[i], nextVersion);
        }
        if (nextVersion != null) {
            sm.setNextVersion(nextVersion);
        }
    }

    public static boolean isVersionStrategyColumn(VersionStrategy strategy) {
        return ROW_CHANGE_TIMESTAMP.equals(strategy.getAlias()) || ROW_CHANGE_LONG.equals(strategy.getAlias());
    }
}

