/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.kernel;

import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.openjpa.jdbc.kernel.AbstractUpdateManager;
import org.apache.openjpa.jdbc.kernel.BatchingOperationOrderUpdateManager;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.OpenJPAException;

public class OperationOrderUpdateManager
extends BatchingOperationOrderUpdateManager {
    private static final Localizer _loc = Localizer.forPackage(OperationOrderUpdateManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection flush(Collection states, JDBCStore store) {
        Connection conn = store.getConnection();
        try {
            PreparedStatementManager psMgr = this.newPreparedStatementManager(store, conn);
            Collection collection = this.flush(states, store, psMgr);
            return collection;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException se) {}
        }
    }

    private Collection flush(Collection states, JDBCStore store, PreparedStatementManager psMgr) {
        Collection exceps;
        LinkedList customs;
        block8: {
            RowManager rowMgr = this.newRowManager();
            customs = new LinkedList();
            exceps = psMgr.getExceptions();
            Iterator itr = states.iterator();
            while (itr.hasNext()) {
                exceps = this.populateRowManager((OpenJPAStateManager)itr.next(), rowMgr, store, exceps, customs);
            }
            Log log = store.getConfiguration().getLog("openjpa.jdbc.SQL");
            exceps = this.flush(rowMgr, psMgr, exceps);
            try {
                OpenJPAStateManager sm2 = null;
                for (OpenJPAStateManager sm2 : states) {
                    VersionStrategy strategy = ((ClassMapping)sm2.getMetaData()).getVersion().getStrategy();
                    if (strategy == null || !ColumnVersionStrategy.isVersionStrategyColumn(strategy) || rowMgr.getRow(((ClassMapping)sm2.getMetaData()).getTable(), 2, sm2, false) != null) continue;
                    strategy.checkVersion(sm2, store, true);
                }
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block8;
                log.error(_loc.get("generated-version-field-exception"), e);
            }
        }
        Iterator itr = customs.iterator();
        while (itr.hasNext()) {
            try {
                ((AbstractUpdateManager.CustomMapping)itr.next()).execute(store);
            }
            catch (SQLException se) {
                exceps = this.addException(exceps, SQLExceptions.getStore(se, this.dict));
            }
            catch (OpenJPAException ke) {
                exceps = this.addException(exceps, ke);
            }
        }
        return exceps;
    }

    public void setBatchLimit(int limit) {
        this.dict.setBatchLimit(limit);
    }
}

