/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.conf;

import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.jdbc.kernel.WsJpaJDBCFetchConfigurationImpl;
import com.ibm.ws.persistence.kernel.conf.WsJpaTaskNameManagerImpl;
import com.ibm.ws.persistence.kernel.conf.WsJpaTasksFactory;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.StringValue;

public class WsJpaJDBCConfigurationImpl
extends JDBCConfigurationImpl
implements WsJpaJDBCConfiguration {
    public StringValue collectionId = this.addString("jdbc.CollectionId");
    private boolean _runPDQ;
    private Properties _pdqProperties;
    private static Method newPdqPessimisticLockManager;
    public PluginValue accessIntentPlugin;
    public PluginValue pureQueryPlugin;
    private WsJpaTaskNameManagerImpl taskNameManager;

    public WsJpaJDBCConfigurationImpl() {
        this(true);
    }

    public WsJpaJDBCConfigurationImpl(boolean loadGlobals) {
        this(true, loadGlobals);
    }

    public WsJpaJDBCConfigurationImpl(boolean derivations, boolean loadGlobals) {
        super(false, false);
        String[] aliases = new String[]{"default", WsJpaTasksFactory.class.getName()};
        this.accessIntentPlugin = this.addPlugin("AccessIntent", true);
        this.accessIntentPlugin.setAliases(aliases);
        this.accessIntentPlugin.setDefault(aliases[0]);
        this.accessIntentPlugin.setString(aliases[0]);
        this.accessIntentPlugin.setAliasListComprehensive(true);
        this.accessIntentPlugin.setInstantiatingGetter("getTasksFactory");
        this.taskNameManager = new WsJpaTaskNameManagerImpl(this);
        if (derivations) {
            ProductDerivations.beforeConfigurationLoad(this);
        }
        if (loadGlobals) {
            this.loadGlobals();
        }
    }

    public LockManager newLockManagerInstance() {
        if (!this._runPDQ) {
            return super.newLockManagerInstance();
        }
        LockManager rtnValue = null;
        if (this.getLockManager().equals("pessimistic")) {
            try {
                rtnValue = (LockManager)newPdqPessimisticLockManager.invoke(null, (Object[])null);
            }
            catch (Exception exception) {}
        } else {
            rtnValue = (LockManager)this.lockManagerPlugin.instantiate(LockManager.class, this, false);
        }
        return rtnValue;
    }

    public boolean runPDQ() {
        return this._runPDQ;
    }

    public void setRunPDQ(boolean newValue) {
        this._runPDQ = newValue;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId.setString(collectionId);
    }

    public String getCollectionId() {
        return this.collectionId.getString();
    }

    public void setPdqProperties(Properties pdqProperties) {
        this._pdqProperties = pdqProperties;
    }

    public Properties getPdqProperties() {
        return this._pdqProperties;
    }

    public WsJpaTasksFactory getTasksFactory() {
        if (this.accessIntentPlugin.get() == null) {
            this.accessIntentPlugin.instantiate(WsJpaTasksFactory.class, this);
        }
        return (WsJpaTasksFactory)this.accessIntentPlugin.get();
    }

    public JDBCFetchConfiguration getAccessIntentFetchConfiguration(JDBCFetchConfiguration fetch, String entityClassName) {
        WsJpaTasksFactory.IsolationLockValue newValue;
        String taskName = this.taskNameManager.getTSRTaskName();
        if (taskName != null && (newValue = this.getTasksFactory().getTasksEntities(taskName, entityClassName)) != null) {
            int newIsolation = newValue.getIsolationLevel();
            int newReadLock = newValue.getReadLock();
            if (!((WsJpaJDBCFetchConfigurationImpl)fetch).isCreateForAccessIntent()) {
                WsJpaJDBCFetchConfigurationImpl wsFetch = (WsJpaJDBCFetchConfigurationImpl)fetch.clone();
                wsFetch.setCreateForAccessIntent();
                fetch = wsFetch;
            }
            if (newIsolation != -1 && fetch.getIsolation() != newIsolation) {
                fetch.setIsolation(newIsolation);
            }
            if (newReadLock != -1 && fetch.getReadLockLevel() != newReadLock) {
                fetch.setReadLockLevel(newReadLock);
            }
        }
        return fetch;
    }

    public String toString() {
        return "WsJpaJDBCConfigurationImpl@" + Integer.toHexString(System.identityHashCode(this)) + ": PDQ " + (this._runPDQ ? "enabled" : "disabled") + ": AccessIntent Task=" + this.accessIntentPlugin.getString();
    }

    static {
        try {
            Class<?> helper = Class.forName("com.ibm.ws.persistence.pdq.conf.PDQConfigurationHelper", false, Thread.currentThread().getContextClassLoader());
            newPdqPessimisticLockManager = helper.getMethod("newPdqPessimisticLockManager", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

