/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.persistence.pdq;

import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenerator;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMetaXMLHandler;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMetas;
import java.util.HashMap;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class WsJpaDB2Gen {
    private static final Localizer _loc = Localizer.forPackage(WsJpaDB2Gen.class);
    static String _puName = null;
    static String _collection = null;
    static String _url = null;
    static String _user = null;
    static String _pw = null;
    static boolean _singlePackage = false;
    static String _packageName = null;

    public static void main(String[] args) throws Exception {
        WsJpaDB2Gen.generate(args);
    }

    public static void generate(String[] args) throws Exception {
        WsJpaDB2Gen.generate(args, null);
    }

    public static void generate(String[] args, ClassLoader loader) throws Exception {
        WsJpaDB2Gen.validateInput(args);
        System.out.println("Start WsJpaDB2Gen for " + _puName + "...");
        WsJpaDB2Gen.generateSQL(loader);
        System.out.println("Done!");
    }

    private static void validateInput(String[] args) {
        int i = 0;
        HashMap<String, String> parms = new HashMap<String, String>();
        do {
            String name;
            if (args.length == 0) {
                WsJpaDB2Gen.printUsageAndExit();
            }
            if (!args[i].startsWith("-")) {
                WsJpaDB2Gen.printUsageAndExit();
            }
            if ((name = args[i++].substring(1)).equals("help")) {
                WsJpaDB2Gen.printUsageAndExit();
            }
            if (args.length % 2 != 0) {
                WsJpaDB2Gen.printUsageAndExit();
            }
            if (args[i].startsWith("-")) {
                WsJpaDB2Gen.printUsageAndExit();
            }
            String value = args[i++];
            parms.put(name, value);
        } while (i != args.length);
        _collection = (String)parms.get("collection");
        if (_collection == null) {
            _collection = "NULLID";
        }
        _url = (String)parms.get("url");
        _user = (String)parms.get("user");
        _pw = (String)parms.get("pw");
        _packageName = (String)parms.get("package");
        if (_packageName != null) {
            if (_packageName.length() > StaticSQLGenUtil.PACKAGE_NAME_LENGTH) {
                System.out.println("Package name: " + _packageName + " exceeds 7 characters");
                WsJpaDB2Gen.printUsageAndExit();
            }
            _singlePackage = true;
        }
        if ((_puName = (String)parms.get("pu")) == null) {
            System.out.println("Persistent unit Name is required");
            WsJpaDB2Gen.printUsageAndExit();
        }
    }

    private static void generateSQL(ClassLoader loader) throws Exception {
        StaticSQLGenerator sqlGen = new StaticSQLGenerator(_puName, _collection, _url, _user, _pw, _singlePackage, _packageName);
        sqlGen.generateSQL();
        PDQMetas metas = sqlGen.getPDQMetas();
        Log _logs = sqlGen.getLog();
        try {
            String xmlFileName = PDQMetaXMLHandler.generatePDQMetaXML(metas, _puName, loader);
            if (_logs.isTraceEnabled()) {
                _logs.trace(_loc.get("total-sql", new Object[]{metas.getCount(), xmlFileName}));
            }
        }
        catch (Exception e) {
            if (_logs.isTraceEnabled()) {
                _logs.trace(_loc.get("total-sql", new Object[]{metas.getCount(), "null"}));
            }
            throw e;
        }
    }

    private static void printUsageAndExit() {
        System.out.println("Syntax: WSDB2GEN -pu <puName> [Flags] \n  Where \n               puName           Persistence-unit name defined in the\n                                persistence.xml\n\n  -collection  collectionId     Collection id assigned to package names.\n                                Default is NULLID. \n\n  -url         type 2 or        The URL is used to validate generated sql.\n               type 4 url       If url option is specified, if overrides\n                                the url value in the persistence.xml.\n\n                                If the url is type 4, userid and password \n\n                                are required for connection. If the url is \n                                type2, userid and password are not required.\n\n  -user        user             The userid to connect to target datebase.\n                                If user option is specified, it overrides\n                                the user value in the persistence.xml.\n\n  -pw          password         The password to connect to target datebase.\n                                If password option is specified, it\n                                overrides the value in the persistence.xml.\n\n  -package     packageName      A name of 7 or fewer characters for the\n                                package name. If specified, all SQL for\n                                the application will be generated into\n                                this single package. If package option\n                                is not specified, then multiple packages\n                                will be created; one for each entity\n                                class. If the first 7 characters are not\n                                unique, the package name will be changed\n                                to ensure uniqueness.\n\n  -help\n");
        System.exit(1);
    }

    public static void run(String[] args, ClassLoader loader) throws Exception {
        WsJpaDB2Gen.generate(args, loader);
    }
}

