/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl;

import com.ibm.idl.DirectiveEntry;
import com.ibm.idl.IDLID;
import com.ibm.idl.IncludeEntry;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.ModuleEntry;
import com.ibm.idl.ParseException;
import com.ibm.idl.Parser;
import com.ibm.idl.PragmaEntry;
import com.ibm.idl.PragmaHandler;
import com.ibm.idl.RepositoryID;
import com.ibm.idl.Scanner;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.Token;
import com.ibm.idl.Util;
import com.ibm.idl.constExpr.BinaryExpr;
import com.ibm.idl.constExpr.BooleanNot;
import com.ibm.idl.constExpr.EvaluationException;
import com.ibm.idl.constExpr.Expression;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Preprocessor {
    public Hashtable pragmaHash = new Hashtable();
    private Vector pragmaHandlers = new Vector();
    private boolean lastWasMacroID = false;
    private Parser parser;
    private Scanner scanner;
    private Hashtable symbols;
    private Vector macros;
    private long lineNumberForNoMacroExpand = -1L;
    private Stack alreadyProcessedABranch = new Stack();
    Token token;
    private static String indent = "";
    private Stack branchInModule = new Stack();
    private Hashtable modulePragma = new Hashtable();

    Preprocessor() {
    }

    void init(Parser parser) {
        this.parser = parser;
        this.symbols = parser.symbols;
        this.macros = parser.macros;
    }

    protected Object clone() {
        return new Preprocessor();
    }

    Token process(Token token) throws IOException, ParseException {
        this.token = token;
        this.scanner = this.parser.scanner;
        this.scanner.escapedOK = false;
        try {
            switch (this.token.type) {
                case 307: {
                    this.include();
                    break;
                }
                case 302: {
                    this.ifClause();
                    break;
                }
                case 303: {
                    this.ifdef(false);
                    break;
                }
                case 304: {
                    this.ifdef(true);
                    break;
                }
                case 305: {
                    this.elseClause();
                    break;
                }
                case 306: {
                    this.elif();
                    break;
                }
                case 308: {
                    this.endif();
                    break;
                }
                case 300: {
                    this.define();
                    break;
                }
                case 301: {
                    this.undefine();
                    break;
                }
                case 311: {
                    this.pragma();
                    break;
                }
                case 313: {
                    if (!this.parser.noWarn) {
                        ParseException.warning(this.scanner, Util.getMessage("Preprocessor.unknown", this.token.name));
                    }
                }
                default: {
                    this.scanner.skipLineComment();
                    this.token = this.scanner.getToken();
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.scanner.escapedOK = true;
            throw iOException;
        }
        catch (ParseException parseException) {
            this.scanner.escapedOK = true;
            throw parseException;
        }
        this.scanner.escapedOK = true;
        return this.token;
    }

    private void include() throws IOException, ParseException {
        this.match(307);
        IncludeEntry includeEntry = this.parser.stFactory.includeEntry(this.parser.currentModule);
        includeEntry.sourceFile(this.scanner.fileEntry());
        includeEntry.lineNumber(this.scanner.currentLineNumber());
        this.scanner.fileEntry().addInclude(includeEntry);
        if (this.token.type == 204) {
            this.include2(includeEntry);
        } else if (this.token.type == 110) {
            this.include3(includeEntry);
        } else {
            int[] nArray = new int[]{204, 110};
            throw ParseException.syntaxError(this.scanner, nArray, this.token.type);
        }
        if (this.parser.currentModule instanceof ModuleEntry) {
            ((ModuleEntry)this.parser.currentModule).addContained(includeEntry);
        } else if (this.parser.currentModule instanceof InterfaceEntry) {
            ((InterfaceEntry)this.parser.currentModule).addContained(includeEntry);
        }
    }

    private void include2(IncludeEntry includeEntry) throws IOException, ParseException {
        includeEntry.name('\"' + this.token.name + '\"');
        this.include4(includeEntry, this.token.name);
        this.match(204);
    }

    private void include3(IncludeEntry includeEntry) throws IOException, ParseException {
        if (this.token.type != 110) {
            this.match(110);
        } else {
            try {
                String string = this.getUntil('>');
                this.token = this.scanner.getToken();
                includeEntry.name('<' + string + '>');
                this.include4(includeEntry, string);
                this.match(111);
            }
            catch (IOException iOException) {
                throw ParseException.syntaxError(this.scanner, ">", "EOF");
            }
        }
    }

    private void include4(IncludeEntry includeEntry, String string) throws IOException, ParseException {
        try {
            boolean bl = this.parser.currentModule == this.parser.topLevelModule;
            includeEntry.absFilename(Util.getAbsolutePath(string, this.parser.paths));
            this.scanner.scanIncludedFile(includeEntry, this.getFilename(string), bl);
        }
        catch (IOException iOException) {
            ParseException.generic(this.scanner, iOException.toString());
        }
    }

    private void define() throws IOException, ParseException {
        int n = this.token.lineNumber;
        this.match(300);
        if (this.token.equals(60)) {
            String string = this.scanner.getStringToEOL();
            this.symbols.put(this.token.name, string.trim());
            DirectiveEntry directiveEntry = this.parser.stFactory.directiveEntry(this.parser.currentModule);
            directiveEntry.typeName("define");
            directiveEntry.name(this.token.name);
            directiveEntry.sourceFile(this.scanner.fileEntry());
            directiveEntry.lineNumber(n);
            directiveEntry.data(string.trim());
            if (this.parser.currentModule instanceof ModuleEntry) {
                ((ModuleEntry)this.parser.currentModule).addContained(directiveEntry);
            }
            this.match(60);
        } else if (this.token.equals(61)) {
            this.symbols.put(this.token.name, '(' + this.scanner.getStringToEOL().trim());
            this.macros.addElement(this.token.name);
            this.match(61);
        } else {
            throw ParseException.syntaxError(this.scanner, 60, this.token.type);
        }
    }

    private void undefine() throws IOException, ParseException {
        int n = this.token.lineNumber;
        this.match(301);
        if (this.token.equals(60)) {
            this.symbols.remove(this.token.name);
            this.macros.removeElement(this.token.name);
            DirectiveEntry directiveEntry = this.parser.stFactory.directiveEntry(this.parser.currentModule);
            directiveEntry.typeName("undef");
            directiveEntry.name(this.token.name);
            directiveEntry.data("");
            directiveEntry.sourceFile(this.scanner.fileEntry());
            directiveEntry.lineNumber(n);
            if (this.parser.currentModule instanceof ModuleEntry) {
                ((ModuleEntry)this.parser.currentModule).addContained(directiveEntry);
            }
        } else {
            throw ParseException.syntaxError(this.scanner, 60, this.token.type);
        }
        this.match(60);
    }

    private void ifClause() throws IOException, ParseException {
        DirectiveEntry directiveEntry = this.parser.stFactory.directiveEntry(this.parser.currentModule);
        directiveEntry.typeName("if");
        directiveEntry.name(this.scanner.scanStringToEOL());
        directiveEntry.data("");
        directiveEntry.sourceFile(this.scanner.fileEntry());
        directiveEntry.lineNumber(this.token.lineNumber);
        if (this.parser.currentModule instanceof ModuleEntry) {
            ((ModuleEntry)this.parser.currentModule).addContained(directiveEntry);
            this.branchInModule.push(new Boolean(true));
        } else {
            this.branchInModule.push(new Boolean(false));
        }
        this.match(302);
        this.constExpr();
    }

    private void elseClause() throws IOException, ParseException {
        if (this.alreadyProcessedABranch.empty()) {
            throw ParseException.elseNoIf(this.scanner);
        }
        DirectiveEntry directiveEntry = this.parser.stFactory.directiveEntry(this.parser.currentModule);
        directiveEntry.typeName("else");
        directiveEntry.name(" ");
        directiveEntry.data("");
        directiveEntry.sourceFile(this.scanner.fileEntry());
        directiveEntry.lineNumber(this.token.lineNumber);
        boolean bl = (Boolean)this.branchInModule.peek();
        if (bl) {
            if (this.parser.currentModule instanceof ModuleEntry) {
                ((ModuleEntry)this.parser.currentModule).addContained(directiveEntry);
            } else if (this.parser.currentModule instanceof InterfaceEntry) {
                ((InterfaceEntry)this.parser.currentModule).addContained(directiveEntry);
            }
        }
        if (((Boolean)this.alreadyProcessedABranch.peek()).booleanValue()) {
            this.skipToEndif();
        } else {
            this.alreadyProcessedABranch.pop();
            this.alreadyProcessedABranch.push(new Boolean(true));
            this.token = this.scanner.getToken();
        }
    }

    private void constExpr() throws IOException, ParseException {
        SymtabEntry symtabEntry = new SymtabEntry(this.parser.currentModule);
        symtabEntry.container(this.parser.currentModule);
        this.parser.parsingConditionalExpr = true;
        Expression expression = this.booleanConstExpr(symtabEntry);
        this.parser.parsingConditionalExpr = false;
        boolean bl = expression.value() instanceof Boolean ? (Boolean)expression.value() : ((Number)expression.value()).longValue() != 0L;
        this.alreadyProcessedABranch.push(new Boolean(bl));
        if (!bl) {
            this.skipToEndiforElse();
        }
    }

    Expression booleanConstExpr(SymtabEntry symtabEntry) throws IOException, ParseException {
        Expression expression = this.orExpr(null, symtabEntry);
        try {
            expression.evaluate();
        }
        catch (EvaluationException evaluationException) {
            ParseException.evaluationError(this.scanner, evaluationException.toString());
        }
        return expression;
    }

    private Expression orExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.andExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.andExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(134)) {
            this.match(this.token.type);
            binaryExpr = this.parser.exprFactory.booleanOr(expression, null);
            binaryExpr.rep(expression.rep() + " || ");
            return this.orExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression andExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.notExpr(symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.notExpr(symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(135)) {
            this.match(this.token.type);
            binaryExpr = this.parser.exprFactory.booleanAnd(expression, null);
            binaryExpr.rep(expression.rep() + " && ");
            return this.andExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression notExpr(SymtabEntry symtabEntry) throws IOException, ParseException {
        Expression expression;
        if (this.token.equals(129)) {
            this.match(129);
            expression = this.parser.exprFactory.booleanNot(this.definedExpr(symtabEntry));
            expression.rep("!" + ((BooleanNot)expression).operand().rep());
        } else {
            expression = this.definedExpr(symtabEntry);
        }
        return expression;
    }

    private Expression definedExpr(SymtabEntry symtabEntry) throws IOException, ParseException {
        if ((this.token.equals(60) || this.token.equals(61)) && this.token.name.equals("defined")) {
            boolean bl = this.token.equals(61);
            this.match(this.token.type, true);
            if (!bl && this.token.equals(108)) {
                bl = true;
                this.match(108, true);
            }
            boolean bl2 = this.symbols.containsKey(this.token.name);
            this.match(60);
            if (bl) {
                this.match(109);
            }
            Boolean bl3 = new Boolean(bl2);
            if (bl2) {
                return this.parser.exprFactory.terminal("TRUE", bl3);
            }
            return this.parser.exprFactory.terminal("FALSE", bl3);
        }
        return this.equalityExpr(null, symtabEntry);
    }

    private Expression equalityExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            this.parser.token = this.token;
            expression = this.parser.constExp(symtabEntry);
            this.token = this.parser.token;
        } else {
            binaryExpr = (BinaryExpr)expression;
            this.parser.token = this.token;
            Expression expression2 = this.parser.constExp(symtabEntry);
            this.token = this.parser.token;
            binaryExpr.right(expression2);
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(130)) {
            this.match(this.token.type);
            binaryExpr = this.parser.exprFactory.equal(expression, null);
            binaryExpr.rep(expression.rep() + " == ");
            return this.equalityExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(131)) {
            this.match(this.token.type);
            binaryExpr = this.parser.exprFactory.notEqual(expression, null);
            binaryExpr.rep(expression.rep() + " != ");
            return this.equalityExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(111)) {
            this.match(this.token.type);
            binaryExpr = this.parser.exprFactory.greaterThan(expression, null);
            binaryExpr.rep(expression.rep() + " > ");
            return this.equalityExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(132)) {
            this.match(this.token.type);
            binaryExpr = this.parser.exprFactory.greaterEqual(expression, null);
            binaryExpr.rep(expression.rep() + " >= ");
            return this.equalityExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(110)) {
            this.match(this.token.type);
            binaryExpr = this.parser.exprFactory.lessThan(expression, null);
            binaryExpr.rep(expression.rep() + " < ");
            return this.equalityExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(133)) {
            this.match(this.token.type);
            binaryExpr = this.parser.exprFactory.lessEqual(expression, null);
            binaryExpr.rep(expression.rep() + " <= ");
            return this.equalityExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    Expression primaryExpr(SymtabEntry symtabEntry) throws IOException, ParseException {
        Expression expression = null;
        switch (this.token.type) {
            case 60: {
                expression = this.parser.exprFactory.terminal("0", BigInteger.valueOf(0L));
                this.token = this.scanner.getToken();
                break;
            }
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                expression = this.parser.literal(symtabEntry);
                this.token = this.parser.token;
                break;
            }
            case 108: {
                this.match(108);
                expression = this.booleanConstExpr(symtabEntry);
                this.match(109);
                expression.rep('(' + expression.rep() + ')');
                break;
            }
            default: {
                int[] nArray = new int[]{205, 108};
                throw ParseException.syntaxError(this.scanner, nArray, this.token.type);
            }
        }
        return expression;
    }

    private void ifdef(boolean bl) throws IOException, ParseException {
        int n = this.token.lineNumber;
        if (bl) {
            this.match(304);
        } else {
            this.match(303);
        }
        if (this.token.equals(60)) {
            DirectiveEntry directiveEntry = this.parser.stFactory.directiveEntry(this.parser.currentModule);
            if (bl) {
                directiveEntry.typeName("ifndef");
            } else {
                directiveEntry.typeName("ifdef");
            }
            directiveEntry.name(this.token.name);
            directiveEntry.sourceFile(this.scanner.fileEntry());
            directiveEntry.lineNumber(n);
            directiveEntry.data("");
            if (this.parser.currentModule instanceof ModuleEntry) {
                ((ModuleEntry)this.parser.currentModule).addContained(directiveEntry);
                this.branchInModule.push(new Boolean(true));
            } else {
                this.branchInModule.push(new Boolean(false));
            }
            if (bl && this.symbols.containsKey(this.token.name) || !bl && !this.symbols.containsKey(this.token.name)) {
                this.alreadyProcessedABranch.push(new Boolean(false));
                this.skipToEndiforElse();
            } else {
                this.alreadyProcessedABranch.push(new Boolean(true));
                this.match(60);
            }
        } else {
            throw ParseException.syntaxError(this.scanner, 60, this.token.type);
        }
    }

    private void elif() throws IOException, ParseException {
        if (this.alreadyProcessedABranch.empty()) {
            throw ParseException.elseNoIf(this.scanner);
        }
        DirectiveEntry directiveEntry = this.parser.stFactory.directiveEntry(this.parser.currentModule);
        directiveEntry.typeName("elif");
        directiveEntry.name(this.scanner.scanStringToEOL());
        directiveEntry.sourceFile(this.scanner.fileEntry());
        directiveEntry.lineNumber(this.token.lineNumber);
        directiveEntry.data("");
        boolean bl = (Boolean)this.branchInModule.peek();
        if (bl) {
            if (this.parser.currentModule instanceof ModuleEntry) {
                ((ModuleEntry)this.parser.currentModule).addContained(directiveEntry);
            } else if (this.parser.currentModule instanceof InterfaceEntry) {
                ((InterfaceEntry)this.parser.currentModule).addContained(directiveEntry);
            }
        }
        if (((Boolean)this.alreadyProcessedABranch.peek()).booleanValue()) {
            this.skipToEndif();
        } else {
            this.match(306);
            this.constExpr();
        }
    }

    private void endif() throws IOException, ParseException {
        if (this.alreadyProcessedABranch.empty()) {
            throw ParseException.endNoIf(this.scanner);
        }
        this.alreadyProcessedABranch.pop();
        DirectiveEntry directiveEntry = this.parser.stFactory.directiveEntry(this.parser.currentModule);
        directiveEntry.typeName("endif");
        directiveEntry.name(" ");
        directiveEntry.sourceFile(this.scanner.fileEntry());
        directiveEntry.lineNumber(this.token.lineNumber);
        directiveEntry.data("");
        boolean bl = (Boolean)this.branchInModule.pop();
        if (bl) {
            if (this.parser.currentModule instanceof ModuleEntry) {
                ((ModuleEntry)this.parser.currentModule).addContained(directiveEntry);
            } else if (this.parser.currentModule instanceof InterfaceEntry) {
                ((InterfaceEntry)this.parser.currentModule).addContained(directiveEntry);
            }
        }
        this.token = this.scanner.getToken();
    }

    private void skipToEndiforElse() throws IOException, ParseException {
        while (!(this.token.equals(308) || this.token.equals(305) || this.token.equals(306))) {
            if (this.token.equals(303) || this.token.equals(304)) {
                this.alreadyProcessedABranch.push(new Boolean(true));
                this.getToEndif();
                continue;
            }
            this.token = this.scanner.skipUntil('#');
        }
        this.process(this.token);
    }

    private void skipToEndif() throws IOException, ParseException {
        while (!this.token.equals(308)) {
            this.token = this.scanner.skipUntil('#');
            if (!this.token.equals(303) && !this.token.equals(304)) continue;
            this.alreadyProcessedABranch.push(new Boolean(true));
            this.getToEndif();
        }
        this.alreadyProcessedABranch.pop();
        DirectiveEntry directiveEntry = this.parser.stFactory.directiveEntry(this.parser.currentModule);
        directiveEntry.typeName("endif");
        directiveEntry.name(" ");
        directiveEntry.data("");
        directiveEntry.sourceFile(this.scanner.fileEntry());
        directiveEntry.lineNumber(this.token.lineNumber);
        if (this.parser.currentModule instanceof ModuleEntry) {
            ((ModuleEntry)this.parser.currentModule).addContained(directiveEntry);
        }
        this.match(308);
    }

    private void getToEndif() throws IOException, ParseException {
        while (!this.token.equals(308)) {
            this.token = this.scanner.skipUntil('#');
            if (!this.token.equals(303) && !this.token.equals(304)) continue;
            this.alreadyProcessedABranch.push(new Boolean(true));
            this.getToEndif();
        }
        this.alreadyProcessedABranch.pop();
        this.match(308);
    }

    private void pragma() throws IOException, ParseException {
        this.match(311);
        String string = this.token.name;
        this.scanner.escapedOK = true;
        this.match(60);
        PragmaEntry pragmaEntry = this.parser.stFactory.pragmaEntry(this.parser.currentModule);
        pragmaEntry.name(string);
        pragmaEntry.sourceFile(this.scanner.fileEntry());
        pragmaEntry.lineNumber(this.scanner.currentLineNumber());
        pragmaEntry.data(this.scanner.currentLine());
        if (this.parser.currentModule instanceof ModuleEntry) {
            ((ModuleEntry)this.parser.currentModule).addContained(pragmaEntry);
        } else if (this.parser.currentModule instanceof InterfaceEntry) {
            ((InterfaceEntry)this.parser.currentModule).addContained(pragmaEntry);
        }
        if (string.equals("ID")) {
            this.idPragma();
        } else if (string.equals("prefix")) {
            this.prefixPragma();
        } else if (string.equals("version")) {
            this.versionPragma();
        } else {
            this.otherPragmas(string, this.tokenToString());
            this.token = this.scanner.getToken();
        }
        this.scanner.escapedOK = false;
    }

    private void idPragma() throws IOException, ParseException {
        this.parser.token = this.token;
        this.parser.isModuleLegalType(true);
        SymtabEntry symtabEntry = new SymtabEntry();
        SymtabEntry symtabEntry2 = this.parser.scopedName(this.parser.currentModule, symtabEntry);
        this.parser.isModuleLegalType(false);
        if (symtabEntry2 == symtabEntry) {
            this.scanner.skipLineComment();
            this.token = this.scanner.getToken();
        } else {
            String string;
            this.token = this.parser.token;
            String string2 = this.token.name;
            boolean bl = this.pragmaHash.containsKey("ID " + symtabEntry2.fullName());
            if (!bl && (string = (String)this.pragmaHash.get("VERSION " + symtabEntry2.fullName())) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ": ");
                String string3 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                if (string3 == null || !string3.equals(string)) {
                    bl = true;
                }
            }
            if (bl) {
                if (!(symtabEntry2 instanceof ModuleEntry)) {
                    ParseException.badRepIDAlreadyAssigned(this.scanner, symtabEntry2.name());
                }
            } else if (!RepositoryID.hasValidForm(string2)) {
                ParseException.badRepIDForm(this.scanner, string2);
            } else {
                symtabEntry2.repositoryID(new RepositoryID(string2));
                this.pragmaHash.put("ID " + symtabEntry2.fullName(), string2);
                if (symtabEntry2 instanceof ModuleEntry) {
                    string = (String)this.modulePragma.get(symtabEntry2.fullName());
                    if (string != null && !symtabEntry2.repositoryID().toString().equals(string)) {
                        ParseException.badRepIDAlreadyAssignedForModule(this.scanner, symtabEntry2.fullName());
                    } else {
                        this.modulePragma.put(symtabEntry2.fullName(), symtabEntry2.repositoryID().toString());
                    }
                }
            }
            this.match(204);
        }
    }

    private void prefixPragma() throws IOException, ParseException {
        String string = this.token.name;
        this.match(204);
        ((IDLID)Parser.repIDStack.peek()).prefix(string);
        ((IDLID)Parser.repIDStack.peek()).name("");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setModulePragma(ModuleEntry moduleEntry) {
        String string = (String)this.modulePragma.get(moduleEntry.fullName());
        if (string != null) {
            if (!Parser.repIDStack.peek().toString().equals(string)) {
                ParseException.badRepIDAlreadyAssignedForModule(this.scanner, moduleEntry.fullName());
                return;
            }
        }
        this.modulePragma.put(moduleEntry.fullName(), Parser.repIDStack.peek().toString());
    }

    private void versionPragma() throws IOException, ParseException {
        this.parser.token = this.token;
        SymtabEntry symtabEntry = new SymtabEntry();
        SymtabEntry symtabEntry2 = this.parser.scopedName(this.parser.currentModule, symtabEntry);
        if (symtabEntry2 == symtabEntry) {
            this.scanner.skipLineComment();
            this.token = this.scanner.getToken();
        } else {
            String string;
            this.token = this.parser.token;
            String string2 = this.token.name;
            boolean bl = this.pragmaHash.containsKey("VERSION " + symtabEntry2.fullName());
            if (!bl && (string = (String)this.pragmaHash.get("ID " + symtabEntry2.fullName())) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ": ");
                String string3 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                if (string3 == null || !string3.equals(string2)) {
                    bl = true;
                }
            }
            if (bl) {
                ParseException.badRepIDAlreadyAssigned(this.scanner, symtabEntry2.name());
            } else {
                if (symtabEntry2.repositoryID() instanceof IDLID) {
                    ((IDLID)symtabEntry2.repositoryID()).version(string2);
                }
                this.pragmaHash.put("VERSION " + symtabEntry2.fullName(), string2);
            }
            this.match(203);
        }
    }

    void registerPragma(PragmaHandler pragmaHandler) {
        this.pragmaHandlers.addElement(pragmaHandler);
    }

    private void otherPragmas(String string, String string2) throws IOException {
        PragmaHandler pragmaHandler;
        for (int i = this.pragmaHandlers.size() - 1; i >= 0 && !(pragmaHandler = (PragmaHandler)this.pragmaHandlers.elementAt(i)).process(string, string2); --i) {
        }
    }

    String currentToken() {
        return this.tokenToString();
    }

    SymtabEntry getEntryForName(String string) {
        boolean bl = false;
        boolean bl2 = false;
        if (string.startsWith("::")) {
            bl2 = true;
            string = string.substring(2);
        }
        int n = string.indexOf("::");
        while (n >= 0) {
            bl = true;
            string = string.substring(0, n) + '/' + string.substring(n + 2);
            n = string.indexOf("::");
        }
        SymtabEntry symtabEntry = null;
        SymtabEntry symtabEntry2 = this.parser.currentModule;
        if (bl2) {
            symtabEntry2 = null;
        }
        symtabEntry = this.parser.resolve(string, symtabEntry2, true, true, false);
        return symtabEntry;
    }

    String getStringToEOL() throws IOException {
        return this.scanner.getStringToEOL();
    }

    String getUntil(char c) throws IOException {
        return this.scanner.getUntil(c);
    }

    private String tokenToString() {
        if (this.token.equals(61)) {
            this.lastWasMacroID = true;
            return this.token.name;
        }
        if (this.token.equals(60)) {
            return this.token.name;
        }
        return this.token.toString();
    }

    String nextToken() throws IOException {
        if (this.lastWasMacroID) {
            this.lastWasMacroID = false;
            return "(";
        }
        this.token = this.scanner.getToken();
        return this.tokenToString();
    }

    SymtabEntry scopedName() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        SymtabEntry symtabEntry = null;
        try {
            if (this.token.equals(124)) {
                bl = true;
            } else if (this.token.equals(18)) {
                string = "Object";
                this.match(18);
            } else if (this.token.type == 42) {
                string = "ValueBase";
                this.match(42);
            } else {
                string = this.token.name;
                this.match(60);
            }
            while (this.token.equals(124)) {
                this.match(124);
                bl2 = true;
                string = string != null ? string + '/' + this.token.name : this.token.name;
                this.match(60);
            }
            SymtabEntry symtabEntry2 = this.parser.currentModule;
            if (bl) {
                symtabEntry2 = null;
            }
            symtabEntry = this.parser.resolve(string, symtabEntry2, true, true, false);
        }
        catch (ParseException parseException) {
            symtabEntry = null;
        }
        return symtabEntry;
    }

    void skipToEOL() throws IOException {
        this.scanner.skipLineComment();
    }

    String skipUntil(char c) throws IOException {
        if (!this.lastWasMacroID || c != '(') {
            this.token = this.scanner.skipUntil(c);
        }
        return this.tokenToString();
    }

    void parseException(String string) {
        if (!this.parser.noWarn) {
            ParseException.warning(this.scanner, string);
        }
    }

    String expandMacro(String string, Token token) throws IOException, ParseException {
        this.token = token;
        Vector vector = this.getParmValues();
        this.scanner.scanString(string + '\n');
        Vector vector2 = new Vector();
        this.macro(vector2);
        if (vector.size() < vector2.size()) {
            throw ParseException.syntaxError(this.scanner, 104, 109);
        }
        if (vector.size() > vector2.size()) {
            throw ParseException.syntaxError(this.scanner, 109, 104);
        }
        string = this.scanner.getStringToEOL();
        for (int i = 0; i < vector2.size(); ++i) {
            string = this.replaceAll(string, (String)vector2.elementAt(i), (String)vector.elementAt(i));
        }
        return this.removeDoublePound(string);
    }

    private void miniMatch(int n) throws ParseException {
        if (!this.token.equals(n)) {
            throw ParseException.syntaxError(this.scanner, n, this.token.type);
        }
    }

    private Vector getParmValues() throws IOException, ParseException {
        Vector<String> vector = new Vector<String>();
        if (this.token.equals(60)) {
            this.match(60);
            this.miniMatch(108);
        } else if (!this.token.equals(61)) {
            throw ParseException.syntaxError(this.scanner, 60, this.token.type);
        }
        if (!this.token.equals(109)) {
            vector.addElement(this.scanner.getUntil(',', ')').trim());
            this.token = this.scanner.getToken();
            this.macroParmValues(vector);
        }
        return vector;
    }

    private void macroParmValues(Vector vector) throws IOException, ParseException {
        while (!this.token.equals(109)) {
            this.miniMatch(104);
            vector.addElement(this.scanner.getUntil(',', ')').trim());
            this.token = this.scanner.getToken();
        }
    }

    private void macro(Vector vector) throws IOException, ParseException {
        this.match(this.token.type);
        this.match(108);
        this.macroParms(vector);
        this.miniMatch(109);
    }

    private void macroParms(Vector vector) throws IOException, ParseException {
        if (!this.token.equals(109)) {
            vector.addElement(this.token.name);
            this.match(60);
            this.macroParms2(vector);
        }
    }

    private void macroParms2(Vector vector) throws IOException, ParseException {
        while (!this.token.equals(109)) {
            this.match(104);
            vector.addElement(this.token.name);
            this.match(60);
        }
    }

    private String replaceAll(String string, String string2, String string3) {
        int n = 0;
        while (n != -1) {
            if ((n = string.indexOf(string2, n)) == -1) continue;
            if (!this.embedded(string, n, n + string2.length())) {
                string = n > 0 && string.charAt(n) == '#' ? string.substring(0, n) + '\"' + string3 + '\"' + string.substring(n + string2.length()) : string.substring(0, n) + string3 + string.substring(n + string2.length());
            }
            n += string3.length();
        }
        return string;
    }

    private boolean embedded(String string, int n, int n2) {
        int n3;
        boolean bl = false;
        int n4 = n == 0 ? 32 : (int)string.charAt(n - 1);
        int n5 = n3 = n2 >= string.length() - 1 ? 32 : (int)string.charAt(n2);
        bl = n4 >= 97 && n4 <= 122 || n4 >= 65 && n4 <= 90 ? true : (n3 >= 97 && n3 <= 122 || n3 >= 65 && n3 <= 90 || n3 >= 48 && n3 <= 57 || n3 == 95 ? true : this.inQuotes(string, n));
        return bl;
    }

    private boolean inQuotes(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n2;
        }
        return n2 % 2 != 0;
    }

    private String removeDoublePound(String string) {
        int n = 0;
        while (n != -1) {
            if ((n = string.indexOf("##", n)) == -1) continue;
            int n2 = n - 1;
            int n3 = n + 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 >= string.length()) {
                n3 = string.length() - 1;
            }
            while (n2 > 0 && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t')) {
                --n2;
            }
            while (n3 < string.length() - 1 && (string.charAt(n3) == ' ' || string.charAt(n3) == '\t')) {
                ++n3;
            }
            string = string.substring(0, n2 + 1) + string.substring(n3);
        }
        return string;
    }

    private String getFilename(String string) throws FileNotFoundException {
        String string2 = null;
        File file = new File(string);
        if (file.canRead()) {
            string2 = string;
        } else {
            Enumeration enumeration = this.parser.paths.elements();
            while (!file.canRead() && enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement() + File.separatorChar + string;
                file = new File(string2);
            }
            if (!file.canRead()) {
                throw new FileNotFoundException(string);
            }
        }
        return string2;
    }

    private void match(int n) throws IOException, ParseException {
        this.match(n, false);
    }

    private void match(int n, boolean bl) throws IOException, ParseException {
        String string;
        if (!this.token.equals(n)) {
            throw ParseException.syntaxError(this.scanner, n, this.token.type);
        }
        if (this.token.equals(303) || this.token.equals(304) || this.token.equals(300) || this.token.equals(301)) {
            this.lineNumberForNoMacroExpand = this.scanner.currentLineNumber();
        }
        this.token = this.scanner.getToken();
        if (this.lineNumberForNoMacroExpand != (long)this.scanner.currentLineNumber()) {
            this.lineNumberForNoMacroExpand = -1L;
        } else {
            bl = true;
            if (this.token.type < 60) {
                this.token.type = 60;
            }
        }
        if (this.token.type <= 61 && !bl && (string = (String)this.symbols.get(this.token.name)) != null && !string.equals("")) {
            if (this.macros.contains(this.token.name)) {
                this.scanner.scanString(this.expandMacro(string, this.token));
                this.token = this.scanner.getToken();
            } else {
                this.scanner.scanString(string);
                this.token = this.scanner.getToken();
            }
        }
    }

    private void issueTokenWarnings() {
        if (this.parser.noWarn) {
            return;
        }
    }

    void openScope(SymtabEntry symtabEntry) {
        for (int i = this.pragmaHandlers.size() - 1; i >= 0; --i) {
            PragmaHandler pragmaHandler = (PragmaHandler)this.pragmaHandlers.elementAt(i);
            pragmaHandler.openScope(symtabEntry);
        }
    }

    void closeScope(SymtabEntry symtabEntry) {
        for (int i = this.pragmaHandlers.size() - 1; i >= 0; --i) {
            PragmaHandler pragmaHandler = (PragmaHandler)this.pragmaHandlers.elementAt(i);
            pragmaHandler.closeScope(symtabEntry);
        }
    }
}

