/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.rmi.registry;

import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.rmi.activation.ActivateFailedException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.SkeletonMismatchException;
import java.rmi.server.SkeletonNotFoundException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.rmi.registry.AtomicNameParser;
import org.apache.harmony.jndi.provider.rmi.registry.BindingEnumeration;
import org.apache.harmony.jndi.provider.rmi.registry.NameClassPairEnumeration;
import org.apache.harmony.jndi.provider.rmi.registry.RegistryContextFactory;
import org.apache.harmony.jndi.provider.rmi.registry.RemoteReference;
import org.apache.harmony.jndi.provider.rmi.registry.RemoteReferenceWrapper;

public class RegistryContext
implements Context,
Referenceable {
    public static final String SECURITY_MANAGER = "java.naming.rmi.security.manager";
    public static final String CLIENT_SOCKET_FACTORY = "org.apache.harmony.jndi.provider.rmi.registry.clientSocketFactory";
    public static final String RMI_URL_PREFIX = "rmi:";
    public static final String ADDRESS_TYPE = "URL";
    protected static final NameParser nameParser = new AtomicNameParser();
    protected String host;
    protected int port;
    protected RMIClientSocketFactory csf;
    protected Hashtable<Object, Object> environment;
    protected Registry registry;
    protected Reference reference;

    public RegistryContext(String string, int n, Hashtable<?, ?> hashtable) throws NamingException {
        String string2;
        this.host = string;
        this.port = n;
        Hashtable<Object, Object> hashtable2 = this.environment = hashtable != null ? (Hashtable)hashtable.clone() : new Hashtable();
        if (this.environment.get(SECURITY_MANAGER) != null) {
            this.installSecurityManager();
        }
        if ((string2 = (String)this.environment.get(CLIENT_SOCKET_FACTORY)) == null) {
            this.csf = null;
        } else {
            try {
                this.csf = (RMIClientSocketFactory)Class.forName(string2, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (ConfigurationException)new ConfigurationException(Messages.getString("jndi.79")).initCause(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw (ConfigurationException)new ConfigurationException(Messages.getString("jndi.79")).initCause(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (NoPermissionException)new NoPermissionException(Messages.getString("jndi.79")).initCause(illegalAccessException);
            }
        }
        this.registry = this.getRegistry(string, n, this.csf);
        this.reference = null;
    }

    protected RegistryContext(RegistryContext registryContext) {
        this.host = registryContext.host;
        this.port = registryContext.port;
        this.csf = registryContext.csf;
        this.environment = (Hashtable)registryContext.environment.clone();
        this.registry = registryContext.registry;
        this.reference = registryContext.reference;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.cloneContext();
        }
        String string = this.getMyComponents(name);
        try {
            return this.getObjectInstance(string, this.registry.lookup(string));
        }
        catch (NotBoundException notBoundException) {
            throw (NameNotFoundException)new NameNotFoundException(Messages.getString("jndi.7A", string)).initCause(notBoundException);
        }
        catch (RemoteException remoteException) {
            throw (NamingException)this.newNamingException(remoteException).fillInStackTrace();
        }
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(new CompositeName(string));
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException(Messages.getString("jndi.7B"));
        }
        String string = this.getMyComponents(name);
        try {
            this.registry.bind(string, this.getStateToBind(string, object));
        }
        catch (AlreadyBoundException alreadyBoundException) {
            throw (NameAlreadyBoundException)new NameAlreadyBoundException(Messages.getString("jndi.7C", string)).initCause(alreadyBoundException);
        }
        catch (RemoteException remoteException) {
            throw (NamingException)this.newNamingException(remoteException).fillInStackTrace();
        }
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.bind(new CompositeName(string), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException(Messages.getString("jndi.7D"));
        }
        String string = this.getMyComponents(name);
        try {
            this.registry.rebind(string, this.getStateToBind(string, object));
        }
        catch (RemoteException remoteException) {
            throw (NamingException)this.newNamingException(remoteException).fillInStackTrace();
        }
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.rebind(new CompositeName(string), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException(Messages.getString("jndi.7E"));
        }
        String string = this.getMyComponents(name);
        try {
            this.registry.unbind(string);
        }
        catch (NotBoundException notBoundException) {
        }
        catch (RemoteException remoteException) {
            throw (NamingException)this.newNamingException(remoteException).fillInStackTrace();
        }
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unbind(new CompositeName(string));
    }

    @Override
    public Context createSubcontext(Name name) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(Messages.getString("jndi.7F"));
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(new CompositeName(string));
    }

    @Override
    public void destroySubcontext(Name name) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(Messages.getString("jndi.7F"));
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(new CompositeName(string));
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.bind(name2, this.lookup(name));
        this.unbind(name);
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.rename(new CompositeName(string), new CompositeName(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (name.isEmpty()) {
            try {
                return new NameClassPairEnumeration(this.registry.list());
            }
            catch (RemoteException remoteException) {
                throw (NamingException)this.newNamingException(remoteException).fillInStackTrace();
            }
        }
        Object object = this.lookup(name);
        if (object instanceof Context) {
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = ((Context)object).list("");
                return namingEnumeration;
            }
            finally {
                ((Context)object).close();
            }
        }
        throw new NotContextException(Messages.getString("jndi.80", name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.list(new CompositeName(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            try {
                return new BindingEnumeration(this.registry.list(), this);
            }
            catch (RemoteException remoteException) {
                throw (NamingException)this.newNamingException(remoteException).fillInStackTrace();
            }
        }
        Object object = this.lookup(name);
        if (object instanceof Context) {
            try {
                NamingEnumeration<Binding> namingEnumeration = ((Context)object).listBindings("");
                return namingEnumeration;
            }
            finally {
                ((Context)object).close();
            }
        }
        throw new NotContextException(Messages.getString("jndi.80", name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.listBindings(new CompositeName(string));
    }

    @Override
    public NameParser getNameParser(Name name) {
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.getNameParser(new CompositeName(string));
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        return ((Name)name2.clone()).addAll(name);
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return this.composeName(new CompositeName(string), new CompositeName(string2)).toString();
    }

    @Override
    public String getNameInNamespace() {
        return "";
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NoPermissionException {
        if (string.equals(SECURITY_MANAGER)) {
            this.installSecurityManager();
        }
        return this.environment.put(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) {
        return this.environment.remove(string);
    }

    @Override
    public void close() {
        this.environment = null;
        this.registry = null;
    }

    @Override
    public Reference getReference() throws NamingException {
        if (this.reference == null) {
            if (this.host == null || this.host.equals("localhost")) {
                throw new ConfigurationException(Messages.getString("jndi.81"));
            }
            this.reference = new Reference(RegistryContext.class.getName(), new StringRefAddr(ADDRESS_TYPE, "rmi://" + this.host + (this.port > 0 ? ":" + this.port : "")), RegistryContextFactory.class.getName(), null);
        }
        return (Reference)this.reference.clone();
    }

    protected void setReference(Reference reference) {
        this.reference = reference;
    }

    protected RegistryContext cloneContext() {
        return new RegistryContext(this);
    }

    protected String getMyComponents(Name name) {
        if (name instanceof CompositeName) {
            return name.get(0);
        }
        return name.toString();
    }

    protected Remote getStateToBind(String string, Object object) throws NamingException, RemoteException {
        if ((object = NamingManager.getStateToBind(object, new CompositeName().add(string), this, this.environment)) instanceof Remote) {
            return (Remote)object;
        }
        if (object instanceof Reference) {
            return new RemoteReferenceWrapper((Reference)object);
        }
        if (object instanceof Referenceable) {
            return new RemoteReferenceWrapper(((Referenceable)object).getReference());
        }
        throw new IllegalArgumentException(Messages.getString("jndi.82"));
    }

    protected Object getObjectInstance(String string, Remote remote) throws NamingException, RemoteException {
        Remote remote2 = remote instanceof RemoteReference ? ((RemoteReference)remote).getReference() : remote;
        try {
            return NamingManager.getObjectInstance(remote2, new CompositeName().add(string), this, this.environment);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw (NamingException)new NamingException(Messages.getString("jndi.83")).initCause(exception);
        }
    }

    protected NamingException newNamingException(Throwable throwable) {
        NoPermissionException noPermissionException;
        NamingException namingException = throwable instanceof AccessException ? new NoPermissionException() : (throwable instanceof ConnectException ? new ServiceUnavailableException() : (throwable instanceof ConnectIOException || throwable instanceof ExportException || throwable instanceof MarshalException || throwable instanceof UnmarshalException ? new CommunicationException() : (throwable instanceof ActivateFailedException || throwable instanceof NoSuchObjectException || throwable instanceof SkeletonMismatchException || throwable instanceof SkeletonNotFoundException || throwable instanceof StubNotFoundException || throwable instanceof UnknownHostException ? new ConfigurationException() : (noPermissionException = throwable instanceof ServerException ? this.newNamingException(throwable.getCause()) : new NamingException()))));
        if (noPermissionException.getCause() == null) {
            noPermissionException.initCause(throwable);
        }
        return noPermissionException;
    }

    protected void installSecurityManager() throws NoPermissionException {
        if (!(System.getSecurityManager() instanceof RMISecurityManager)) {
            try {
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (SecurityException securityException) {
                throw (NoPermissionException)new NoPermissionException(Messages.getString("jndi.84")).initCause(securityException);
            }
        }
    }

    protected Registry getRegistry(String string, int n, RMIClientSocketFactory rMIClientSocketFactory) throws NamingException {
        try {
            return rMIClientSocketFactory != null ? LocateRegistry.getRegistry(string, n, rMIClientSocketFactory) : (string != null ? (n != 0 ? LocateRegistry.getRegistry(string, n) : LocateRegistry.getRegistry(string)) : (n != 0 ? LocateRegistry.getRegistry(n) : LocateRegistry.getRegistry()));
        }
        catch (RemoteException remoteException) {
            throw (NamingException)new NamingException().initCause(remoteException);
        }
    }
}

