/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

public class TransportMgr {
    public static int sendReceiveUDP(String string, int n, byte[] byArray, int n2, byte[] byArray2, int n3, int n4) throws DomainProtocolException, SocketTimeoutException, SecurityException {
        byte[] byArray3 = null;
        InetAddress inetAddress = null;
        DatagramSocket datagramSocket = null;
        DatagramPacket datagramPacket = null;
        DatagramPacket datagramPacket2 = null;
        try {
            byArray3 = ProviderMgr.parseIpStr(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DomainProtocolException(Messages.getString("jndi.40"));
        }
        try {
            datagramSocket = new DatagramSocket();
            inetAddress = InetAddress.getByAddress(byArray3);
            datagramSocket.connect(inetAddress, n);
            datagramPacket2 = new DatagramPacket(byArray, n2, inetAddress, n);
            datagramSocket.setSoTimeout(n4);
            datagramSocket.send(datagramPacket2);
            datagramPacket = new DatagramPacket(byArray2, n3, inetAddress, n);
            datagramSocket.receive(datagramPacket);
        }
        catch (IllegalStateException illegalStateException) {
            throw new DomainProtocolException(Messages.getString("jndi.41"), illegalStateException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw socketTimeoutException;
        }
        catch (IOException iOException) {
            throw new DomainProtocolException(Messages.getString("jndi.41"), iOException);
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
        if (datagramPacket != null) {
            return datagramPacket.getLength();
        }
        throw new DomainProtocolException(Messages.getString("jndi.42"));
    }

    public static int sendReceiveTCP(String string, int n, byte[] byArray, int n2, byte[] byArray2, int n3, int n4) throws DomainProtocolException, SocketTimeoutException, SecurityException {
        byte[] byArray3 = null;
        InetAddress inetAddress = null;
        Socket socket = null;
        InputStream inputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        byte[] byArray4 = new byte[2];
        int n5 = -1;
        try {
            byArray3 = ProviderMgr.parseIpStr(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DomainProtocolException(Messages.getString("jndi.40"));
        }
        try {
            inetAddress = InetAddress.getByAddress(byArray3);
            socket = new Socket(inetAddress, n);
            socket.setSoTimeout(n4);
            bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            ProviderMgr.write16Int(n2, byArray4, 0);
            bufferedOutputStream.write(byArray4, 0, 2);
            bufferedOutputStream.write(byArray, 0, n2);
            bufferedOutputStream.flush();
            inputStream = socket.getInputStream();
            inputStream.read(byArray4, 0, 2);
            int n6 = ProviderMgr.parse16Int(byArray4, 0);
            if (n6 > n3) {
                throw new DomainProtocolException(Messages.getString("jndi.43"));
            }
            n5 = inputStream.read(byArray2, 0, n6);
            if (n5 != n6) {
                throw new DomainProtocolException(Messages.getString("jndi.44"));
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new DomainProtocolException(Messages.getString("jndi.41"), illegalStateException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw socketTimeoutException;
        }
        catch (IOException iOException) {
            throw new DomainProtocolException(Messages.getString("jndi.41"), iOException);
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return n5;
    }

    public static InetAddress getIPByName_OS(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inetAddress;
    }
}

