/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.StringTokenizer;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderConstants;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

public class ResourceRecord {
    private String name;
    private int rrType;
    private int rrClass;
    private long ttl;
    private Object rData;

    public ResourceRecord() {
    }

    public ResourceRecord(String string, int n, int n2, long l, Object object) {
        this.name = string;
        this.rrType = n;
        this.rrClass = n2;
        this.ttl = l;
        this.rData = object;
    }

    public int writeBytes(byte[] byArray, int n) throws DomainProtocolException {
        int n2 = n;
        if (byArray == null) {
            throw new DomainProtocolException(Messages.getString("jndi.32"));
        }
        n2 = ProviderMgr.writeName(this.name, byArray, n2);
        n2 = ProviderMgr.write16Int(this.rrType, byArray, n2);
        n2 = ProviderMgr.write16Int(this.rrClass, byArray, n2);
        n2 = ProviderMgr.write32Int(this.ttl, byArray, n2);
        if (this.rrType == 2 || this.rrType == 5 || this.rrType == 12) {
            int n3 = n2;
            n2 += 2;
            n2 = ProviderMgr.writeName((String)this.rData, byArray, n2);
            ProviderMgr.write16Int(n2 - 2 - n3, byArray, n3);
        } else if (this.rrType == 1) {
            byte[] byArray2 = ProviderMgr.parseIpStr((String)this.rData);
            n2 = ProviderMgr.write16Int(byArray2.length, byArray, n2);
            for (byte by : byArray2) {
                byArray[n2++] = by;
            }
        } else if (this.rrType == 6) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)this.rData, " ");
            int n4 = n2;
            if (stringTokenizer.countTokens() != 7) {
                throw new DomainProtocolException(Messages.getString("jndi.35"));
            }
            n2 += 2;
            String string = stringTokenizer.nextToken();
            n2 = ProviderMgr.writeName(string, byArray, n2);
            string = stringTokenizer.nextToken();
            n2 = ProviderMgr.writeName(string, byArray, n2);
            try {
                for (int i = 0; i < 5; ++i) {
                    string = stringTokenizer.nextToken();
                    n2 = ProviderMgr.write32Int(Long.parseLong(string), byArray, n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DomainProtocolException(Messages.getString("jndi.36"), numberFormatException);
            }
            ProviderMgr.write16Int(n2 - 2 - n4, byArray, n4);
        } else if (this.rrType == 15) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)this.rData, " ");
            int n5 = n2;
            if (stringTokenizer.countTokens() != 2) {
                throw new DomainProtocolException(Messages.getString("jndi.37"));
            }
            n2 += 2;
            String string = stringTokenizer.nextToken();
            try {
                ProviderMgr.write16Int(Integer.parseInt(string), byArray, n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DomainProtocolException(Messages.getString("jndi.38"), numberFormatException);
            }
            string = stringTokenizer.nextToken();
            n2 = ProviderMgr.writeName(string, byArray, n2);
            ProviderMgr.write16Int(n2 - 2 - n5, byArray, n5);
        } else if (this.rrType == 13) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)this.rData, " ");
            int n6 = n2;
            if (stringTokenizer.countTokens() != 2) {
                throw new DomainProtocolException(Messages.getString("jndi.39"));
            }
            n2 += 2;
            for (int i = 0; i < 2; ++i) {
                String string = stringTokenizer.nextToken();
                n2 = ProviderMgr.writeCharString(string, byArray, n2);
            }
            ProviderMgr.write16Int(n2 - 2 - n6, byArray, n6);
        } else if (this.rrType == 16) {
            int n7 = n2;
            StringTokenizer stringTokenizer = new StringTokenizer((String)this.rData, " ");
            n2 += 2;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.getBytes().length > 255) {
                    throw new DomainProtocolException(Messages.getString("jndi.3A"));
                }
                n2 = ProviderMgr.writeCharString(string, byArray, n2);
            }
            if (n2 - 2 - n7 > 65535) {
                throw new DomainProtocolException(Messages.getString("jndi.3B"));
            }
            ProviderMgr.write16Int(n2 - 2 - n7, byArray, n7);
        } else if (this.rrType == 33) {
            String string;
            StringTokenizer stringTokenizer = new StringTokenizer((String)this.rData, " ");
            int n8 = n2;
            n2 += 2;
            if (stringTokenizer.countTokens() != 4) {
                throw new DomainProtocolException(Messages.getString("jndi.3C"));
            }
            try {
                for (int i = 0; i < 3; ++i) {
                    string = stringTokenizer.nextToken();
                    n2 = ProviderMgr.write16Int(Integer.parseInt(string), byArray, n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DomainProtocolException(Messages.getString("jndi.3D"), numberFormatException);
            }
            string = stringTokenizer.nextToken();
            n2 = ProviderMgr.writeName(string, byArray, n2);
            ProviderMgr.write16Int(n2 - 2 - n8, byArray, n8);
        } else {
            if (!(this.rData instanceof byte[])) {
                throw new DomainProtocolException(Messages.getString("jndi.3E", this.rrType));
            }
            byte[] byArray3 = (byte[])this.rData;
            n2 = ProviderMgr.write16Int(byArray3.length, byArray, n2);
            for (byte by : byArray3) {
                byArray[n2++] = by;
            }
        }
        return n2;
    }

    public static int parseRecord(byte[] byArray, int n, ResourceRecord resourceRecord) throws DomainProtocolException {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer();
        Object object = null;
        if (resourceRecord == null) {
            throw new NullPointerException(Messages.getString("jndi.3F"));
        }
        n2 = ProviderMgr.parseName(byArray, n2, stringBuffer);
        resourceRecord.setName(ProviderMgr.normalizeName(stringBuffer.toString()));
        int n3 = ProviderMgr.parse16Int(byArray, n2);
        resourceRecord.setRRType(n3);
        resourceRecord.setRRClass(ProviderMgr.parse16Int(byArray, n2 += 2));
        resourceRecord.setTtl(ProviderMgr.parse32Int(byArray, n2 += 2));
        int n4 = ProviderMgr.parse16Int(byArray, n2 += 4);
        n2 += 2;
        if (n3 == 2 || n3 == 5 || n3 == 12) {
            StringBuffer stringBuffer2 = new StringBuffer();
            n2 = ProviderMgr.parseName(byArray, n2, stringBuffer2);
            object = ProviderMgr.normalizeName(stringBuffer2.toString());
        } else if (n3 == 1) {
            byte[] byArray2 = new byte[4];
            for (int i = 0; i < 4; ++i) {
                byArray2[i] = byArray[n2 + i];
            }
            object = ProviderMgr.getIpStr(byArray2);
            n2 += 4;
        } else if (n3 == 15) {
            StringBuffer stringBuffer3 = new StringBuffer();
            int n5 = ProviderMgr.parse16Int(byArray, n2);
            n2 += 2;
            n2 = ProviderMgr.parseName(byArray, n2, stringBuffer3);
            object = "" + n5 + " " + ProviderMgr.normalizeName(stringBuffer3.toString());
        } else if (n3 == 6) {
            StringBuffer stringBuffer4 = new StringBuffer();
            StringBuffer stringBuffer5 = new StringBuffer();
            n2 = ProviderMgr.parseName(byArray, n2, stringBuffer4);
            n2 = ProviderMgr.parseName(byArray, n2, stringBuffer5);
            long l = ProviderMgr.parse32Int(byArray, n2);
            long l2 = ProviderMgr.parse32Int(byArray, n2 += 4);
            long l3 = ProviderMgr.parse32Int(byArray, n2 += 4);
            long l4 = ProviderMgr.parse32Int(byArray, n2 += 4);
            long l5 = ProviderMgr.parse32Int(byArray, n2 += 4);
            n2 += 4;
            object = ProviderMgr.normalizeName(stringBuffer4.toString()) + " " + ProviderMgr.normalizeName(stringBuffer5.toString()) + " " + l + " " + l2 + " " + l3 + " " + l4 + " " + l5;
        } else if (n3 == 16) {
            StringBuffer stringBuffer6 = new StringBuffer();
            int n6 = n2;
            while (true) {
                int n7;
                if (n2 - n6 + (n7 = ProviderMgr.parse8Int(byArray, n2++)) > n4) {
                    --n2;
                    break;
                }
                if (stringBuffer6.length() > 0) {
                    stringBuffer6.append(' ');
                }
                stringBuffer6.append(new String(byArray, n2, n7));
                n2 += n7;
            }
            object = stringBuffer6.toString();
        } else if (n3 == 13) {
            StringBuffer stringBuffer7 = new StringBuffer();
            n2 = ProviderMgr.parseCharString(byArray, n2, stringBuffer7);
            stringBuffer7.append(" ");
            n2 = ProviderMgr.parseCharString(byArray, n2, stringBuffer7);
            object = stringBuffer7.toString();
        } else if (n3 == 33) {
            StringBuffer stringBuffer8 = new StringBuffer();
            int n8 = ProviderMgr.parse16Int(byArray, n2);
            int n9 = ProviderMgr.parse16Int(byArray, n2 += 2);
            int n10 = ProviderMgr.parse16Int(byArray, n2 += 2);
            n2 += 2;
            n2 = ProviderMgr.parseName(byArray, n2, stringBuffer8);
            object = "" + n8 + " " + n9 + " " + n10 + " " + ProviderMgr.normalizeName(stringBuffer8.toString());
        } else {
            object = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                ((byte[])object)[i] = byArray[n2++];
            }
        }
        resourceRecord.setRData(object);
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(" ");
        stringBuffer.append(ProviderConstants.rrTypeNames[this.rrType]);
        stringBuffer.append(" ");
        stringBuffer.append(this.rrClass);
        stringBuffer.append(" ");
        stringBuffer.append("TTL=" + this.ttl);
        stringBuffer.append(" ");
        stringBuffer.append(this.rData.toString());
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Object getRData() {
        return this.rData;
    }

    public void setRData(Object object) {
        this.rData = object;
    }

    public int getRRClass() {
        return this.rrClass;
    }

    public void setRRClass(int n) {
        this.rrClass = n;
    }

    public int getRRType() {
        return this.rrType;
    }

    public void setRRType(int n) {
        this.rrType = n;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long l) {
        this.ttl = l;
    }
}

