/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.Message;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;
import org.apache.harmony.jndi.provider.dns.QuestionRecord;
import org.apache.harmony.jndi.provider.dns.ResolverCache;
import org.apache.harmony.jndi.provider.dns.ResourceRecord;
import org.apache.harmony.jndi.provider.dns.SList;
import org.apache.harmony.jndi.provider.dns.TransportMgr;

public class Resolver
implements Runnable {
    private static final int MSG_MAX_BYTES = 512;
    private static final Random rndGen = new Random();
    private int initialTimeout;
    private int timeoutRetries;
    private boolean authoritativeAnswerDesired;
    private boolean recursionDesired;
    private int threadNumberLimit;
    private final ArrayList<ThreadListEntry> resolverThreads = new ArrayList();
    private final ArrayList<ThreadListEntry> hostnamesToResolve = new ArrayList();
    private final Object threadListSemaphore = new ThreadListSemaphore();

    public Resolver() {
        this(1000, 4, 7, false, true);
    }

    public Resolver(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.initialTimeout = n;
        this.timeoutRetries = n2;
        this.threadNumberLimit = n3;
        this.authoritativeAnswerDesired = bl;
        this.recursionDesired = bl2;
    }

    public int getThreadNumberLimit() {
        return this.threadNumberLimit;
    }

    public void setThreadNumberLimit(int n) {
        this.threadNumberLimit = n;
    }

    public boolean isAuthoritativeAnswerDesired() {
        return this.authoritativeAnswerDesired;
    }

    public void setAuthoritativeAnswerDesired(boolean bl) {
        this.authoritativeAnswerDesired = bl;
    }

    public int getInitialTimeout() {
        return this.initialTimeout;
    }

    public void setInitialTimeout(int n) {
        this.initialTimeout = n;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public void setRecursionDesired(boolean bl) {
        this.recursionDesired = bl;
    }

    public int getTimeoutRetries() {
        return this.timeoutRetries;
    }

    public void setTimeoutRetries(int n) {
        this.timeoutRetries = n;
    }

    public Enumeration<ResourceRecord> lookup(String string, int[] nArray, int[] nArray2) throws SecurityException, NameNotFoundException, ServiceUnavailableException, DomainProtocolException {
        ResolverCache resolverCache = ResolverCache.getInstance();
        Vector<QuestionRecord> vector = new Vector<QuestionRecord>();
        Vector<ResourceRecord> vector2 = new Vector<ResourceRecord>();
        if (string == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (nArray == null) {
            throw new NullPointerException(Messages.getString("jndi.6B"));
        }
        if (nArray2 == null) {
            throw new NullPointerException(Messages.getString("jndi.6C"));
        }
        for (int n : nArray2) {
            for (int n2 : nArray) {
                QuestionRecord questionRecord = new QuestionRecord(string, n2, n);
                vector.addElement(questionRecord);
            }
        }
        block9: for (int i = 0; i < vector.size(); ++i) {
            String string2;
            Enumeration<ResourceRecord> enumeration;
            QuestionRecord questionRecord = (QuestionRecord)vector.elementAt(i);
            String string3 = questionRecord.getQName();
            Message message = null;
            Object var11_17 = null;
            AnalysisReport analysisReport = null;
            Hashtable<SList.Server, Object> hashtable = new Hashtable<SList.Server, Object>();
            if (questionRecord.getQType() != 255 && questionRecord.getQClass() != 255 && (enumeration = resolverCache.get(questionRecord)).hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(enumeration.nextElement());
                }
                continue;
            }
            if (string3 != null && !string3.equals(".")) {
                string2 = string3;
                while (string2.startsWith("_")) {
                    string2 = ProviderMgr.getParentName(string2);
                }
            } else {
                string2 = ".";
            }
            message = Resolver.createMessageForSending(string3, questionRecord.getQType(), questionRecord.getQClass());
            while (true) {
                boolean bl = false;
                try {
                    Message message2 = this.queryServers(message, string2, hashtable, false);
                    if (message2 != null) {
                        ResourceRecord resourceRecord;
                        int domainProtocolException;
                        analysisReport = this.analyzeAnswer(message, message2);
                        if (!analysisReport.messageWasTruncated) {
                            for (domainProtocolException = 0; domainProtocolException < analysisReport.extraRecords.size(); ++domainProtocolException) {
                                resourceRecord = analysisReport.extraRecords.elementAt(domainProtocolException);
                                resolverCache.put(resourceRecord);
                            }
                        }
                        if (analysisReport.completeAnswerWasReceived) {
                            for (domainProtocolException = 0; domainProtocolException < analysisReport.records.size(); ++domainProtocolException) {
                                resourceRecord = analysisReport.records.elementAt(domainProtocolException);
                                vector2.addElement(resourceRecord);
                                resolverCache.put(resourceRecord);
                            }
                            continue block9;
                        }
                        if (analysisReport.nameError) {
                            throw new NameNotFoundException(Messages.getString("jndi.6D", string));
                        }
                        if (analysisReport.aliasInfoWasReceived) {
                            Enumeration<ResourceRecord> enumeration2;
                            string3 = analysisReport.newName;
                            questionRecord.setQName(string3);
                            if (questionRecord.getQType() != 255 && questionRecord.getQClass() != 255 && (enumeration2 = resolverCache.get(questionRecord)).hasMoreElements()) {
                                while (enumeration2.hasMoreElements()) {
                                    vector2.addElement(enumeration2.nextElement());
                                }
                                continue block9;
                            }
                            string2 = string3 != null && !string3.equals(".") ? string3 : ".";
                            hashtable = new Hashtable();
                            for (domainProtocolException = 0; domainProtocolException < analysisReport.records.size(); ++domainProtocolException) {
                                vector2.addElement(analysisReport.records.elementAt(domainProtocolException));
                            }
                            message = Resolver.createMessageForSending(string3, questionRecord.getQType(), questionRecord.getQClass());
                        }
                        if (analysisReport.delegationArrived) {
                            domainProtocolException = -1;
                            int n = ProviderMgr.getMatchingCount(string3, string2);
                            for (int j = 0; j < analysisReport.delegationZones.size(); ++j) {
                                String string4 = analysisReport.delegationZones.elementAt(j);
                                int n3 = ProviderMgr.getMatchingCount(string3, string4);
                                if (n3 <= n) continue;
                                domainProtocolException = j;
                                n = n3;
                            }
                            if (domainProtocolException != -1) {
                                string2 = analysisReport.delegationZones.elementAt(domainProtocolException);
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    if (!bl) continue;
                    if (string2.equals(".")) continue block9;
                    string2 = ProviderMgr.getParentName(string2);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw nameNotFoundException;
                }
                catch (DomainProtocolException domainProtocolException) {
                    throw domainProtocolException;
                }
            }
        }
        return vector2.elements();
    }

    public Enumeration<ResourceRecord> list(String string) throws NamingException {
        int n;
        Object object;
        ResourceRecord resourceRecord;
        Enumeration<Object> enumeration;
        Vector<ResourceRecord> vector = new Vector<ResourceRecord>();
        Message message = null;
        Message message2 = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        int[] nArray = new int[1];
        byte[] byArray = new byte[512];
        byte[] byArray2 = new byte[65536];
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        ResolverCache resolverCache = ResolverCache.getInstance();
        if (string == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (string.startsWith("_")) {
            int n2 = string.indexOf(46);
            if (n2 != -1) {
                string2 = string.substring(0, n2);
                string = string.length() > n2 ? string.substring(n2 + 1, string.length()) : ".";
            } else {
                string = ".";
            }
        }
        Enumeration<ResourceRecord> enumeration2 = this.lookup(string, new int[]{2}, new int[]{255});
        message = Resolver.createMessageForSending(string, 252, 255);
        int n3 = message.writeBytes(byArray, 0);
        while (enumeration2.hasMoreElements()) {
            ResourceRecord resourceRecord2 = enumeration2.nextElement();
            if (resourceRecord2.getRRType() == 2) {
                hashSet.add(resourceRecord2.getRData());
                nArray[0] = resourceRecord2.getRRClass();
                continue;
            }
            if (resourceRecord2.getRRType() != 6 || !((StringTokenizer)(enumeration = new StringTokenizer((String)resourceRecord2.getRData(), " "))).hasMoreTokens()) continue;
            hashSet.add(((StringTokenizer)enumeration).nextToken());
            nArray[0] = resourceRecord2.getRRClass();
            break;
        }
        block15: for (String string3 : hashSet) {
            enumeration = this.lookup(string3, new int[]{1}, nArray);
            while (enumeration.hasMoreElements()) {
                resourceRecord = (ResourceRecord)enumeration.nextElement();
                object = (String)resourceRecord.getRData();
                try {
                    TransportMgr.sendReceiveTCP((String)object, 53, byArray, n3, byArray2, 65536, this.initialTimeout * this.timeoutRetries);
                    bl = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (DomainProtocolException domainProtocolException) {
                    // empty catch block
                }
                if (bl) {
                    message2 = new Message();
                    try {
                        Message.parseMessage(byArray2, 0, message2);
                        int n4 = message2.getRCode();
                        switch (n4) {
                            case 0: {
                                for (n = 0; n < 3; ++n) {
                                    switch (n) {
                                        case 0: {
                                            enumeration2 = message2.getAnswerRRs();
                                            break;
                                        }
                                        case 1: {
                                            enumeration2 = message2.getAuthorityRRs();
                                            break;
                                        }
                                        case 2: {
                                            enumeration2 = message2.getAdditionalRRs();
                                        }
                                    }
                                    while (enumeration2.hasMoreElements()) {
                                        ResourceRecord resourceRecord3 = enumeration2.nextElement();
                                        resolverCache.put(resourceRecord3);
                                        if (n != 0) continue;
                                        vector.addElement(resourceRecord3);
                                    }
                                }
                                bl2 = true;
                                break;
                            }
                            case 3: {
                                throw new NameNotFoundException(Messages.getString("jndi.6D", string));
                            }
                        }
                    }
                    catch (DomainProtocolException domainProtocolException) {
                        // empty catch block
                    }
                }
                if (!bl2) continue;
                break block15;
            }
        }
        if (!bl2) {
            throw new ServiceUnavailableException(Messages.getString("jndi.6E"));
        }
        if (string2 != null) {
            Vector<ResourceRecord> vector2 = new Vector<ResourceRecord>();
            for (int i = 0; i < vector.size(); ++i) {
                resourceRecord = (ResourceRecord)vector.elementAt(i);
                object = new StringTokenizer(resourceRecord.getName(), ".");
                String string4 = null;
                n = 0;
                if (((StringTokenizer)object).hasMoreTokens() && (string4 = ((StringTokenizer)object).nextToken()).length() > 0 && string4.charAt(0) == '_' && ((StringTokenizer)object).hasMoreTokens() && (string4 = ((StringTokenizer)object).nextToken()).equalsIgnoreCase(string2)) {
                    n = 1;
                }
                if (n == 0) continue;
                vector2.addElement(resourceRecord);
            }
            vector = vector2;
        }
        return vector.elements();
    }

    public void addInitialServer(String string, String string2, int n, String string3) {
        InetAddress inetAddress;
        SList.Server server = new SList.Server(string, string2, n);
        SList sList = SList.getInstance();
        if (string == null && string2 == null) {
            throw new NullPointerException(Messages.getString("jndi.6F"));
        }
        if (string3 == null) {
            throw new NullPointerException(Messages.getString("jndi.70"));
        }
        if (string2 == null && !sList.hasServer(string) && (inetAddress = TransportMgr.getIPByName_OS(string)) != null) {
            server.setIP(ProviderMgr.getIpStr(inetAddress.getAddress()));
        }
        if (!sList.hasServer(string3, server)) {
            sList.updateEntry(string3, server, SList.UNKNOWN);
        }
    }

    Message queryServers(Message message, String string, Hashtable<SList.Server, Object> hashtable, boolean bl) throws DomainProtocolException, SecurityException {
        SList sList = SList.getInstance();
        byte[] byArray = new byte[512];
        byte[] byArray2 = new byte[512];
        Message message2 = null;
        int n = 0;
        int n2 = this.initialTimeout;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = -1;
        if (!message.getQuestionRecords().hasMoreElements()) {
            throw new IllegalArgumentException(Messages.getString("jndi.71"));
        }
        QuestionRecord questionRecord = message.getQuestionRecords().nextElement();
        int n4 = message.writeBytes(byArray, 0);
        for (int i = 0; i < this.timeoutRetries; ++i) {
            HashSet<SList.Server> hashSet = new HashSet<SList.Server>();
            while (true) {
                int n5 = 0;
                bl2 = false;
                bl3 = false;
                n3 = -1;
                SList.Server server = sList.getBestGuess(string, hashtable);
                if (server == null || hashSet.contains(server)) break;
                if (server.getIP() == null) {
                    this.startResolvingThread(server.getName(), questionRecord.getQClass());
                    sList.updateEntry(string, server, SList.NETWORK_FAILURE);
                    hashSet.add(server);
                    continue;
                }
                try {
                    if (bl) {
                        TransportMgr.sendReceiveTCP(server.getIP(), server.getPort(), byArray, n4, byArray2, byArray2.length, n2);
                    } else {
                        TransportMgr.sendReceiveUDP(server.getIP(), server.getPort(), byArray, n4, byArray2, byArray2.length, n2);
                    }
                    bl2 = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    sList.updateEntry(string, server, SList.TIMEOUT);
                }
                catch (DomainProtocolException domainProtocolException) {
                    sList.updateEntry(string, server, SList.NETWORK_FAILURE);
                }
                if (bl2) {
                    try {
                        boolean bl5 = false;
                        message2 = new Message();
                        n = 0;
                        n = Message.parseMessage(byArray2, n, message2);
                        bl3 = true;
                        if (message2.isTc() && !bl) {
                            try {
                                TransportMgr.sendReceiveTCP(server.getIP(), server.getPort(), byArray, n4, byArray2, byArray2.length, n2);
                                Message message3 = new Message();
                                int n6 = Message.parseMessage(byArray2, 0, message3);
                                if (!message3.isTc()) {
                                    message2 = message3;
                                    n = n6;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (message2.isTc() && !message2.getAuthorityRRs().hasMoreElements() && !message2.getAdditionalRRs().hasMoreElements()) {
                            bl5 = true;
                        }
                        if ((n3 = message2.getRCode()) == 0) {
                            sList.updateEntry(string, server, n5);
                            hashtable.put(server, new Object());
                            if (!bl5) {
                                bl4 = true;
                                break;
                            }
                        } else if (n3 == 2) {
                            sList.updateEntry(string, server, SList.SERVER_FAILURE);
                            hashtable.put(server, new Object());
                        } else if (n3 == 1) {
                            sList.updateEntry(string, server, SList.SERVER_FAILURE);
                            hashtable.put(server, new Object());
                        } else if (n3 == 3) {
                            if (message2.isAA()) {
                                sList.updateEntry(string, server, n5);
                                hashtable.put(server, new Object());
                                bl4 = true;
                                break;
                            }
                            sList.updateEntry(string, server, SList.SERVER_FAILURE);
                            hashtable.put(server, new Object());
                        } else if (n3 == 4) {
                            sList.updateEntry(string, server, SList.SERVER_FAILURE);
                            hashtable.put(server, new Object());
                        } else if (n3 == 5) {
                            sList.updateEntry(string, server, SList.SERVER_FAILURE);
                            hashtable.put(server, new Object());
                        }
                    }
                    catch (DomainProtocolException domainProtocolException) {
                        sList.dropServer(string, server);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        sList.dropServer(string, server);
                    }
                }
                hashSet.add(server);
            }
            if (bl2 & bl3 & bl4) {
                return message2;
            }
            n2 *= 2;
        }
        return null;
    }

    AnalysisReport analyzeAnswer(Message message, Message message2) throws DomainProtocolException {
        Object object;
        Enumeration<ResourceRecord> enumeration;
        Object object2;
        Object object3;
        Enumeration<ResourceRecord> enumeration2;
        Object object4;
        ResourceRecord resourceRecord;
        Enumeration<QuestionRecord> enumeration3 = message.getQuestionRecords();
        Enumeration<ResourceRecord> enumeration4 = message2.getAnswerRRs();
        Enumeration<ResourceRecord> enumeration5 = message2.getAuthorityRRs();
        AnalysisReport analysisReport = new AnalysisReport();
        if (message.getId() != message2.getId()) {
            throw new DomainProtocolException(Messages.getString("jndi.72"));
        }
        if (!enumeration3.hasMoreElements()) {
            throw new IllegalArgumentException(Messages.getString("jndi.73"));
        }
        QuestionRecord questionRecord = enumeration3.nextElement();
        if (message2.getRCode() == 3) {
            analysisReport.nameError = true;
            return analysisReport;
        }
        if (message2.isTc()) {
            analysisReport.messageWasTruncated = true;
        }
        while (enumeration4.hasMoreElements()) {
            resourceRecord = enumeration4.nextElement();
            if (questionRecord.getQClass() != resourceRecord.getRRClass() && questionRecord.getQClass() != 255) continue;
            if (questionRecord.getQType() == 255 && ProviderMgr.namesAreEqual(resourceRecord.getName(), questionRecord.getQName())) {
                analysisReport.records.addElement(resourceRecord);
                if (resourceRecord.getRRType() == 5) {
                    analysisReport.aliasInfoWasReceived = true;
                    analysisReport.newName = (String)resourceRecord.getRData();
                    continue;
                }
                analysisReport.completeAnswerWasReceived = true;
                continue;
            }
            if (questionRecord.getQType() == resourceRecord.getRRType() && ProviderMgr.namesAreEqual(questionRecord.getQName(), resourceRecord.getName())) {
                analysisReport.records.addElement(resourceRecord);
                analysisReport.completeAnswerWasReceived = true;
                continue;
            }
            if (resourceRecord.getRRType() == 5 && ProviderMgr.namesAreEqual(resourceRecord.getName(), questionRecord.getQName())) {
                object4 = message2.getAnswerRRs();
                enumeration2 = message2.getAdditionalRRs();
                analysisReport.aliasInfoWasReceived = true;
                analysisReport.newName = (String)resourceRecord.getRData();
                analysisReport.extraRecords.addElement(resourceRecord);
                while (object4.hasMoreElements()) {
                    object3 = (ResourceRecord)object4.nextElement();
                    if (((ResourceRecord)object3).getRRType() != questionRecord.getQType() || !ProviderMgr.namesAreEqual(((ResourceRecord)object3).getName(), analysisReport.newName)) continue;
                    analysisReport.records.addElement((ResourceRecord)object3);
                    analysisReport.completeAnswerWasReceived = true;
                }
                while (enumeration2.hasMoreElements()) {
                    object3 = enumeration2.nextElement();
                    if (((ResourceRecord)object3).getRRType() != questionRecord.getQType() || !ProviderMgr.namesAreEqual(((ResourceRecord)object3).getName(), analysisReport.newName)) continue;
                    analysisReport.records.addElement((ResourceRecord)object3);
                    analysisReport.completeAnswerWasReceived = true;
                }
                continue;
            }
            if (message2.isAA()) {
                analysisReport.completeAnswerWasReceived = true;
            }
            analysisReport.extraRecords.addElement(resourceRecord);
        }
        while (enumeration5.hasMoreElements()) {
            resourceRecord = enumeration5.nextElement();
            object4 = SList.getInstance();
            analysisReport.extraRecords.addElement(resourceRecord);
            if (resourceRecord.getRRType() != 2) continue;
            enumeration2 = (String)resourceRecord.getRData();
            object3 = new SList.Server((String)((Object)enumeration2), null, 53);
            object2 = ((SList)object4).getServerByServer(resourceRecord.getName(), (SList.Server)object3);
            analysisReport.delegationArrived = true;
            if (object2 == null) {
                ((SList)object4).updateEntry(resourceRecord.getName(), (SList.Server)object3, SList.UNKNOWN);
                analysisReport.delegationZones.addElement(resourceRecord.getName());
                object2 = object3;
            }
            if (object2 == null || ((SList.Server)object2).getIP() != null) continue;
            enumeration = message2.getAdditionalRRs();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!ProviderMgr.namesAreEqual(((ResourceRecord)object).getName(), enumeration2) || ((ResourceRecord)object).getRRType() != 1) continue;
                ((SList.Server)object2).setIP((String)((ResourceRecord)object).getRData());
            }
            if (((SList.Server)object2).getIP() != null) continue;
            this.startResolvingThread(((SList.Server)object2).getName(), resourceRecord.getRRClass());
        }
        enumeration = message2.getAdditionalRRs();
        while (enumeration.hasMoreElements()) {
            resourceRecord = enumeration.nextElement();
            analysisReport.extraRecords.addElement(resourceRecord);
        }
        for (int i = 0; i < 2; ++i) {
            object4 = null;
            enumeration2 = new HashSet();
            switch (i) {
                case 0: {
                    object4 = analysisReport.records;
                    break;
                }
                case 1: {
                    object4 = analysisReport.extraRecords;
                }
            }
            for (int j = 0; j < ((Vector)object4).size(); ++j) {
                ResourceRecord resourceRecord2;
                int n;
                object2 = ((Vector)object4).elementAt(j);
                object = ((ResourceRecord)object2).getName() + " " + ((ResourceRecord)object2).getRRClass() + " " + ((ResourceRecord)object2).getRRType();
                long l = ((ResourceRecord)object2).getTtl();
                Vector<Object> vector = new Vector<Object>();
                if (((HashSet)((Object)enumeration2)).contains(object)) continue;
                vector.addElement(object2);
                for (n = j; n < ((Vector)object4).size(); ++n) {
                    resourceRecord2 = (ResourceRecord)((Vector)object4).elementAt(n);
                    String string = resourceRecord2.getName() + " " + resourceRecord2.getRRClass() + " " + resourceRecord2.getRRType();
                    long l2 = resourceRecord2.getTtl();
                    if (((HashSet)((Object)enumeration2)).contains(string) || !((String)object).equals(string)) continue;
                    if (l > l2) {
                        l = l2;
                    }
                    vector.addElement(resourceRecord2);
                }
                for (n = 0; n < vector.size(); ++n) {
                    resourceRecord2 = (ResourceRecord)vector.elementAt(n);
                    if (resourceRecord2.getTtl() == l) continue;
                    resourceRecord2.setTtl(l);
                }
                ((HashSet)((Object)enumeration2)).add((ResourceRecord)object);
            }
        }
        return analysisReport;
    }

    static Message createMessageForSending(String string, int n, int n2) throws DomainProtocolException {
        Message message = new Message();
        QuestionRecord questionRecord = new QuestionRecord();
        message.setId(rndGen.nextInt() & 0xFFFF);
        message.setQR(false);
        message.setOpCode(0);
        message.setRD(true);
        message.setQDCount(1);
        questionRecord.setQName(string);
        questionRecord.setQType(n);
        questionRecord.setQClass(n2);
        message.addQuestionRecord(questionRecord);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startResolvingThread(String string, int n) {
        int[] nArray = new int[1];
        Object object = this.threadListSemaphore;
        synchronized (object) {
            ThreadListEntry threadListEntry;
            int n2;
            for (n2 = 0; n2 < this.resolverThreads.size(); ++n2) {
                threadListEntry = this.resolverThreads.get(n2);
                if (!ProviderMgr.namesAreEqual(string, threadListEntry.serverNameToResolve) || threadListEntry.dnsClass != n) continue;
                return;
            }
            for (n2 = 0; n2 < this.hostnamesToResolve.size(); ++n2) {
                threadListEntry = this.hostnamesToResolve.get(n2);
                if (!ProviderMgr.namesAreEqual(string, threadListEntry.serverNameToResolve) || threadListEntry.dnsClass != n) continue;
                return;
            }
            if (this.resolverThreads.size() >= this.threadNumberLimit) {
                return;
            }
            nArray[0] = n;
            ThreadListEntry threadListEntry2 = new ThreadListEntry();
            threadListEntry2.serverNameToResolve = string;
            threadListEntry2.dnsClass = n;
            this.hostnamesToResolve.add(threadListEntry2);
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadListEntry threadListEntry;
        SList sList = SList.getInstance();
        int[] nArray = new int[1];
        Object object = this.threadListSemaphore;
        synchronized (object) {
            if (this.hostnamesToResolve.size() <= 0) {
                return;
            }
            threadListEntry = this.hostnamesToResolve.get(0);
            this.hostnamesToResolve.remove(0);
            threadListEntry.thread = Thread.currentThread();
            this.resolverThreads.add(threadListEntry);
        }
        try {
            nArray[0] = threadListEntry.dnsClass;
            Enumeration<ResourceRecord> enumeration = this.lookup(threadListEntry.serverNameToResolve, new int[]{1}, nArray);
            while (enumeration != null && enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (((ResourceRecord)object).getRRType() != 1) continue;
                sList.setServerIP(threadListEntry.serverNameToResolve, (String)((ResourceRecord)object).getRData());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        object = this.threadListSemaphore;
        synchronized (object) {
            for (int i = 0; i < this.resolverThreads.size(); ++i) {
                ThreadListEntry threadListEntry2 = this.resolverThreads.get(i);
                if (!ProviderMgr.namesAreEqual(threadListEntry.serverNameToResolve, threadListEntry2.serverNameToResolve) || threadListEntry.dnsClass != threadListEntry2.dnsClass) continue;
                this.resolverThreads.remove(i);
                break;
            }
        }
    }

    static class AnalysisReport {
        boolean completeAnswerWasReceived = false;
        boolean nameError = false;
        boolean delegationArrived = false;
        boolean aliasInfoWasReceived = false;
        boolean messageWasTruncated = false;
        Vector<ResourceRecord> records = new Vector();
        Vector<String> delegationZones = new Vector();
        String newName = null;
        Vector<ResourceRecord> extraRecords = new Vector();

        AnalysisReport() {
        }
    }

    private class ThreadListSemaphore {
        private ThreadListSemaphore() {
        }
    }

    private static class ThreadListEntry {
        Thread thread;
        String serverNameToResolve;
        int dnsClass;

        private ThreadListEntry() {
        }
    }
}

