/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderConstants;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

public class QuestionRecord {
    private String qName;
    private int qType;
    private int qClass;

    public QuestionRecord() {
    }

    public QuestionRecord(String string, int n, int n2) {
        this.qName = string;
        this.qType = n;
        this.qClass = n2;
    }

    public int writeBytes(byte[] byArray, int n) throws DomainProtocolException {
        int n2 = n;
        if (byArray == null) {
            throw new DomainProtocolException(Messages.getString("jndi.32"));
        }
        if (n >= byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n2 = ProviderMgr.writeName(this.qName, byArray, n2);
        n2 = ProviderMgr.write16Int(this.qType, byArray, n2);
        n2 = ProviderMgr.write16Int(this.qClass, byArray, n2);
        return n2;
    }

    public static int parseRecord(byte[] byArray, int n, QuestionRecord questionRecord) throws DomainProtocolException {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer();
        if (questionRecord == null) {
            throw new NullPointerException(Messages.getString("jndi.33"));
        }
        n2 = ProviderMgr.parseName(byArray, n2, stringBuffer);
        questionRecord.setQName(stringBuffer.toString());
        questionRecord.setQType(ProviderMgr.parse16Int(byArray, n2));
        questionRecord.setQClass(ProviderMgr.parse16Int(byArray, n2 += 2));
        return n2 += 2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.qType > 0 && this.qType < 256 ? ProviderConstants.rrTypeNames[this.qType] : String.valueOf(this.qType);
        String string2 = this.qClass > 0 && this.qClass < 256 ? ProviderConstants.rrClassNames[this.qClass] : String.valueOf(this.qClass);
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.qName);
        return stringBuffer.toString();
    }

    public int getQClass() {
        return this.qClass;
    }

    public void setQClass(int n) {
        this.qClass = n;
    }

    public String getQName() {
        return this.qName;
    }

    public void setQName(String string) {
        this.qName = string;
    }

    public int getQType() {
        return this.qType;
    }

    public void setQType(int n) {
        this.qType = n;
    }
}

